/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.JavadocVisitor;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Javadoc;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.java.tree.TypedTree;

public class UnnecessaryThrows
extends Recipe {
    public String getDisplayName() {
        return "Unnecessary throws";
    }

    public String getDescription() {
        return "Remove unnecessary `throws` declarations. This recipe will only remove unused, checked exception if:\n\n- The declaring class or the method declaration is `final`.\n- The method declaration is `static` or `private`.\n- If the method overriding a method declaration in a super class and the super does not throw the exception.\n- If the method is `public` or `protected` and the exception is not documented via a JavaDoc as a `@throws` tag.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1130");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J m = super.visitMethodDeclaration(method, ctx);
                final Set unusedThrows = UnnecessaryThrows.this.findExceptionCandidates(method);
                if (!unusedThrows.isEmpty()) {
                    new JavaIsoVisitor<ExecutionContext>(){

                        @Nullable
                        public J visit(@Nullable Tree tree, ExecutionContext ctx) {
                            if (unusedThrows.isEmpty()) {
                                return (J)tree;
                            }
                            return (J)super.visit(tree, (Object)ctx);
                        }

                        @Override
                        public J.Try.Resource visitTryResource(J.Try.Resource tryResource, ExecutionContext executionContext) {
                            TypedTree resource = tryResource.getVariableDeclarations();
                            JavaType.FullyQualified resourceType = TypeUtils.asFullyQualified(resource.getType());
                            if (resourceType != null) {
                                if (TypeUtils.isAssignableTo(JavaType.Class.build("java.io.Closeable"), (JavaType)resourceType)) {
                                    unusedThrows.remove(JavaType.Class.build("java.io.IOException"));
                                } else if (TypeUtils.isAssignableTo(JavaType.Class.build("java.lang.AutoCloseable"), (JavaType)resourceType)) {
                                    unusedThrows.remove(JavaType.Class.build("java.lang.Exception"));
                                }
                            }
                            return super.visitTryResource(tryResource, executionContext);
                        }

                        @Override
                        public J.Throw visitThrow(J.Throw thrown, ExecutionContext executionContext) {
                            JavaType.FullyQualified type = TypeUtils.asFullyQualified(thrown.getException().getType());
                            if (type != null) {
                                unusedThrows.removeIf(t -> TypeUtils.isAssignableTo(t, (JavaType)type));
                            }
                            return thrown;
                        }

                        @Override
                        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                            this.removeThrownTypes(method.getMethodType());
                            return super.visitMethodInvocation(method, ctx);
                        }

                        @Override
                        public J.NewClass visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
                            this.removeThrownTypes(newClass.getConstructorType());
                            return super.visitNewClass(newClass, ctx);
                        }

                        private void removeThrownTypes(@Nullable JavaType.Method type) {
                            if (type != null) {
                                for (JavaType.FullyQualified thrownException : type.getThrownExceptions()) {
                                    unusedThrows.removeIf(t -> TypeUtils.isAssignableTo(t, (JavaType)thrownException));
                                }
                            }
                        }
                    }.visit(m, ctx);
                    if (!unusedThrows.isEmpty()) {
                        m = ((J.MethodDeclaration)m).withThrows(ListUtils.map(((J.MethodDeclaration)m).getThrows(), t -> {
                            JavaType.FullyQualified type = TypeUtils.asFullyQualified(t.getType());
                            if (type != null && unusedThrows.contains(type)) {
                                this.maybeRemoveImport(type);
                                return null;
                            }
                            return t;
                        }));
                    }
                }
                return m;
            }
        };
    }

    private Set<JavaType.FullyQualified> findExceptionCandidates(@Nullable J.MethodDeclaration method) {
        if (method == null || method.getMethodType() == null || method.isAbstract()) {
            return Collections.emptySet();
        }
        TreeSet<JavaType.FullyQualified> candidates = new TreeSet<JavaType.FullyQualified>(Comparator.comparing(JavaType.FullyQualified::getFullyQualifiedName));
        for (JavaType.FullyQualified exception : method.getMethodType().getThrownExceptions()) {
            if (TypeUtils.isAssignableTo(JavaType.Class.build("java.lang.RuntimeException"), (JavaType)exception)) continue;
            candidates.add(exception);
        }
        if (candidates.isEmpty()) {
            return Collections.emptySet();
        }
        if (method.getMethodType().getDeclaringType() != null && method.getMethodType().getDeclaringType().getFlags().contains((Object)Flag.Final) || method.isAbstract() || method.hasModifier(J.Modifier.Type.Static) || method.hasModifier(J.Modifier.Type.Private) || method.hasModifier(J.Modifier.Type.Final)) {
            return candidates;
        }
        Optional<JavaType.Method> superMethod = TypeUtils.findOverriddenMethod(method.getMethodType());
        if (superMethod.isPresent()) {
            JavaType.Method baseMethod = superMethod.get();
            baseMethod.getThrownExceptions();
            for (JavaType.FullyQualified baseException : baseMethod.getThrownExceptions()) {
                candidates.remove(baseException);
            }
        }
        if (!candidates.isEmpty()) {
            new JavaVisitor<Set<JavaType.FullyQualified>>(){

                @Override
                protected JavadocVisitor<Set<JavaType.FullyQualified>> getJavadocVisitor() {
                    return new JavadocVisitor<Set<JavaType.FullyQualified>>((JavaVisitor)this){

                        @Override
                        public Javadoc visitThrows(Javadoc.Throws aThrows, Set<JavaType.FullyQualified> candidates) {
                            JavaType.FullyQualified exceptionType;
                            if (aThrows.getExceptionName() instanceof TypeTree && (exceptionType = TypeUtils.asFullyQualified(((TypeTree)aThrows.getExceptionName()).getType())) != null) {
                                candidates.remove(exceptionType);
                            }
                            return super.visitThrows(aThrows, candidates);
                        }
                    };
                }
            }.visit(method, candidates);
        }
        return candidates;
    }
}

