/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.DeleteStatement;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.format.ShiftFormat;
import org.openrewrite.java.style.EmptyBlockStyle;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.marker.Markers;

public final class EmptyBlockVisitor<P>
extends JavaIsoVisitor<P> {
    private final EmptyBlockStyle emptyBlockStyle;
    private final JavaTemplate throwException = JavaTemplate.builder(() -> ((EmptyBlockVisitor)this).getCursor(), "throw new #{}(#{any(String)});").imports("java.io.UncheckedIOException").build();
    private final JavaTemplate continueStatement = JavaTemplate.builder(() -> ((EmptyBlockVisitor)this).getCursor(), "continue;").build();

    @Override
    public J.WhileLoop visitWhileLoop(J.WhileLoop whileLoop, P p) {
        J w = super.visitWhileLoop(whileLoop, (Object)p);
        if (Boolean.TRUE.equals(this.emptyBlockStyle.getLiteralWhile()) && this.isEmptyBlock(((J.WhileLoop)w).getBody())) {
            J.Block body = (J.Block)((J.WhileLoop)w).getBody();
            w = (J.WhileLoop)w.withTemplate(this.continueStatement, body.getCoordinates().lastStatement(), new Object[0]);
        }
        return w;
    }

    @Override
    public J.DoWhileLoop visitDoWhileLoop(J.DoWhileLoop doWhileLoop, P p) {
        J w = super.visitDoWhileLoop(doWhileLoop, (Object)p);
        if (Boolean.TRUE.equals(this.emptyBlockStyle.getLiteralWhile()) && this.isEmptyBlock(((J.DoWhileLoop)w).getBody())) {
            J.Block body = (J.Block)((J.DoWhileLoop)w).getBody();
            w = (J.DoWhileLoop)w.withTemplate(this.continueStatement, body.getCoordinates().lastStatement(), new Object[0]);
        }
        return w;
    }

    @Override
    public J.Block visitBlock(J.Block block, P p) {
        J b = super.visitBlock(block, (Object)p);
        AtomicBoolean filtered = new AtomicBoolean(false);
        List statements = ListUtils.map(((J.Block)b).getStatements(), s -> {
            if (!(s instanceof J.Block)) {
                return s;
            }
            J.Block nestedBlock = (J.Block)s;
            if (this.isEmptyBlock(nestedBlock) && (Boolean.TRUE.equals(this.emptyBlockStyle.getStaticInit()) && nestedBlock.isStatic() || Boolean.TRUE.equals(this.emptyBlockStyle.getInstanceInit()) && !nestedBlock.isStatic())) {
                filtered.set(true);
                return null;
            }
            return nestedBlock;
        });
        return filtered.get() ? ((J.Block)b).withStatements(statements) : b;
    }

    @Override
    public J.Try visitTry(J.Try tryable, P p) {
        J t = super.visitTry(tryable, (Object)p);
        if (Boolean.TRUE.equals(this.emptyBlockStyle.getLiteralTry()) && this.isEmptyBlock(((J.Try)t).getBody())) {
            this.doAfterVisit(new DeleteStatement(tryable));
        } else if (Boolean.TRUE.equals(this.emptyBlockStyle.getLiteralFinally()) && ((J.Try)t).getFinally() != null && this.isEmptyBlock(((J.Try)t).getFinally())) {
            t = ((J.Try)t).withFinally(null);
        }
        return t;
    }

    @Override
    public J.If visitIf(J.If iff, P p) {
        J i = super.visitIf(iff, (Object)p);
        if (Boolean.FALSE.equals(this.emptyBlockStyle.getLiteralIf()) || !this.isEmptyBlock(((J.If)i).getThenPart())) {
            return i;
        }
        if (((J.If)i).getElsePart() == null) {
            J.Block enclosingBlock = (J.Block)this.getCursor().firstEnclosing(J.Block.class);
            if (enclosingBlock != null) {
                this.doAfterVisit(new ExtractSideEffectsOfIfCondition(enclosingBlock, (J.If)i));
            }
            return i;
        }
        J.ControlParentheses<Expression> cond = ((J.If)i).getIfCondition();
        if (!(cond.getTree() instanceof J.Binary)) {
            return i;
        }
        J.Binary binary = (J.Binary)cond.getTree();
        switch (binary.getOperator()) {
            case Equal: {
                cond = cond.withTree(binary.withOperator(J.Binary.Type.NotEqual));
                break;
            }
            case NotEqual: {
                cond = cond.withTree(binary.withOperator(J.Binary.Type.Equal));
                break;
            }
            case LessThan: {
                cond = cond.withTree(binary.withOperator(J.Binary.Type.GreaterThanOrEqual));
                break;
            }
            case LessThanOrEqual: {
                cond = cond.withTree(binary.withOperator(J.Binary.Type.GreaterThan));
                break;
            }
            case GreaterThan: {
                cond = cond.withTree(binary.withOperator(J.Binary.Type.LessThanOrEqual));
                break;
            }
            case GreaterThanOrEqual: {
                cond = cond.withTree(binary.withOperator(J.Binary.Type.LessThan));
                break;
            }
        }
        i = ((J.If)i).withIfCondition(cond);
        if (((J.If)i).getElsePart() == null) {
            return ((J.If)i).withThenPart(new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY)).withElsePart(null);
        }
        J.Block thenPart = (J.Block)((J.If)i).getThenPart();
        Statement elseStatement = ((J.If)i).getElsePart().getBody();
        List<Statement> elseStatementBody = elseStatement instanceof J.Block ? ((J.Block)elseStatement).getStatements() : (elseStatement instanceof J.If ? Collections.singletonList((Statement)ShiftFormat.indent(elseStatement.withPrefix(Space.format("\n" + ((J.If)i).getPrefix().getIndent())), this.getCursor(), 1)) : Collections.singletonList((Statement)ShiftFormat.indent(elseStatement, this.getCursor(), 1)));
        return ((J.If)i).withThenPart(thenPart.withStatements(elseStatementBody)).withElsePart(null);
    }

    @Override
    public J.Synchronized visitSynchronized(J.Synchronized synch, P p) {
        if (Boolean.TRUE.equals(this.emptyBlockStyle.getLiteralSynchronized()) && this.isEmptyBlock(synch.getBody())) {
            this.doAfterVisit(new DeleteStatement(synch));
        }
        return super.visitSynchronized(synch, (Object)p);
    }

    @Override
    public J.Switch visitSwitch(J.Switch switzh, P p) {
        if (Boolean.TRUE.equals(this.emptyBlockStyle.getLiteralSwitch()) && this.isEmptyBlock(switzh.getCases())) {
            this.doAfterVisit(new DeleteStatement(switzh));
        }
        return super.visitSwitch(switzh, (Object)p);
    }

    private boolean isEmptyBlock(Statement blockNode) {
        if (blockNode instanceof J.Block) {
            J.Block block = (J.Block)blockNode;
            if (EmptyBlockStyle.BlockPolicy.STATEMENT.equals((Object)this.emptyBlockStyle.getBlockPolicy())) {
                return block.getStatements().isEmpty();
            }
            if (EmptyBlockStyle.BlockPolicy.TEXT.equals((Object)this.emptyBlockStyle.getBlockPolicy())) {
                return block.getStatements().isEmpty() && block.getEnd().getComments().isEmpty();
            }
        }
        return false;
    }

    public EmptyBlockVisitor(EmptyBlockStyle emptyBlockStyle) {
        this.emptyBlockStyle = emptyBlockStyle;
    }

    public EmptyBlockStyle getEmptyBlockStyle() {
        return this.emptyBlockStyle;
    }

    public JavaTemplate getThrowException() {
        return this.throwException;
    }

    public JavaTemplate getContinueStatement() {
        return this.continueStatement;
    }

    @NonNull
    public String toString() {
        return "EmptyBlockVisitor(emptyBlockStyle=" + this.getEmptyBlockStyle() + ", throwException=" + this.getThrowException() + ", continueStatement=" + this.getContinueStatement() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EmptyBlockVisitor)) {
            return false;
        }
        EmptyBlockVisitor other = (EmptyBlockVisitor)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EmptyBlockStyle this$emptyBlockStyle = this.getEmptyBlockStyle();
        EmptyBlockStyle other$emptyBlockStyle = other.getEmptyBlockStyle();
        if (this$emptyBlockStyle == null ? other$emptyBlockStyle != null : !((Object)this$emptyBlockStyle).equals(other$emptyBlockStyle)) {
            return false;
        }
        JavaTemplate this$throwException = this.getThrowException();
        JavaTemplate other$throwException = other.getThrowException();
        if (this$throwException == null ? other$throwException != null : !this$throwException.equals(other$throwException)) {
            return false;
        }
        JavaTemplate this$continueStatement = this.getContinueStatement();
        JavaTemplate other$continueStatement = other.getContinueStatement();
        return !(this$continueStatement == null ? other$continueStatement != null : !this$continueStatement.equals(other$continueStatement));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof EmptyBlockVisitor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        EmptyBlockStyle $emptyBlockStyle = this.getEmptyBlockStyle();
        result = result * 59 + ($emptyBlockStyle == null ? 43 : ((Object)$emptyBlockStyle).hashCode());
        JavaTemplate $throwException = this.getThrowException();
        result = result * 59 + ($throwException == null ? 43 : $throwException.hashCode());
        JavaTemplate $continueStatement = this.getContinueStatement();
        result = result * 59 + ($continueStatement == null ? 43 : $continueStatement.hashCode());
        return result;
    }

    private static class ExtractSideEffectsOfIfCondition<P>
    extends JavaVisitor<P> {
        private final J.Block enclosingBlock;
        private final J.If toExtract;

        public ExtractSideEffectsOfIfCondition(J.Block enclosingBlock, J.If toExtract) {
            this.enclosingBlock = enclosingBlock;
            this.toExtract = toExtract;
        }

        @Override
        public J visitBlock(J.Block block, P p) {
            J.Block b = (J.Block)super.visitBlock(block, p);
            if (this.enclosingBlock.isScope(block)) {
                ArrayList<Statement> statements = new ArrayList<Statement>(b.getStatements().size());
                for (Statement statement : b.getStatements()) {
                    if (statement == this.toExtract) {
                        for (J sideEffect : this.toExtract.getIfCondition().getTree().getSideEffects()) {
                            sideEffect = this.autoFormat(sideEffect, p, this.getCursor());
                            statements.add((Statement)sideEffect);
                        }
                        continue;
                    }
                    statements.add(statement);
                }
                b = b.withStatements(statements);
            }
            return b;
        }
    }
}

