/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import io.github.classgraph.ClassGraph;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.internal.JavaTypeCache;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.java.tree.J;
import org.openrewrite.style.NamedStyles;

public interface JavaParser
extends Parser<J.CompilationUnit> {
    public static final String SKIP_SOURCE_SET_TYPE_GENERATION = "org.openrewrite.java.skipSourceSetTypeGeneration";
    @Deprecated
    public static final List<Path> runtimeClasspath = Collections.unmodifiableList(Arrays.stream(System.getProperty("java.class.path").split("\\Q" + System.getProperty("path.separator") + "\\E")).map(cpEntry -> new File((String)cpEntry).toPath()).collect(Collectors.toList()));

    public static List<Path> runtimeClasspath() {
        return new ClassGraph().disableNestedJarScanning().getClasspathURIs().stream().map(Paths::get).collect(Collectors.toList());
    }

    public static List<Path> dependenciesFromClasspath(String ... artifactNames) {
        Map artifactNamePatterns = Arrays.stream(artifactNames).collect(Collectors.toMap(Function.identity(), name -> Pattern.compile(name + "-.*?\\.jar$")));
        HashSet<String> foundArtifacts = new HashSet<String>();
        ArrayList<Path> artifacts = new ArrayList<Path>();
        List runtimeClasspath = new ClassGraph().getClasspathURIs();
        for (URI cpEntry : runtimeClasspath) {
            for (Map.Entry artifactNamePattern : artifactNamePatterns.entrySet()) {
                if (!artifactNamePattern.getValue().matcher(cpEntry.toString()).find()) continue;
                artifacts.add(Paths.get(cpEntry));
                foundArtifacts.add((String)artifactNamePattern.getKey());
            }
        }
        for (String foundArtifact : foundArtifacts) {
            artifactNamePatterns.remove(foundArtifact);
        }
        if (!artifactNamePatterns.isEmpty()) {
            throw new IllegalArgumentException("Unable to find runtime dependencies beginning with: " + artifactNamePatterns.keySet().stream().map(a -> "'" + a + "'").sorted().collect(Collectors.joining(", ")));
        }
        return artifacts;
    }

    public static Builder<? extends JavaParser, ?> fromJavaVersion() {
        Builder javaParser;
        try {
            javaParser = System.getProperty("java.version").startsWith("1.8") ? (Builder)Class.forName("org.openrewrite.java.Java8Parser").getDeclaredMethod("builder", new Class[0]).invoke(null, new Object[0]) : (Builder)Class.forName("org.openrewrite.java.Java11Parser").getDeclaredMethod("builder", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to create a Java parser instance. `rewrite-java-8` or `rewrite-java-11` must be on the classpath.", e);
        }
        return javaParser;
    }

    default public List<J.CompilationUnit> parse(ExecutionContext ctx, String ... sources) {
        Pattern packagePattern = Pattern.compile("^package\\s+([^;]+);");
        Pattern classPattern = Pattern.compile("(class|interface|enum)\\s*(<[^>]*>)?\\s+(\\w+)");
        Function<String, String> simpleName = sourceStr -> {
            Matcher classMatcher = classPattern.matcher((CharSequence)sourceStr);
            return classMatcher.find() ? classMatcher.group(3) : null;
        };
        return this.parseInputs(Arrays.stream(sources).map(sourceFile -> {
            Matcher packageMatcher = packagePattern.matcher((CharSequence)sourceFile);
            String pkg = packageMatcher.find() ? packageMatcher.group(1).replace('.', '/') + "/" : "";
            String className = Optional.ofNullable((String)simpleName.apply((String)sourceFile)).orElse(Long.toString(System.nanoTime())) + ".java";
            Path path = Paths.get(pkg + className, new String[0]);
            return new Parser.Input(path, () -> new ByteArrayInputStream(sourceFile.getBytes()));
        }).collect(Collectors.toList()), null, ctx);
    }

    default public List<J.CompilationUnit> parse(String ... sources) {
        InMemoryExecutionContext ctx = new InMemoryExecutionContext();
        return this.parse((ExecutionContext)ctx, sources);
    }

    default public boolean accept(Path path) {
        return path.toString().endsWith(".java");
    }

    public JavaParser reset();

    public void setClasspath(Collection<Path> var1);

    public void setSourceSet(String var1);

    public JavaSourceSet getSourceSet(ExecutionContext var1);

    public static abstract class Builder<P extends JavaParser, B extends Builder<P, B>> {
        protected Collection<Path> classpath = Collections.emptyList();
        protected Collection<byte[]> classBytesClasspath = Collections.emptyList();
        protected JavaTypeCache javaTypeCache = new JavaTypeCache();
        @Nullable
        protected Collection<Parser.Input> dependsOn;
        protected Charset charset = Charset.defaultCharset();
        protected boolean logCompilationWarningsAndErrors = false;
        protected final List<NamedStyles> styles = new ArrayList<NamedStyles>();

        public B logCompilationWarningsAndErrors(boolean logCompilationWarningsAndErrors) {
            this.logCompilationWarningsAndErrors = logCompilationWarningsAndErrors;
            return (B)this;
        }

        public B typeCache(JavaTypeCache javaTypeCache) {
            this.javaTypeCache = javaTypeCache;
            return (B)this;
        }

        public B charset(Charset charset) {
            this.charset = charset;
            return (B)this;
        }

        public B dependsOn(Collection<Parser.Input> inputs) {
            this.dependsOn = inputs;
            return (B)this;
        }

        public B dependsOn(String ... inputsAsStrings) {
            this.dependsOn = Arrays.stream(inputsAsStrings).map(Parser.Input::fromString).collect(Collectors.toList());
            return (B)this;
        }

        public B classpath(Collection<Path> classpath) {
            this.classpath = classpath;
            return (B)this;
        }

        public B classpath(String ... classpath) {
            this.classpath = JavaParser.dependenciesFromClasspath(classpath);
            return (B)this;
        }

        public B classpath(byte[] ... classpath) {
            this.classBytesClasspath = Arrays.asList(classpath);
            return (B)this;
        }

        public B styles(Iterable<? extends NamedStyles> styles) {
            for (NamedStyles namedStyles : styles) {
                this.styles.add(namedStyles);
            }
            return (B)this;
        }

        public abstract P build();
    }
}

