/*
 * Copyright 2021 the original author or authors.
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 * https://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.openrewrite.java.cleanup;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.java.JavaIsoVisitor;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;

public class FinalClass extends Recipe {
    @Override
    public String getDisplayName() {
        return "Finalize classes with private constructors";
    }

    @Override
    public String getDescription() {
        return "Adds the `final` modifier to classes that expose no public or package-private constructors.";
    }

    @Override
    public Set<String> getTags() {
        return Collections.singleton("RSPEC-2974");
    }

    @Override
    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5);
    }

    @Override
    protected JavaIsoVisitor<ExecutionContext> getVisitor() {
        return new FinalClassVisitor();
    }
}
