/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTypeVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.internal.template.JavaTemplateParser;
import org.openrewrite.java.internal.template.Substitutions;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.marker.Markers;
import org.openrewrite.template.SourceTemplate;

public class JavaTemplate
implements SourceTemplate<J, JavaCoordinates> {
    private static final J.Block EMPTY_BLOCK = new J.Block(Tree.randomId(), Space.EMPTY, Markers.EMPTY, new JRightPadded<Boolean>(false, Space.EMPTY, Markers.EMPTY), Collections.emptyList(), Space.format(" "));
    private final Supplier<Cursor> parentScopeGetter;
    private final String code;
    private final int parameterCount;
    private final Consumer<String> onAfterVariableSubstitution;
    private final JavaTemplateParser templateParser;

    private JavaTemplate(Supplier<Cursor> parentScopeGetter, Supplier<JavaParser> parser, String code, Set<String> imports, Consumer<String> onAfterVariableSubstitution, Consumer<String> onBeforeParseTemplate) {
        this.parentScopeGetter = parentScopeGetter;
        this.code = code;
        this.onAfterVariableSubstitution = onAfterVariableSubstitution;
        this.parameterCount = StringUtils.countOccurrences((String)code, (String)"#{");
        this.templateParser = new JavaTemplateParser(parser, onAfterVariableSubstitution, onBeforeParseTemplate, imports);
    }

    public <J2 extends J> J2 withTemplate(final Tree changing, final JavaCoordinates coordinates, Object[] parameters) {
        if (parameters.length != this.parameterCount) {
            throw new IllegalArgumentException("This template requires " + this.parameterCount + " parameters.");
        }
        final Substitutions substitutions = new Substitutions(this.code, parameters);
        final String substitutedTemplate = substitutions.substitute();
        this.onAfterVariableSubstitution.accept(substitutedTemplate);
        final J insertionPoint = coordinates.getTree();
        final Space.Location loc = coordinates.getSpaceLocation();
        final JavaCoordinates.Mode mode = coordinates.getMode();
        final AtomicReference parentCursorRef = new AtomicReference();
        new JavaIsoVisitor<Integer>(){

            @Nullable
            public J visit(@Nullable Tree tree, Integer integer) {
                if (tree != null && tree.isScope(changing)) {
                    parentCursorRef.set(this.getCursor());
                    return (J)tree;
                }
                return (J)super.visit(tree, (Object)integer);
            }
        }.visit((Tree)this.parentScopeGetter.get().getValue(), 0, this.parentScopeGetter.get().getParentOrThrow());
        Cursor parentCursor = (Cursor)parentCursorRef.get();
        return (J2)((J)new JavaVisitor<Integer>(){

            @Override
            public J visitAnnotation(J.Annotation annotation, Integer integer) {
                if (loc.equals((Object)Space.Location.ANNOTATION_PREFIX) && mode.equals((Object)JavaCoordinates.Mode.REPLACEMENT) && annotation.isScope(insertionPoint)) {
                    List<J.Annotation> gen = substitutions.unsubstitute(JavaTemplate.this.templateParser.parseAnnotations(this.getCursor(), substitutedTemplate));
                    return gen.get(0).withPrefix(annotation.getPrefix());
                }
                return super.visitAnnotation(annotation, integer);
            }

            @Override
            public J visitBlock(J.Block block, Integer p) {
                switch (loc) {
                    case BLOCK_END: {
                        if (block.isScope(insertionPoint)) {
                            List<Statement> gen = substitutions.unsubstitute(JavaTemplate.this.templateParser.parseBlockStatements(new Cursor(this.getCursor(), (Object)insertionPoint), Statement.class, substitutedTemplate, false, loc));
                            return block.withStatements(ListUtils.concatAll(block.getStatements(), (List)ListUtils.map(gen, (i, s) -> this.autoFormat(i == 0 ? (Statement)s.withPrefix(Space.format("\n")) : s, p, this.getCursor()))));
                        }
                    }
                    case STATEMENT_PREFIX: {
                        return block.withStatements(ListUtils.flatMap(block.getStatements(), statement -> {
                            if (statement.isScope(insertionPoint)) {
                                List<Statement> gen = substitutions.unsubstitute(JavaTemplate.this.templateParser.parseBlockStatements(new Cursor(this.getCursor(), (Object)insertionPoint), Statement.class, substitutedTemplate, false, loc));
                                Cursor parent = this.getCursor();
                                for (int i = 0; i < gen.size(); ++i) {
                                    Statement s = gen.get(i);
                                    Statement formattedS = this.autoFormat(i == 0 ? (Statement)s.withPrefix(statement.getPrefix().withComments(Collections.emptyList())) : s, p, parent);
                                    gen.set(i, formattedS);
                                }
                                switch (mode) {
                                    case REPLACEMENT: {
                                        return gen;
                                    }
                                    case BEFORE: {
                                        return ListUtils.concat(gen, (Object)statement);
                                    }
                                    case AFTER: {
                                        return ListUtils.concat((Object)statement, gen);
                                    }
                                }
                            }
                            return statement;
                        }));
                    }
                }
                return super.visitBlock(block, p);
            }

            @Override
            public J visitClassDeclaration(J.ClassDeclaration classDecl, Integer p) {
                if (classDecl.isScope(insertionPoint)) {
                    switch (loc) {
                        case ANNOTATIONS: {
                            List<J.Annotation> gen = substitutions.unsubstitute(JavaTemplate.this.templateParser.parseAnnotations(this.getCursor(), substitutedTemplate));
                            J.ClassDeclaration c = classDecl;
                            if (mode.equals((Object)JavaCoordinates.Mode.REPLACEMENT)) {
                                if ((c = c.withLeadingAnnotations(gen)).getTypeParameters() != null) {
                                    c = c.withTypeParameters(ListUtils.map(c.getTypeParameters(), tp -> tp.withAnnotations(Collections.emptyList())));
                                }
                                c = c.withModifiers(ListUtils.map(c.getModifiers(), m -> m.withAnnotations(Collections.emptyList())));
                                c = c.getAnnotations().withKind(c.getAnnotations().getKind().withAnnotations(Collections.emptyList()));
                            } else {
                                for (J.Annotation a : gen) {
                                    c = c.withLeadingAnnotations(ListUtils.insertInOrder(c.getLeadingAnnotations(), (Object)a, coordinates.getComparator()));
                                }
                            }
                            return this.autoFormat(c, c.getLeadingAnnotations().get(c.getLeadingAnnotations().size() - 1), p, this.getCursor().getParentOrThrow());
                        }
                        case EXTENDS: {
                            TypeTree anExtends = substitutions.unsubstitute(JavaTemplate.this.templateParser.parseExtends(substitutedTemplate));
                            J.ClassDeclaration c = classDecl.withExtends(anExtends);
                            c = c.getPadding().withExtends(c.getPadding().getExtends().withBefore(Space.format(" ")));
                            return c;
                        }
                        case IMPLEMENTS: {
                            List<TypeTree> implementings = substitutions.unsubstitute(JavaTemplate.this.templateParser.parseImplements(substitutedTemplate));
                            List implementsTypes = implementings.stream().map(TypedTree::getType).map(TypeUtils::asFullyQualified).filter(Objects::nonNull).collect(Collectors.toList());
                            J.ClassDeclaration c = classDecl;
                            if (mode.equals((Object)JavaCoordinates.Mode.REPLACEMENT)) {
                                c = c.withImplements(implementings);
                                c = c.getPadding().withImplements(c.getPadding().getImplements().withBefore(Space.EMPTY));
                            } else {
                                c = c.withImplements(ListUtils.concatAll(c.getImplements(), implementings));
                            }
                            if (c.getType() != null) {
                                final String fqn = c.getType().getFullyQualifiedName();
                                c = c.withType(new JavaTypeVisitor<List<JavaType.FullyQualified>>(){

                                    @Override
                                    public JavaType visitClass(JavaType.Class aClass, List<JavaType.FullyQualified> fullyQualifiedTypes) {
                                        JavaType.Class c = (JavaType.Class)super.visitClass(aClass, fullyQualifiedTypes);
                                        if (fqn.equals(c.getFullyQualifiedName())) {
                                            c = c.withInterfaces(ListUtils.concatAll(c.getInterfaces(), fullyQualifiedTypes));
                                        }
                                        return c;
                                    }

                                    @Override
                                    public JavaType visitMethod(JavaType.Method method, List<JavaType.FullyQualified> fullyQualifieds) {
                                        return method;
                                    }

                                    @Override
                                    public JavaType visitVariable(JavaType.Variable variable, List<JavaType.FullyQualified> fullyQualifieds) {
                                        return variable;
                                    }
                                }.visitNonNull(c.getType(), implementsTypes));
                            }
                            return this.autoFormat(c, c.getImplements().get(c.getImplements().size() - 1), p, this.getCursor().getParentOrThrow());
                        }
                        case TYPE_PARAMETERS: {
                            List<J.TypeParameter> typeParameters = substitutions.unsubstitute(JavaTemplate.this.templateParser.parseTypeParameters(substitutedTemplate));
                            return classDecl.withTypeParameters(typeParameters);
                        }
                    }
                }
                return super.visitClassDeclaration(classDecl, p);
            }

            @Override
            public J visitLambda(J.Lambda lambda, Integer p) {
                if (loc.equals((Object)Space.Location.LAMBDA_PARAMETERS_PREFIX) && lambda.getParameters().isScope(insertionPoint)) {
                    return lambda.withParameters(substitutions.unsubstitute(JavaTemplate.this.templateParser.parseLambdaParameters(substitutedTemplate)));
                }
                return this.maybeReplaceStatement(lambda, J.class, true, 0);
            }

            @Override
            public J visitMethodDeclaration(J.MethodDeclaration method, Integer p) {
                if (method.isScope(insertionPoint)) {
                    switch (loc) {
                        case ANNOTATIONS: {
                            List<J.Annotation> gen = substitutions.unsubstitute(JavaTemplate.this.templateParser.parseAnnotations(this.getCursor(), substitutedTemplate));
                            J.MethodDeclaration m = method;
                            if (mode.equals((Object)JavaCoordinates.Mode.REPLACEMENT)) {
                                m = method.withLeadingAnnotations(gen);
                                if (m.getTypeParameters() != null) {
                                    m = m.withTypeParameters(ListUtils.map(m.getTypeParameters(), tp -> tp.withAnnotations(Collections.emptyList())));
                                }
                                if (m.getReturnTypeExpression() instanceof J.AnnotatedType) {
                                    m = m.withReturnTypeExpression(((J.AnnotatedType)m.getReturnTypeExpression()).getTypeExpression());
                                }
                                m = m.withModifiers(ListUtils.map(m.getModifiers(), m2 -> m2.withAnnotations(Collections.emptyList())));
                                m = m.getAnnotations().withName(m.getAnnotations().getName().withAnnotations(Collections.emptyList()));
                            } else {
                                for (J.Annotation a : gen) {
                                    m = m.withLeadingAnnotations(ListUtils.insertInOrder(m.getLeadingAnnotations(), (Object)a, coordinates.getComparator()));
                                }
                            }
                            return this.autoFormat(m, m.getName(), p, this.getCursor().getParentOrThrow());
                        }
                        case BLOCK_PREFIX: {
                            List<Statement> gen = substitutions.unsubstitute(JavaTemplate.this.templateParser.parseBlockStatements(this.getCursor(), Statement.class, substitutedTemplate, false, loc));
                            J.Block body = method.getBody();
                            if (body == null) {
                                body = EMPTY_BLOCK;
                            }
                            body = body.withStatements(gen);
                            return method.withBody(this.autoFormat(body, p, this.getCursor()));
                        }
                        case METHOD_DECLARATION_PARAMETERS: {
                            List<Statement> parameters = substitutions.unsubstitute(JavaTemplate.this.templateParser.parseParameters(substitutedTemplate));
                            JavaType.Method type = method.getType();
                            if (type != null) {
                                ArrayList<String> paramNames = new ArrayList<String>();
                                ArrayList<JavaType> paramTypes = new ArrayList<JavaType>();
                                for (Statement statement : parameters) {
                                    if (!(statement instanceof J.VariableDeclarations)) {
                                        throw new IllegalArgumentException("Only variable declarations may be part of a method declaration's parameter list:" + statement.print(this.getCursor()));
                                    }
                                    J.VariableDeclarations decl = (J.VariableDeclarations)statement;
                                    if (decl.getVariables().size() != 1) {
                                        throw new IllegalArgumentException("Multi-variable declarations may not be used in a method declaration's parameter list: " + statement.print(this.getCursor()));
                                    }
                                    J.VariableDeclarations.NamedVariable namedVariable = decl.getVariables().get(0);
                                    paramNames.add(namedVariable.getSimpleName());
                                    if (namedVariable.getType() == null && decl.getTypeExpression() instanceof J.Identifier) {
                                        J.Identifier declTypeIdent = (J.Identifier)decl.getTypeExpression();
                                        String typeParameterName = declTypeIdent.getSimpleName();
                                        List<Object> typeParameters = method.getTypeParameters() == null ? Collections.emptyList() : method.getTypeParameters();
                                        for (J.TypeParameter typeParameter : typeParameters) {
                                            J.Identifier typeParamIdent = (J.Identifier)typeParameter.getName();
                                            if (!typeParamIdent.getSimpleName().equals(typeParameterName)) continue;
                                            List<TypeTree> bounds = typeParameter.getBounds();
                                            JavaType.FullyQualified bound = bounds == null || bounds.isEmpty() ? JavaType.Class.OBJECT : (JavaType.FullyQualified)((Object)bounds.get(0));
                                            JavaType.GenericTypeVariable genericType = new JavaType.GenericTypeVariable(typeParamIdent.getSimpleName(), bound);
                                            paramTypes.add(genericType);
                                        }
                                        continue;
                                    }
                                    paramTypes.add(namedVariable.getType());
                                }
                                type = JavaType.Method.build(type.getFlags(), type.getDeclaringType(), type.getName(), type.getGenericSignature().withParamTypes(paramTypes), type.getResolvedSignature().withParamTypes(paramTypes), paramNames, type.getThrownExceptions(), type.getAnnotations());
                            }
                            return method.withParameters(parameters).withType(type);
                        }
                        case THROWS: {
                            J.MethodDeclaration m = method.withThrows(substitutions.unsubstitute(JavaTemplate.this.templateParser.parseThrows(substitutedTemplate)));
                            JavaType.Method type = m.getType();
                            if (type != null) {
                                ArrayList<JavaType.FullyQualified> newThrows = new ArrayList<JavaType.FullyQualified>();
                                List<Object> throwz = m.getThrows() == null ? Collections.emptyList() : m.getThrows();
                                for (NameTree nameTree : throwz) {
                                    J.Identifier exceptionIdent = (J.Identifier)nameTree;
                                    newThrows.add((JavaType.FullyQualified)exceptionIdent.getType());
                                }
                                type = JavaType.Method.build(type.getFlags(), type.getDeclaringType(), type.getName(), type.getGenericSignature(), type.getResolvedSignature(), type.getParamNames(), newThrows, type.getAnnotations());
                            }
                            m = m.getPadding().withThrows(m.getPadding().getThrows().withBefore(Space.format(" "))).withType(type);
                            return m;
                        }
                        case TYPE_PARAMETERS: {
                            List<J.TypeParameter> typeParameters = substitutions.unsubstitute(JavaTemplate.this.templateParser.parseTypeParameters(substitutedTemplate));
                            J.MethodDeclaration m = method.withTypeParameters(typeParameters);
                            return this.autoFormat(m, typeParameters.get(typeParameters.size() - 1), p, this.getCursor().getParentOrThrow());
                        }
                    }
                }
                return super.visitMethodDeclaration(method, p);
            }

            @Override
            public J visitMethodInvocation(J.MethodInvocation method, Integer integer) {
                if ((loc.equals((Object)Space.Location.METHOD_INVOCATION_ARGUMENTS) || loc.equals((Object)Space.Location.METHOD_INVOCATION_NAME)) && method.isScope(insertionPoint)) {
                    J.MethodInvocation m;
                    if (loc.equals((Object)Space.Location.METHOD_INVOCATION_ARGUMENTS)) {
                        m = substitutions.unsubstitute(JavaTemplate.this.templateParser.parseMethodArguments(this.getCursor(), substitutedTemplate, loc));
                        m = this.autoFormat(m, 0, this.getCursor().getParentOrThrow());
                        m = method.withArguments(m.getArguments()).withType(m.getType());
                    } else {
                        m = substitutions.unsubstitute(JavaTemplate.this.templateParser.parseMethod(this.getCursor(), substitutedTemplate, loc));
                        m = this.autoFormat(m, 0, this.getCursor().getParentOrThrow());
                        m = method.withName(m.getName()).withArguments(m.getArguments()).withType(m.getType());
                    }
                    JavaType.Method mt = method.getType();
                    if (m.getType() == null && mt != null && mt.getGenericSignature() != null) {
                        List<JavaType> argTypes = m.getArguments().stream().map(Expression::getType).map(it -> {
                            if (it instanceof JavaType.Method) {
                                JavaType.Method argType = (JavaType.Method)it;
                                if (argType.getGenericSignature() != null) {
                                    return argType.getGenericSignature().getReturnType();
                                }
                                return argType.getResolvedSignature().getReturnType();
                            }
                            if (it == JavaType.Primitive.String) {
                                return JavaType.Class.build("java.lang.String");
                            }
                            return it;
                        }).collect(Collectors.toList());
                        mt = mt.withResolvedSignature(mt.getResolvedSignature().withParamTypes(argTypes)).withGenericSignature(mt.getGenericSignature().withParamTypes(argTypes));
                        m = m.withType(mt);
                    }
                    return m;
                }
                return this.maybeReplaceStatement(method, J.class, true, 0);
            }

            @Override
            public J visitPackage(J.Package pkg, Integer integer) {
                if (loc.equals((Object)Space.Location.PACKAGE_PREFIX) && pkg.isScope(insertionPoint)) {
                    return pkg.withExpression(substitutions.unsubstitute(JavaTemplate.this.templateParser.parsePackage(substitutedTemplate)));
                }
                return super.visitPackage(pkg, integer);
            }

            @Override
            public J visitStatement(Statement statement, Integer p) {
                return this.maybeReplaceStatement(statement, Statement.class, false, p);
            }

            @NotNull
            private <J3 extends J> J3 maybeReplaceStatement(Statement statement, Class<J3> expected, boolean mightBeUsedAsExpression, Integer p) {
                if (loc.equals((Object)Space.Location.STATEMENT_PREFIX) && statement.isScope(insertionPoint)) {
                    if (mode.equals((Object)JavaCoordinates.Mode.REPLACEMENT)) {
                        List<J3> gen = substitutions.unsubstitute(JavaTemplate.this.templateParser.parseBlockStatements(this.getCursor(), expected, substitutedTemplate, mightBeUsedAsExpression, loc));
                        if (gen.size() != 1) {
                            throw new IllegalArgumentException("Expected a template that would generate exactly one statement to replace one statement, but generated " + gen.size());
                        }
                        return (J3)this.autoFormat(((J)gen.get(0)).withPrefix(statement.getPrefix()), p, this.getCursor().getParentOrThrow());
                    }
                    throw new IllegalArgumentException("Cannot insert a new statement before an existing statement and return both to a visit method that returns one statement.");
                }
                return (J3)super.visitStatement(statement, p);
            }

            @Override
            public J visitVariableDeclarations(J.VariableDeclarations multiVariable, Integer p) {
                if (multiVariable.isScope(insertionPoint) && loc == Space.Location.ANNOTATIONS) {
                    J.VariableDeclarations v = multiVariable;
                    List<J.Annotation> gen = substitutions.unsubstitute(JavaTemplate.this.templateParser.parseAnnotations(this.getCursor(), substitutedTemplate));
                    if (mode.equals((Object)JavaCoordinates.Mode.REPLACEMENT)) {
                        if ((v = v.withLeadingAnnotations(gen)).getTypeExpression() instanceof J.AnnotatedType) {
                            v = v.withTypeExpression(((J.AnnotatedType)v.getTypeExpression()).getTypeExpression());
                        }
                        v = v.withModifiers(ListUtils.map(v.getModifiers(), m -> m.withAnnotations(Collections.emptyList())));
                    } else {
                        for (J.Annotation a : gen) {
                            v = v.withLeadingAnnotations(ListUtils.insertInOrder(v.getLeadingAnnotations(), (Object)a, coordinates.getComparator()));
                        }
                    }
                    return this.autoFormat(v, v.getTypeExpression(), p, this.getCursor().getParentOrThrow());
                }
                return super.visitVariableDeclarations(multiVariable, p);
            }
        }.visit(changing, 0, parentCursor));
    }

    public static Builder builder(Supplier<Cursor> parentScope, String code) {
        return new Builder(parentScope, code);
    }

    public static class Builder {
        private final Supplier<Cursor> parentScope;
        private final String code;
        private final Set<String> imports = new HashSet<String>();
        private Supplier<JavaParser> javaParser = () -> JavaParser.fromJavaVersion().build();
        private Consumer<String> onAfterVariableSubstitution = s -> {};
        private Consumer<String> onBeforeParseTemplate = s -> {};

        Builder(Supplier<Cursor> parentScope, String code) {
            this.parentScope = parentScope;
            this.code = code.trim();
        }

        public Builder imports(String ... fullyQualifiedTypeNames) {
            for (String typeName : fullyQualifiedTypeNames) {
                if (typeName.startsWith("import ") || typeName.startsWith("static ")) {
                    throw new IllegalArgumentException("Imports are expressed as fully-qualified names and should not include an \"import \" or \"static \" prefix");
                }
                if (typeName.endsWith(";") || typeName.endsWith("\n")) {
                    throw new IllegalArgumentException("Imports are expressed as fully-qualified names and should not include a suffixed terminator");
                }
                this.imports.add("import " + typeName + ";\n");
            }
            return this;
        }

        public Builder staticImports(String ... fullyQualifiedMemberTypeNames) {
            for (String typeName : fullyQualifiedMemberTypeNames) {
                if (typeName.startsWith("import ") || typeName.startsWith("static ")) {
                    throw new IllegalArgumentException("Imports are expressed as fully-qualified names and should not include an \"import \" or \"static \" prefix");
                }
                if (typeName.endsWith(";") || typeName.endsWith("\n")) {
                    throw new IllegalArgumentException("Imports are expressed as fully-qualified names and should not include a suffixed terminator");
                }
                this.imports.add("import static " + typeName + ";\n");
            }
            return this;
        }

        public Builder javaParser(Supplier<JavaParser> javaParser) {
            this.javaParser = javaParser;
            return this;
        }

        public Builder doAfterVariableSubstitution(Consumer<String> afterVariableSubstitution) {
            this.onAfterVariableSubstitution = afterVariableSubstitution;
            return this;
        }

        public Builder doBeforeParseTemplate(Consumer<String> beforeParseTemplate) {
            this.onBeforeParseTemplate = beforeParseTemplate;
            return this;
        }

        public JavaTemplate build() {
            return new JavaTemplate(this.parentScope, this.javaParser, this.code, this.imports, this.onAfterVariableSubstitution, this.onBeforeParseTemplate);
        }
    }
}

