/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.concurrent.atomic.AtomicBoolean;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.SearchResult;

public final class FindTypesByPackage
extends Recipe {
    @Option(displayName="Package name", description="The package name to search for.", example="com.yourorg")
    private final String packageName;

    public String getDisplayName() {
        return "Find Types by package";
    }

    public String getDescription() {
        return "A recipe for finding Types by package name.";
    }

    protected UsesType<ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType<ExecutionContext>(this.packageName + ".*");
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new FindPackageVisitor(this.packageName);
    }

    public FindTypesByPackage(String packageName) {
        this.packageName = packageName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    @NonNull
    public String toString() {
        return "FindTypesByPackage(packageName=" + this.getPackageName() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindTypesByPackage)) {
            return false;
        }
        FindTypesByPackage other = (FindTypesByPackage)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$packageName = this.getPackageName();
        String other$packageName = other.getPackageName();
        return !(this$packageName == null ? other$packageName != null : !this$packageName.equals(other$packageName));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindTypesByPackage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $packageName = this.getPackageName();
        result = result * 59 + ($packageName == null ? 43 : $packageName.hashCode());
        return result;
    }

    private static class FindPackageVisitor
    extends JavaVisitor<ExecutionContext> {
        private final String pkgName;

        public FindPackageVisitor(String pkgName) {
            this.pkgName = pkgName;
        }

        @Nullable
        public J postVisit(J tree, ExecutionContext executionContext) {
            J j = (J)super.postVisit((Tree)tree, (Object)executionContext);
            if (j instanceof TypedTree) {
                j = this.maybeAddMarker((TypedTree)j, executionContext);
            }
            return j;
        }

        private J maybeAddMarker(TypedTree tree, ExecutionContext executionContext) {
            if (this.getCursor().getParent() != null && this.getCursor().getParent().getValue() instanceof J.VariableDeclarations.NamedVariable) {
                return tree;
            }
            if (this.isSearchPackage(tree.getType())) {
                AtomicBoolean markerExists = new AtomicBoolean(false);
                new HasSearchMarkerVisitor(markerExists).visit(tree, executionContext);
                if (!markerExists.get()) {
                    tree = (TypedTree)tree.withMarkers(tree.getMarkers().searchResult());
                }
            }
            return tree;
        }

        private boolean isSearchPackage(@Nullable JavaType type) {
            if (type != null) {
                JavaType.FullyQualified fq = type instanceof JavaType.Method ? TypeUtils.asFullyQualified(((JavaType.Method)type).getDeclaringType()) : TypeUtils.asFullyQualified(type);
                return fq != null && fq.getPackageName().startsWith(this.pkgName);
            }
            return false;
        }

        private static class HasSearchMarkerVisitor
        extends JavaIsoVisitor<ExecutionContext> {
            private final AtomicBoolean markerExists;

            private HasSearchMarkerVisitor(AtomicBoolean markerExists) {
                this.markerExists = markerExists;
            }

            public <M extends Marker> M visitMarker(Marker marker, ExecutionContext executionContext) {
                Marker m = super.visitMarker(marker, (Object)executionContext);
                if (m instanceof SearchResult) {
                    this.markerExists.set(true);
                }
                return (M)m;
            }
        }
    }
}

