/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public class FindMissingTypes
extends Recipe {
    public String getDisplayName() {
        return "Find missing type information on Java ASTs";
    }

    public String getDescription() {
        return "This is a diagnostic recipe to highlight where ASTs are missing type attribution information.";
    }

    public JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                JavaType.Method type = method.getType();
                Expression select = method.getSelect();
                if (select != null) {
                    if (type == null) {
                        return method.withSelect((Expression)select.withMarkers(select.getMarkers().searchResult("type is `null`")));
                    }
                    if (type.getGenericSignature() == null) {
                        return method.withSelect((Expression)select.withMarkers(select.getMarkers().searchResult("generic signature is `null`")));
                    }
                    if (!type.getName().equals(method.getSimpleName())) {
                        return method.withSelect((Expression)select.withMarkers(select.getMarkers().searchResult("type information has a different method name '" + type.getName() + "'")));
                    }
                }
                return super.visitMethodInvocation(method, executionContext);
            }
        };
    }
}

