/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.Iterator;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public final class FindDeprecatedMethods
extends Recipe {
    @Option(displayName="Method pattern", description="A method pattern that is used to find matching method invocations.", example="java.util.List add(..)", required=false)
    @Nullable
    private final String methodPattern;
    @Option(displayName="Ignore deprecated scopes", description="When a deprecated method is used in a deprecated method or class, ignore it.", required=false)
    @Nullable
    private final Boolean ignoreDeprecatedScopes;

    public String getDisplayName() {
        return "Find uses of deprecated methods";
    }

    public String getDescription() {
        return "Find uses of deprecated methods in any API.";
    }

    protected JavaVisitor<ExecutionContext> getSingleSourceApplicableTest() {
        final MethodMatcher methodMatcher = this.methodPattern == null ? null : new MethodMatcher(this.methodPattern);
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public JavaSourceFile visitJavaSourceFile(JavaSourceFile cu, ExecutionContext ctx) {
                for (JavaType javaType : cu.getTypesInUse()) {
                    JavaType.Method method = TypeUtils.asMethod(javaType);
                    if (method == null || methodMatcher != null && !methodMatcher.matches(method)) continue;
                    for (JavaType.FullyQualified annotation : method.getAnnotations()) {
                        if (!TypeUtils.isOfClassType(annotation, "java.lang.Deprecated")) continue;
                        return (JavaSourceFile)cu.withMarkers(cu.getMarkers().searchResult());
                    }
                }
                return cu;
            }
        };
    }

    public JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J m = super.visitMethodInvocation(method, ctx);
                if (method.getType() != null) {
                    for (JavaType.FullyQualified annotation : method.getType().getAnnotations()) {
                        if (!TypeUtils.isOfClassType(annotation, "java.lang.Deprecated")) continue;
                        if (Boolean.TRUE.equals(FindDeprecatedMethods.this.ignoreDeprecatedScopes)) {
                            Iterator cursorPath = this.getCursor().getPath();
                            while (cursorPath.hasNext()) {
                                Object ancestor = cursorPath.next();
                                if (ancestor instanceof J.MethodDeclaration && this.isDeprecated(((J.MethodDeclaration)ancestor).getAllAnnotations())) {
                                    return m;
                                }
                                if (!(ancestor instanceof J.ClassDeclaration) || !this.isDeprecated(((J.ClassDeclaration)ancestor).getAllAnnotations())) continue;
                                return m;
                            }
                        }
                        m = ((J.MethodInvocation)m).withMarkers(((J.MethodInvocation)m).getMarkers().searchResult());
                    }
                }
                return m;
            }

            private boolean isDeprecated(List<J.Annotation> annotations) {
                for (J.Annotation annotation : annotations) {
                    if (!TypeUtils.isOfClassType(annotation.getType(), "java.lang.Deprecated")) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public FindDeprecatedMethods(@Nullable String methodPattern, @Nullable Boolean ignoreDeprecatedScopes) {
        this.methodPattern = methodPattern;
        this.ignoreDeprecatedScopes = ignoreDeprecatedScopes;
    }

    @Nullable
    public String getMethodPattern() {
        return this.methodPattern;
    }

    @Nullable
    public Boolean getIgnoreDeprecatedScopes() {
        return this.ignoreDeprecatedScopes;
    }

    @NonNull
    public String toString() {
        return "FindDeprecatedMethods(methodPattern=" + this.getMethodPattern() + ", ignoreDeprecatedScopes=" + this.getIgnoreDeprecatedScopes() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindDeprecatedMethods)) {
            return false;
        }
        FindDeprecatedMethods other = (FindDeprecatedMethods)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$ignoreDeprecatedScopes = this.getIgnoreDeprecatedScopes();
        Boolean other$ignoreDeprecatedScopes = other.getIgnoreDeprecatedScopes();
        if (this$ignoreDeprecatedScopes == null ? other$ignoreDeprecatedScopes != null : !((Object)this$ignoreDeprecatedScopes).equals(other$ignoreDeprecatedScopes)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        return !(this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindDeprecatedMethods;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $ignoreDeprecatedScopes = this.getIgnoreDeprecatedScopes();
        result = result * 59 + ($ignoreDeprecatedScopes == null ? 43 : ((Object)$ignoreDeprecatedScopes).hashCode());
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        return result;
    }
}

