/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.marker.JavaVersion;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;

public class UseFilesCreateTempDirectory
extends Recipe {
    public String getDisplayName() {
        return "Use Files#createTempDirectory";
    }

    public String getDescription() {
        return "Use `Files#createTempDirectory` when the sequence `File#createTempFile(..)`->`File#delete()`->`File#mkdir()` is used for creating a temp directory";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-5445");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(10L);
    }

    protected UsesMethod<ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesMethod<ExecutionContext>("java.io.File createTempFile(..)");
    }

    protected UsesFilesCreateTempDirVisitor getVisitor() {
        return new UsesFilesCreateTempDirVisitor();
    }

    private static class UsesFilesCreateTempDirVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private static final MethodMatcher CREATE_TEMP_FILE_MATCHER = new MethodMatcher("java.io.File createTempFile(..)");
        private static final MethodMatcher DELETE_MATCHER = new MethodMatcher("java.io.File delete()");
        private static final MethodMatcher MKDIR_MATCHER = new MethodMatcher("java.io.File mkdir()");

        private UsesFilesCreateTempDirVisitor() {
        }

        @Override
        public JavaSourceFile visitJavaSourceFile(JavaSourceFile cu, ExecutionContext executionContext) {
            Optional javaVersion = cu.getMarkers().findFirst(JavaVersion.class);
            if (javaVersion.isPresent() && ((JavaVersion)javaVersion.get()).getMajorVersion() < 7) {
                return cu;
            }
            return super.visitJavaSourceFile(cu, executionContext);
        }

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
            J.Block block;
            J mi = super.visitMethodInvocation(method, executionContext);
            if (CREATE_TEMP_FILE_MATCHER.matches((J.MethodInvocation)mi) && (block = (J.Block)this.getCursor().firstEnclosing(J.Block.class)) != null) {
                J createFileStatement = null;
                J.Assignment assignment = (J.Assignment)this.getCursor().firstEnclosing(J.Assignment.class);
                if (assignment != null && assignment.getVariable() instanceof J.Identifier) {
                    createFileStatement = assignment;
                }
                if (createFileStatement == null) {
                    createFileStatement = (J)this.getCursor().firstEnclosing(J.VariableDeclarations.NamedVariable.class);
                }
                if (createFileStatement != null) {
                    ((ArrayList)this.getCursor().dropParentUntil(J.Block.class::isInstance).computeMessageIfAbsent("CREATE_FILE_STATEMENT", v -> new ArrayList())).add(createFileStatement);
                }
            }
            return mi;
        }

        @Override
        public J.Block visitBlock(J.Block block, ExecutionContext executionContext) {
            J bl = super.visitBlock(block, executionContext);
            List createFileStatements = (List)this.getCursor().pollMessage("CREATE_FILE_STATEMENT");
            if (createFileStatements != null) {
                for (J createFileStatement : createFileStatements) {
                    List<Statement> statements = ((J.Block)bl).getStatements();
                    int statementIndex = -1;
                    Statement createTempDirectoryStatement = null;
                    for (int i = 0; i < statements.size() - 2; ++i) {
                        Statement stmt = statements.get(i);
                        J.Identifier createFileIdentifier = this.getIdent(createFileStatement);
                        if (createFileIdentifier == null || !this.isMatchingCreateFileStatement(createFileStatement, stmt) || !this.isMethodForIdent(createFileIdentifier, DELETE_MATCHER, statements.get(i + 1)) || !this.isMethodForIdent(createFileIdentifier, MKDIR_MATCHER, statements.get(i + 2))) continue;
                        createTempDirectoryStatement = this.toCreateTempDirectoryStatement(stmt);
                        statementIndex = i;
                        break;
                    }
                    if (createTempDirectoryStatement == null) continue;
                    statements.remove(statementIndex);
                    statements.remove(statementIndex);
                    statements.remove(statementIndex);
                    statements.add(statementIndex, createTempDirectoryStatement);
                    bl = ((J.Block)bl).withStatements(statements);
                    this.maybeAddImport("java.nio.file.Files");
                }
            }
            return bl;
        }

        @Nullable
        private Statement toCreateTempDirectoryStatement(Statement statement) {
            StringBuilder templateString = new StringBuilder();
            if (statement instanceof J.Assignment) {
                J.Identifier ident = this.getIdent(statement);
                if (ident != null) {
                    templateString.append(ident.getSimpleName());
                }
            } else if (statement instanceof J.VariableDeclarations) {
                J.VariableDeclarations varD = (J.VariableDeclarations)statement;
                templateString.append("File ").append(varD.getVariables().get(0).getName().getSimpleName());
            }
            if (templateString.length() > 0) {
                Object[] args = this.getArgs(statement);
                templateString.append(" = Files.createTempDirectory(");
                if (args.length == 1) {
                    templateString.append("#{any()}");
                } else if (args.length == 2) {
                    templateString.append("#{any(java.io.File)}.toPath(), #{any()}");
                }
                templateString.append(").toFile()");
                JavaTemplate template = JavaTemplate.builder(() -> ((UsesFilesCreateTempDirVisitor)this).getCursor(), templateString.toString()).imports("java.nio.file.Files").build();
                return (Statement)statement.withTemplate(template, statement.getCoordinates().replace(), args);
            }
            return null;
        }

        private boolean isMatchingCreateFileStatement(J createFileStatement, Statement statement) {
            if (createFileStatement.equals(statement)) {
                return true;
            }
            if (createFileStatement instanceof J.VariableDeclarations.NamedVariable && statement instanceof J.VariableDeclarations) {
                J.VariableDeclarations varDecls = (J.VariableDeclarations)statement;
                for (J.VariableDeclarations.NamedVariable variable : varDecls.getVariables()) {
                    if (!variable.equals(createFileStatement)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean isMethodForIdent(J.Identifier ident, MethodMatcher methodMatcher, Statement statement) {
            J.MethodInvocation mi;
            if (statement instanceof J.MethodInvocation && (mi = (J.MethodInvocation)statement).getSelect() instanceof J.Identifier && methodMatcher.matches(mi)) {
                J.Identifier sel = (J.Identifier)mi.getSelect();
                return ident.getSimpleName().equals(sel.getSimpleName()) && TypeUtils.isOfClassType(ident.getType(), "java.io.File");
            }
            return false;
        }

        @Nullable
        private J.Identifier getIdent(J createFileStatement) {
            if (createFileStatement instanceof J.Assignment) {
                J.Assignment assignment = (J.Assignment)createFileStatement;
                return (J.Identifier)assignment.getVariable();
            }
            if (createFileStatement instanceof J.VariableDeclarations.NamedVariable) {
                J.VariableDeclarations.NamedVariable var = (J.VariableDeclarations.NamedVariable)createFileStatement;
                return var.getName();
            }
            return null;
        }

        @Nullable
        private Object[] getArgs(J createFileStatement) {
            J.VariableDeclarations var;
            J.MethodInvocation initializer;
            List<Expression> args = null;
            if (createFileStatement instanceof J.Assignment) {
                J.Assignment assignment = (J.Assignment)createFileStatement;
                args = ((J.MethodInvocation)assignment.getAssignment()).getArguments();
            } else if (createFileStatement instanceof J.VariableDeclarations && (initializer = (J.MethodInvocation)(var = (J.VariableDeclarations)createFileStatement).getVariables().get(0).getInitializer()) != null) {
                args = initializer.getArguments();
            }
            if (args != null) {
                Object[] objectArray;
                if (args.size() == 3) {
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = args.get(2);
                    objectArray = objectArray2;
                    objectArray2[1] = args.get(0);
                } else {
                    Object[] objectArray3 = new Object[1];
                    objectArray = objectArray3;
                    objectArray3[0] = args.get(0);
                }
                return objectArray;
            }
            return new Object[0];
        }
    }
}

