/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;

public class ExternalizableHasNoArgsConstructor
extends Recipe {
    public String getDisplayName() {
        return "`Externalizable` classes have no-arguments constructor";
    }

    public String getDescription() {
        return "`Externalizable` classes handle both serialization and deserialization and must have a no-args constructor for the deserialization process.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(20L);
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-2060");
    }

    protected UsesType<ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType<ExecutionContext>("java.io.Externalizable");
    }

    protected ExternalizableHasNoArgsConstructorVisitor getVisitor() {
        return new ExternalizableHasNoArgsConstructorVisitor();
    }

    private static class ExternalizableHasNoArgsConstructorVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private static final JavaType externalizableType = JavaType.buildType("java.io.Externalizable");

        private ExternalizableHasNoArgsConstructorVisitor() {
        }

        @Override
        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext executionContext) {
            J cd = super.visitClassDeclaration(classDecl, executionContext);
            if (TypeUtils.isAssignableTo(externalizableType, ((J.ClassDeclaration)cd).getType())) {
                boolean hasFinalUninitializedFieldVar = false;
                Integer firstMethodDeclarationIndex = null;
                List<Statement> statements = ((J.ClassDeclaration)cd).getBody().getStatements();
                for (int i = 0; i < statements.size(); ++i) {
                    J.VariableDeclarations varDecls;
                    Statement statement = statements.get(i);
                    if (statement instanceof J.VariableDeclarations && J.Modifier.hasModifier((varDecls = (J.VariableDeclarations)statement).getModifiers(), J.Modifier.Type.Final) && varDecls.getVariables().stream().anyMatch(v -> v.getInitializer() == null)) {
                        hasFinalUninitializedFieldVar = true;
                        break;
                    }
                    if (!(statement instanceof J.MethodDeclaration) || firstMethodDeclarationIndex != null) continue;
                    firstMethodDeclarationIndex = i;
                }
                if (!hasFinalUninitializedFieldVar && !this.hasNoArgsConstructor((J.ClassDeclaration)cd) && this.parentClassHasNoArgsConstructor((J.ClassDeclaration)cd)) {
                    cd = (J.ClassDeclaration)cd.withTemplate(JavaTemplate.builder(() -> ((ExternalizableHasNoArgsConstructorVisitor)this).getCursor(), "public " + ((J.ClassDeclaration)cd).getSimpleName() + "() {}").build(), ((J.ClassDeclaration)cd).getBody().getCoordinates().lastStatement(), new Object[0]);
                    if (firstMethodDeclarationIndex != null) {
                        statements.add(firstMethodDeclarationIndex, ((J.ClassDeclaration)cd).getBody().getStatements().remove(((J.ClassDeclaration)cd).getBody().getStatements().size() - 1));
                        cd = ((J.ClassDeclaration)cd).withBody(((J.ClassDeclaration)cd).getBody().withStatements(statements));
                    }
                }
            }
            return cd;
        }

        private boolean hasNoArgsConstructor(J.ClassDeclaration cd) {
            boolean hasNoArgsConstructor = false;
            boolean hasDefaultConstructor = true;
            for (Statement statement : cd.getBody().getStatements()) {
                J.MethodDeclaration md;
                if (!(statement instanceof J.MethodDeclaration) || !(md = (J.MethodDeclaration)statement).isConstructor()) continue;
                if (md.getParameters().get(0) instanceof J.Empty) {
                    hasNoArgsConstructor = true;
                    continue;
                }
                hasDefaultConstructor = false;
            }
            return hasDefaultConstructor || hasNoArgsConstructor;
        }

        private boolean parentClassHasNoArgsConstructor(J.ClassDeclaration cd) {
            if (cd.getExtends() == null) {
                return true;
            }
            JavaType.FullyQualified parentFq = TypeUtils.asFullyQualified(cd.getExtends().getType());
            if (parentFq == null) {
                return false;
            }
            boolean hasNoArgsConstructor = false;
            boolean hasDefaultConstructor = true;
            for (JavaType.Method method : parentFq.getMethods()) {
                if (!"<init>".equals(method.getName())) continue;
                if (method.getParamNames().isEmpty()) {
                    hasNoArgsConstructor = true;
                    continue;
                }
                hasDefaultConstructor = false;
            }
            return hasDefaultConstructor || hasNoArgsConstructor;
        }
    }
}

