/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public class UseDiamondOperator
extends Recipe {
    public String getDisplayName() {
        return "Use diamond operator";
    }

    public String getDescription() {
        return "The diamond operator (`<>`) should be used. Java 7 introduced the diamond operator (<>) to reduce the verbosity of generics code. For instance, instead of having to declare a List's type in both its declaration and its constructor, you can now simplify the constructor declaration with `<>`, and the compiler will infer the type.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-2293");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.NewClass visitNewClass(J.NewClass newClass, ExecutionContext executionContext) {
                J.ParameterizedType parameterizedType;
                J n = super.visitNewClass(newClass, executionContext);
                if (((J.NewClass)n).getClazz() instanceof J.ParameterizedType && ((J.NewClass)n).getBody() == null && this.useDiamondOperator(newClass, parameterizedType = (J.ParameterizedType)((J.NewClass)n).getClazz())) {
                    n = ((J.NewClass)n).withClazz(parameterizedType.withTypeParameters(Collections.singletonList(new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY))));
                    if (parameterizedType.getTypeParameters() != null) {
                        parameterizedType.getTypeParameters().stream().map(e -> TypeUtils.asFullyQualified(e.getType())).forEach(this::maybeRemoveImport);
                    }
                }
                return n;
            }

            private boolean useDiamondOperator(J.NewClass newClass, J.ParameterizedType parameterizedType) {
                if (parameterizedType.getTypeParameters() == null || parameterizedType.getTypeParameters().isEmpty() || parameterizedType.getTypeParameters().get(0) instanceof J.Empty) {
                    return false;
                }
                Cursor c = this.getCursor().dropParentUntil(J.class::isInstance);
                if (c.getValue() instanceof J.VariableDeclarations.NamedVariable) {
                    J.VariableDeclarations variableDeclaration = (J.VariableDeclarations)c.firstEnclosing(J.VariableDeclarations.class);
                    return variableDeclaration != null && !(variableDeclaration.getTypeExpression() instanceof J.VarType);
                }
                if (c.getValue() instanceof J.MethodInvocation) {
                    J.MethodInvocation invocation = (J.MethodInvocation)c.getValue();
                    return invocation.getSelect() != newClass;
                }
                return !(c.getValue() instanceof J.Block);
            }
        };
    }
}

