/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.UnwrapParentheses;
import org.openrewrite.java.format.AutoFormatVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;

@Incubating(since="7.0.0")
public class SimplifyBooleanExpressionVisitor<P>
extends JavaVisitor<P> {
    private static final String MAYBE_AUTO_FORMAT_ME = "MAYBE_AUTO_FORMAT_ME";

    @Override
    public J visitCompilationUnit(J.CompilationUnit cu, P p) {
        J.CompilationUnit c = (J.CompilationUnit)this.visitAndCast(cu, p, (x$0, x$1) -> super.visitCompilationUnit((J.CompilationUnit)x$0, x$1));
        if (c != cu) {
            this.doAfterVisit(new SimplifyBooleanExpressionVisitor<P>());
        }
        return c;
    }

    @Override
    public J visitBinary(J.Binary binary, P p) {
        J j = super.visitBinary(binary, p);
        J.Binary asBinary = (J.Binary)j;
        if (asBinary.getOperator() == J.Binary.Type.And) {
            if (this.isLiteralFalse(asBinary.getLeft())) {
                this.maybeUnwrapParentheses();
                j = asBinary.getLeft();
            } else if (this.isLiteralFalse(asBinary.getRight())) {
                this.maybeUnwrapParentheses();
                j = asBinary.getRight();
            } else if (this.removeAllSpace(asBinary.getLeft()).printTrimmed(this.getCursor()).equals(this.removeAllSpace(asBinary.getRight()).printTrimmed(this.getCursor()))) {
                this.maybeUnwrapParentheses();
                j = asBinary.getLeft();
            }
        } else if (asBinary.getOperator() == J.Binary.Type.Or) {
            if (this.isLiteralTrue(asBinary.getLeft())) {
                this.maybeUnwrapParentheses();
                j = asBinary.getLeft();
            } else if (this.isLiteralTrue(asBinary.getRight())) {
                this.maybeUnwrapParentheses();
                j = asBinary.getRight();
            } else if (this.removeAllSpace(asBinary.getLeft()).printTrimmed(this.getCursor()).equals(this.removeAllSpace(asBinary.getRight()).printTrimmed(this.getCursor()))) {
                this.maybeUnwrapParentheses();
                j = asBinary.getLeft();
            }
        } else if (asBinary.getOperator() == J.Binary.Type.Equal) {
            if (this.isLiteralTrue(asBinary.getLeft())) {
                this.maybeUnwrapParentheses();
                j = asBinary.getRight();
            } else if (this.isLiteralTrue(asBinary.getRight())) {
                this.maybeUnwrapParentheses();
                j = asBinary.getLeft();
            }
        } else if (asBinary.getOperator() == J.Binary.Type.NotEqual) {
            if (this.isLiteralFalse(asBinary.getLeft())) {
                this.maybeUnwrapParentheses();
                j = asBinary.getRight();
            } else if (this.isLiteralFalse(asBinary.getRight())) {
                this.maybeUnwrapParentheses();
                j = asBinary.getLeft();
            }
        }
        if (asBinary != j) {
            this.getCursor().dropParentUntil(J.class::isInstance).putMessage(MAYBE_AUTO_FORMAT_ME, (Object)"");
        }
        return j;
    }

    @Nullable
    public J postVisit(J tree, P p) {
        J j = (J)super.postVisit((Tree)tree, p);
        if (this.getCursor().pollMessage(MAYBE_AUTO_FORMAT_ME) != null) {
            j = new AutoFormatVisitor().visit((Tree)j, (Object)p, this.getCursor());
        }
        return j;
    }

    @Override
    public J visitUnary(J.Unary unary, P p) {
        J j = super.visitUnary(unary, p);
        J.Unary asUnary = (J.Unary)j;
        if (asUnary.getOperator() == J.Unary.Type.Not) {
            if (this.isLiteralTrue(asUnary.getExpression())) {
                this.maybeUnwrapParentheses();
                j = ((J.Literal)asUnary.getExpression()).withValue(false).withValueSource("false");
            } else if (this.isLiteralFalse(asUnary.getExpression())) {
                this.maybeUnwrapParentheses();
                j = ((J.Literal)asUnary.getExpression()).withValue(true).withValueSource("true");
            } else if (asUnary.getExpression() instanceof J.Unary && ((J.Unary)asUnary.getExpression()).getOperator() == J.Unary.Type.Not) {
                this.maybeUnwrapParentheses();
                j = ((J.Unary)asUnary.getExpression()).getExpression();
            }
        }
        if (asUnary != j) {
            this.getCursor().dropParentUntil(J.class::isInstance).putMessage(MAYBE_AUTO_FORMAT_ME, (Object)"");
        }
        return j;
    }

    private void maybeUnwrapParentheses() {
        Cursor c = this.getCursor().getParentOrThrow().dropParentUntil(J.class::isInstance);
        if (c.getValue() instanceof J.Parentheses) {
            this.doAfterVisit(new UnwrapParentheses((J.Parentheses)c.getValue()));
        }
    }

    private boolean isLiteralTrue(@Nullable Expression expression) {
        return expression instanceof J.Literal && ((J.Literal)expression).getValue() == Boolean.valueOf(true);
    }

    private boolean isLiteralFalse(@Nullable Expression expression) {
        return expression instanceof J.Literal && ((J.Literal)expression).getValue() == Boolean.valueOf(false);
    }

    private J removeAllSpace(J j) {
        return (J)new JavaIsoVisitor<Integer>(){

            @Override
            public Space visitSpace(Space space, Space.Location loc, Integer integer) {
                return Space.EMPTY;
            }
        }.visit(j, 0);
    }
}

