/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;

public class NoToStringOnStringType
extends Recipe {
    public static final MethodMatcher TO_STRING = new MethodMatcher("java.lang.String toString()");

    public String getDisplayName() {
        return "No #toString() on String";
    }

    public String getDescription() {
        return "Removes`#toString()` from Strings.";
    }

    @Nullable
    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType<ExecutionContext>("java.lang.String");
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1858");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    protected JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            @Override
            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                J.MethodInvocation mi = (J.MethodInvocation)super.visitMethodInvocation(method, executionContext);
                if (TO_STRING.matches(mi)) {
                    return mi.withTemplate(JavaTemplate.builder(() -> (this).getCursor(), "#{any(java.lang.String)}").build(), mi.getCoordinates().replace(), mi.getSelect());
                }
                return mi;
            }
        };
    }
}

