/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.format.NormalizeLineBreaksVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.style.GeneralFormatStyle;

public class NormalizeLineBreaks
extends Recipe {
    public String getDisplayName() {
        return "Normalize the line breaks";
    }

    public String getDescription() {
        return "Consistently use either Windows or Linux line breaks.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new LineBreaksFromCompilationUnitStyle();
    }

    private static class LineBreaksFromCompilationUnitStyle
    extends JavaIsoVisitor<ExecutionContext> {
        private LineBreaksFromCompilationUnitStyle() {
        }

        @Override
        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
            GeneralFormatStyle style = (GeneralFormatStyle)cu.getStyle(GeneralFormatStyle.class);
            if (style == null) {
                style = GeneralFormatStyle.DEFAULT;
            }
            this.doAfterVisit(new NormalizeLineBreaksVisitor(style));
            return cu;
        }
    }
}

