/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.ChangeMethodName;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;

public class MethodNameCasing
extends Recipe {
    public String getDisplayName() {
        return "Method name casing";
    }

    public String getDescription() {
        return "Method names should comply with a naming convention.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-100");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        final Pattern standardMethodName = Pattern.compile("^[a-z][a-zA-Z0-9]*$");
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext executionContext) {
                if (method.getType() != null && !method.isConstructor() && !standardMethodName.matcher(method.getSimpleName()).matches()) {
                    StringBuilder standardized = new StringBuilder();
                    char[] name = method.getSimpleName().toCharArray();
                    for (int i = 0; i < name.length; ++i) {
                        char c = name[i];
                        if (i == 0) {
                            if (c == '$' || c == '_') continue;
                            standardized.append(Character.toLowerCase(c));
                            continue;
                        }
                        if (!Character.isLetterOrDigit(c)) {
                            while (!(i >= name.length || Character.isLetterOrDigit(name[i]) && name[i] <= 'z')) {
                                ++i;
                            }
                            standardized.append(Character.toUpperCase(name[i]));
                            continue;
                        }
                        standardized.append(c);
                    }
                    MethodNameCasing.this.doNext(new ChangeMethodName(MethodMatcher.methodPattern(method), standardized.toString(), null));
                }
                return super.visitMethodDeclaration(method, executionContext);
            }
        };
    }
}

