/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.Objects;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AspectjUtils;
import org.openrewrite.java.FormalParameterVisitor;
import org.openrewrite.java.TypeVisitor;
import org.openrewrite.java.internal.grammar.MethodSignatureLexer;
import org.openrewrite.java.internal.grammar.MethodSignatureParser;
import org.openrewrite.java.internal.grammar.MethodSignatureParserBaseVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class MethodMatcher {
    private Pattern targetTypePattern;
    private Pattern methodNamePattern;
    private Pattern argumentPattern;
    private final boolean matchOverrides;

    public MethodMatcher(String signature, @Nullable Boolean matchOverrides) {
        this(signature, Boolean.TRUE.equals(matchOverrides));
    }

    public MethodMatcher(String signature, boolean matchOverrides) {
        this.matchOverrides = matchOverrides;
        MethodSignatureParser parser = new MethodSignatureParser((TokenStream)new CommonTokenStream((TokenSource)new MethodSignatureLexer((CharStream)CharStreams.fromString((String)signature))));
        new MethodSignatureParserBaseVisitor<Void>(){

            @Override
            public Void visitMethodPattern(MethodSignatureParser.MethodPatternContext ctx) {
                MethodMatcher.this.targetTypePattern = Pattern.compile((String)new TypeVisitor().visitTargetTypePattern(ctx.targetTypePattern()));
                MethodMatcher.this.methodNamePattern = Pattern.compile(ctx.simpleNamePattern().children.stream().map(c -> AspectjUtils.aspectjNameToPattern(c.toString())).collect(Collectors.joining("")));
                MethodMatcher.this.argumentPattern = Pattern.compile(new FormalParameterVisitor().visitFormalParametersPattern(ctx.formalParametersPattern()));
                return null;
            }
        }.visit((ParseTree)parser.methodPattern());
    }

    public MethodMatcher(J.MethodDeclaration method, boolean matchOverrides) {
        this(MethodMatcher.methodPattern(method), matchOverrides);
    }

    public MethodMatcher(String signature) {
        this(signature, false);
    }

    public MethodMatcher(J.MethodDeclaration method) {
        this(method, false);
    }

    public boolean matches(@Nullable JavaType type) {
        if (!(type instanceof JavaType.Method)) {
            return false;
        }
        JavaType.Method methodType = (JavaType.Method)type;
        return this.matchesTargetType(methodType.getDeclaringType()) && this.methodNamePattern.matcher(methodType.getName()).matches() && methodType.getGenericSignature() != null && this.argumentPattern.matcher(methodType.getGenericSignature().getParamTypes().stream().map(MethodMatcher::typePattern).filter(Objects::nonNull).collect(Collectors.joining(","))).matches();
    }

    public boolean matches(J.MethodDeclaration method, J.ClassDeclaration enclosing) {
        if (enclosing.getType() == null) {
            return false;
        }
        return (this.targetTypePattern.toString().equals("[^.]*") || this.matchesTargetType(enclosing.getType())) && this.methodNamePattern.matcher(method.getSimpleName()).matches() && this.argumentPattern.matcher(method.getParameters().stream().map(v -> {
            if (v instanceof J.VariableDeclarations) {
                J.VariableDeclarations vd = (J.VariableDeclarations)v;
                if (vd.getTypeAsFullyQualified() != null) {
                    return vd.getTypeAsFullyQualified();
                }
                return vd.getTypeExpression() != null ? vd.getTypeExpression().getType() : null;
            }
            return null;
        }).filter(Objects::nonNull).map(MethodMatcher::typePattern).filter(Objects::nonNull).collect(Collectors.joining(","))).matches();
    }

    public boolean matches(Expression maybeMethod) {
        return maybeMethod instanceof J.MethodInvocation && this.matches((J.MethodInvocation)maybeMethod);
    }

    public boolean matches(J.MethodInvocation method) {
        if (method.getType() == null || method.getType().getDeclaringType() == null) {
            return false;
        }
        if (method.getType().getResolvedSignature() == null) {
            return false;
        }
        return this.matchesTargetType(method.getType().getDeclaringType()) && this.methodNamePattern.matcher(method.getSimpleName()).matches() && this.argumentPattern.matcher(method.getType().getResolvedSignature().getParamTypes().stream().map(MethodMatcher::typePattern).filter(Objects::nonNull).collect(Collectors.joining(","))).matches();
    }

    public boolean matches(J.NewClass constructor) {
        if (constructor.getType() == null || constructor.getConstructorType() == null) {
            return false;
        }
        JavaType.FullyQualified type = TypeUtils.asFullyQualified(constructor.getType());
        assert (type != null);
        return this.matchesTargetType(type) && this.methodNamePattern.matcher("<constructor>").matches() && constructor.getConstructorType().getResolvedSignature() != null && this.argumentPattern.matcher(constructor.getConstructorType().getResolvedSignature().getParamTypes().stream().map(MethodMatcher::typePattern).filter(Objects::nonNull).collect(Collectors.joining(","))).matches();
    }

    boolean matchesTargetType(@Nullable JavaType.FullyQualified type) {
        if (type == null) {
            return false;
        }
        if (this.targetTypePattern.matcher(type.getFullyQualifiedName()).matches()) {
            return true;
        }
        if (type != JavaType.Class.OBJECT && this.matchesTargetType(type.getSupertype() == null ? JavaType.Class.OBJECT : type.getSupertype())) {
            return true;
        }
        if (this.matchOverrides) {
            if (this.matchesTargetType(type.getSupertype())) {
                return true;
            }
            for (JavaType.FullyQualified anInterface : type.getInterfaces()) {
                if (!this.matchesTargetType(anInterface)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isFullyQualifiedClassReference(J.FieldAccess fieldAccess) {
        String hopefullyFullyQualifiedMethod = this.getTargetTypePattern().pattern() + "." + this.getMethodNamePattern().pattern();
        return fieldAccess.isFullyQualifiedClassReference(hopefullyFullyQualifiedMethod);
    }

    @Nullable
    private static String typePattern(JavaType type) {
        JavaType elemType;
        if (type instanceof JavaType.Primitive) {
            return ((JavaType.Primitive)type).getKeyword();
        }
        if (type instanceof JavaType.FullyQualified) {
            return ((JavaType.FullyQualified)type).getFullyQualifiedName();
        }
        if (type instanceof JavaType.Array && (elemType = ((JavaType.Array)type).getElemType()) != null) {
            return MethodMatcher.typePattern(elemType) + "[]";
        }
        return null;
    }

    public static String methodPattern(J.MethodDeclaration method) {
        String signatureStr;
        assert (method.getType() != null);
        JavaType.Method.Signature signature = method.getType().getResolvedSignature();
        if (signature == null) {
            signatureStr = "";
        } else {
            StringJoiner joiner = new StringJoiner(",");
            for (JavaType javaType : signature.getParamTypes()) {
                String s = MethodMatcher.typePattern(javaType);
                if (s == null) continue;
                joiner.add(s);
            }
            signatureStr = joiner.toString();
        }
        return method.getType().getDeclaringType().getFullyQualifiedName() + " " + method.getSimpleName() + "(" + signatureStr + ")";
    }

    public Pattern getTargetTypePattern() {
        return this.targetTypePattern;
    }

    public Pattern getMethodNamePattern() {
        return this.methodNamePattern;
    }

    public Pattern getArgumentPattern() {
        return this.argumentPattern;
    }

    public boolean isMatchOverrides() {
        return this.matchOverrides;
    }
}

