/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class ChangeFieldName<P>
extends JavaIsoVisitor<P> {
    private final JavaType.Class classType;
    private final String hasName;
    private final String toName;

    public ChangeFieldName(JavaType.Class classType, String hasName, String toName) {
        this.classType = classType;
        this.hasName = hasName;
        this.toName = toName;
    }

    @Override
    public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, P p) {
        J.VariableDeclarations.NamedVariable v = variable;
        J.ClassDeclaration enclosingClass = (J.ClassDeclaration)this.getCursor().firstEnclosingOrThrow(J.ClassDeclaration.class);
        if (variable.isField(this.getCursor()) && this.matchesClass(enclosingClass.getType()) && variable.getSimpleName().equals(this.hasName)) {
            v = v.withName(v.getName().withName(this.toName));
        }
        if (variable.getPadding().getInitializer() != null) {
            v = v.getPadding().withInitializer(this.visitLeftPadded(variable.getPadding().getInitializer(), JLeftPadded.Location.VARIABLE_INITIALIZER, p));
        }
        return v;
    }

    @Override
    public J.FieldAccess visitFieldAccess(J.FieldAccess fieldAccess, P p) {
        J f = super.visitFieldAccess(fieldAccess, (Object)p);
        if (this.matchesClass(fieldAccess.getTarget().getType()) && fieldAccess.getSimpleName().equals(this.hasName)) {
            f = ((J.FieldAccess)f).getPadding().withName(((J.FieldAccess)f).getPadding().getName().withElement(((J.FieldAccess)f).getPadding().getName().getElement().withName(this.toName)));
        }
        return f;
    }

    @Override
    public J.Identifier visitIdentifier(J.Identifier ident, P p) {
        JavaType.Variable varType;
        J i = super.visitIdentifier(ident, (Object)p);
        if (((J.Identifier)i).getFieldType() instanceof JavaType.Variable && (varType = (JavaType.Variable)((J.Identifier)i).getFieldType()).getName().equals(this.hasName) && TypeUtils.isOfType(varType.getOwner(), this.classType)) {
            i = J.Identifier.build(Tree.randomId(), ((J.Identifier)i).getPrefix(), ((J.Identifier)i).getMarkers(), this.toName, ((J.Identifier)i).getType(), JavaType.Variable.build(this.toName, varType.getOwner(), varType.getType(), varType.getAnnotations(), Flag.flagsToBitMap(varType.getFlags())));
        }
        return i;
    }

    private boolean matchesClass(@Nullable JavaType test) {
        JavaType.FullyQualified testClassType = TypeUtils.asFullyQualified(test);
        return testClassType != null && testClassType.getFullyQualifiedName().equals(this.classType.getFullyQualifiedName());
    }
}

