/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.HashSet;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.marker.JavaSearchResult;
import org.openrewrite.java.search.UsesField;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Marker;

public final class FindFields
extends Recipe {
    @Option(displayName="Fully-qualified type name", description="A fully-qualified Java type name, that is used to find matching fields.", example="com.fasterxml.jackson.core.json.JsonWriteFeature")
    private final String fullyQualifiedTypeName;
    @Option(displayName="Field name", description="The name of a field on the type.", example="QUOTE_FIELD_NAMES")
    private final String fieldName;

    public String getDisplayName() {
        return "Find fields";
    }

    public String getDescription() {
        return "Find uses of a field.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesField<ExecutionContext>(this.fullyQualifiedTypeName, this.fieldName);
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.FieldAccess visitFieldAccess(J.FieldAccess fieldAccess, ExecutionContext executionContext) {
                JavaType.Variable varType = TypeUtils.asVariable(fieldAccess.getName().getFieldType());
                if (varType != null && varType.getOwner().getFullyQualifiedName().equals(FindFields.this.fullyQualifiedTypeName) && varType.getName().equals(FindFields.this.fieldName)) {
                    return fieldAccess.withMarkers(fieldAccess.getMarkers().addIfAbsent((Marker)new JavaSearchResult(FindFields.this)));
                }
                return super.visitFieldAccess(fieldAccess, executionContext);
            }

            @Override
            public J.Identifier visitIdentifier(J.Identifier identifier, ExecutionContext executionContext) {
                J i = super.visitIdentifier(identifier, executionContext);
                JavaType.Variable varType = TypeUtils.asVariable(identifier.getFieldType());
                if (varType != null && varType.getOwner().getFullyQualifiedName().equals(FindFields.this.fullyQualifiedTypeName) && varType.getName().equals(FindFields.this.fieldName)) {
                    i = ((J.Identifier)i).withMarkers(((J.Identifier)i).getMarkers().addIfAbsent((Marker)new JavaSearchResult(FindFields.this)));
                }
                return i;
            }

            @Override
            public J.MemberReference visitMemberReference(J.MemberReference memberRef, ExecutionContext ctx) {
                J m = super.visitMemberReference(memberRef, ctx);
                JavaType.Variable varType = TypeUtils.asVariable(memberRef.getReferenceType());
                if (varType != null && varType.getOwner().getFullyQualifiedName().equals(FindFields.this.fullyQualifiedTypeName) && varType.getName().equals(FindFields.this.fieldName)) {
                    m = ((J.MemberReference)m).withReference(((J.MemberReference)m).getReference().withMarkers(((J.MemberReference)m).getReference().getMarkers().addIfAbsent((Marker)new JavaSearchResult(FindFields.this))));
                }
                return m;
            }
        };
    }

    public static Set<J> find(J j, final String fullyQualifiedTypeName, final String fieldName) {
        JavaIsoVisitor<Set<J>> findVisitor = new JavaIsoVisitor<Set<J>>(){

            @Override
            public J.FieldAccess visitFieldAccess(J.FieldAccess fieldAccess, Set<J> vs) {
                J f = super.visitFieldAccess(fieldAccess, vs);
                JavaType.Variable varType = TypeUtils.asVariable(fieldAccess.getName().getFieldType());
                if (varType != null && varType.getOwner().getFullyQualifiedName().equals(fullyQualifiedTypeName) && varType.getName().equals(fieldName)) {
                    vs.add(f);
                }
                return f;
            }

            @Override
            public J.Identifier visitIdentifier(J.Identifier identifier, Set<J> vs) {
                J i = super.visitIdentifier(identifier, vs);
                JavaType.Variable varType = TypeUtils.asVariable(identifier.getFieldType());
                if (varType != null && varType.getOwner().getFullyQualifiedName().equals(fullyQualifiedTypeName) && varType.getName().equals(fieldName)) {
                    vs.add(i);
                }
                return i;
            }

            @Override
            public J.MemberReference visitMemberReference(J.MemberReference memberRef, Set<J> vs) {
                J m = super.visitMemberReference(memberRef, vs);
                JavaType.Variable varType = TypeUtils.asVariable(memberRef.getReferenceType());
                if (varType != null && varType.getOwner().getFullyQualifiedName().equals(fullyQualifiedTypeName) && varType.getName().equals(fieldName)) {
                    vs.add(m);
                }
                return m;
            }
        };
        HashSet<J> vs = new HashSet<J>();
        findVisitor.visit(j, vs);
        return vs;
    }

    public FindFields(String fullyQualifiedTypeName, String fieldName) {
        this.fullyQualifiedTypeName = fullyQualifiedTypeName;
        this.fieldName = fieldName;
    }

    public String getFullyQualifiedTypeName() {
        return this.fullyQualifiedTypeName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @NonNull
    public String toString() {
        return "FindFields(fullyQualifiedTypeName=" + this.getFullyQualifiedTypeName() + ", fieldName=" + this.getFieldName() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindFields)) {
            return false;
        }
        FindFields other = (FindFields)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$fullyQualifiedTypeName = this.getFullyQualifiedTypeName();
        String other$fullyQualifiedTypeName = other.getFullyQualifiedTypeName();
        if (this$fullyQualifiedTypeName == null ? other$fullyQualifiedTypeName != null : !this$fullyQualifiedTypeName.equals(other$fullyQualifiedTypeName)) {
            return false;
        }
        String this$fieldName = this.getFieldName();
        String other$fieldName = other.getFieldName();
        return !(this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindFields;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $fullyQualifiedTypeName = this.getFullyQualifiedTypeName();
        result = result * 59 + ($fullyQualifiedTypeName == null ? 43 : $fullyQualifiedTypeName.hashCode());
        String $fieldName = this.getFieldName();
        result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
        return result;
    }
}

