/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.util.Collections;
import java.util.List;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.JavaType;

public class TypeUtils {
    private TypeUtils() {
    }

    public static List<JavaType.Variable> getVisibleSupertypeMembers(@Nullable JavaType type) {
        JavaType.FullyQualified classType = TypeUtils.asFullyQualified(type);
        return classType == null ? Collections.emptyList() : classType.getVisibleSupertypeMembers();
    }

    public static boolean isString(@Nullable JavaType type) {
        return type == JavaType.Primitive.String || type instanceof JavaType.FullyQualified && "java.lang.String".equals(((JavaType.FullyQualified)type).getFullyQualifiedName());
    }

    public static boolean isOfType(@Nullable JavaType type1, @Nullable JavaType type2) {
        if (type1 == null || type2 == null) {
            return false;
        }
        if (TypeUtils.isString(type1) && TypeUtils.isString(type2)) {
            return true;
        }
        if (type1 instanceof JavaType.Primitive && type2 instanceof JavaType.Primitive) {
            return ((JavaType.Primitive)type1).getKeyword().equals(((JavaType.Primitive)type2).getKeyword());
        }
        if (type1 instanceof JavaType.FullyQualified && type2 instanceof JavaType.FullyQualified) {
            return ((JavaType.FullyQualified)type1).getFullyQualifiedName().equals(((JavaType.FullyQualified)type2).getFullyQualifiedName());
        }
        if (type1 instanceof JavaType.Array && type2 instanceof JavaType.Array) {
            return TypeUtils.isOfType(((JavaType.Array)type1).getElemType(), ((JavaType.Array)type2).getElemType());
        }
        return type1.deepEquals(type2);
    }

    public static boolean isOfClassType(@Nullable JavaType type, String fqn) {
        JavaType.FullyQualified classType = TypeUtils.asFullyQualified(type);
        return classType != null && classType.getFullyQualifiedName().equals(fqn);
    }

    public static boolean isAssignableTo(@Nullable JavaType to, @Nullable JavaType from) {
        if (from == JavaType.Class.OBJECT) {
            return to == JavaType.Class.OBJECT;
        }
        JavaType.FullyQualified classTo = TypeUtils.asFullyQualified(to);
        JavaType.FullyQualified classFrom = TypeUtils.asFullyQualified(from);
        if (classTo == null || classFrom == null) {
            return false;
        }
        return classTo.getFullyQualifiedName().equals(classFrom.getFullyQualifiedName()) || TypeUtils.isAssignableTo(to, classFrom.getSupertype()) || classFrom.getInterfaces().stream().anyMatch(i -> TypeUtils.isAssignableTo(to, i));
    }

    @Nullable
    public static JavaType.Class asClass(@Nullable JavaType type) {
        return type instanceof JavaType.Class ? (JavaType.Class)type : null;
    }

    @Nullable
    public static JavaType.Parameterized asParameterized(@Nullable JavaType type) {
        return type instanceof JavaType.Parameterized ? (JavaType.Parameterized)type : null;
    }

    @Nullable
    public static JavaType.Array asArray(@Nullable JavaType type) {
        return type instanceof JavaType.Array ? (JavaType.Array)type : null;
    }

    @Nullable
    public static JavaType.GenericTypeVariable asGeneric(@Nullable JavaType type) {
        return type instanceof JavaType.GenericTypeVariable ? (JavaType.GenericTypeVariable)type : null;
    }

    @Nullable
    public static JavaType.Method asMethod(@Nullable JavaType type) {
        return type instanceof JavaType.Method ? (JavaType.Method)type : null;
    }

    @Nullable
    public static JavaType.Variable asVariable(@Nullable JavaType type) {
        return type instanceof JavaType.Variable ? (JavaType.Variable)type : null;
    }

    @Nullable
    public static JavaType.Primitive asPrimitive(@Nullable JavaType type) {
        return type instanceof JavaType.Primitive ? (JavaType.Primitive)type : null;
    }

    @Nullable
    public static JavaType.FullyQualified asFullyQualified(@Nullable JavaType type) {
        return type instanceof JavaType.FullyQualified ? (JavaType.FullyQualified)type : null;
    }

    public static boolean hasElementTypeAssignable(@Nullable JavaType type, String fullyQualifiedName) {
        if (type instanceof JavaType.Array) {
            return TypeUtils.hasElementType(((JavaType.Array)type).getElemType(), fullyQualifiedName);
        }
        if (type instanceof JavaType.Class || type instanceof JavaType.GenericTypeVariable) {
            return TypeUtils.isAssignableTo(JavaType.Class.build(fullyQualifiedName), type);
        }
        return false;
    }

    public static boolean hasElementType(@Nullable JavaType type, String fullyQualifiedName) {
        if (type instanceof JavaType.Array) {
            return TypeUtils.hasElementType(((JavaType.Array)type).getElemType(), fullyQualifiedName);
        }
        if (type instanceof JavaType.Class || type instanceof JavaType.GenericTypeVariable) {
            return fullyQualifiedName.equals(((JavaType.FullyQualified)type).getFullyQualifiedName());
        }
        return false;
    }

    static boolean deepEquals(@Nullable List<? extends JavaType> ts1, @Nullable List<? extends JavaType> ts2) {
        if (ts1 == null || ts2 == null) {
            return ts1 == null && ts2 == null;
        }
        if (ts1.size() != ts2.size()) {
            return false;
        }
        for (int i = 0; i < ts1.size(); ++i) {
            JavaType t1 = ts1.get(i);
            JavaType t2 = ts2.get(i);
            if (!(t1 == null ? t2 != null : !TypeUtils.deepEquals(t1, t2))) continue;
            return false;
        }
        return true;
    }

    static boolean deepEquals(@Nullable JavaType t, @Nullable JavaType t2) {
        return t == null ? t2 == null : t == t2 || t.deepEquals(t2);
    }
}

