/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.marker.JavaSearchResult;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Marker;

public final class FindDeprecatedMethods
extends Recipe {
    @Option(displayName="Method pattern", description="A method pattern, expressed as a pointcut expression, that is used to find matching method invocations.", example="java.util.List add(..)", required=false)
    @Nullable
    private final String methodPattern;

    public String getDisplayName() {
        return "Find uses of deprecated methods";
    }

    public String getDescription() {
        return "Find uses of deprecated methods in any API.";
    }

    protected JavaVisitor<ExecutionContext> getSingleSourceApplicableTest() {
        final MethodMatcher methodMatcher = this.methodPattern == null ? null : new MethodMatcher(this.methodPattern);
        return new JavaIsoVisitor<ExecutionContext>(){
            private final Marker USES_DEPRECATED = new JavaSearchResult(Tree.randomId(), null, null);

            @Override
            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
                for (JavaType javaType : cu.getTypesInUse()) {
                    JavaType.Method method = TypeUtils.asMethod(javaType);
                    if (method == null || methodMatcher != null && !methodMatcher.matches(method)) continue;
                    for (JavaType.FullyQualified annotation : method.getAnnotations()) {
                        if (!TypeUtils.isOfClassType(annotation, "java.lang.Deprecated")) continue;
                        return cu.withMarkers(cu.getMarkers().addIfAbsent(this.USES_DEPRECATED));
                    }
                }
                return cu;
            }
        };
    }

    public JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J m = super.visitMethodInvocation(method, ctx);
                if (method.getType() != null) {
                    for (JavaType.FullyQualified annotation : method.getType().getAnnotations()) {
                        if (!TypeUtils.isOfClassType(annotation, "java.lang.Deprecated")) continue;
                        m = ((J.MethodInvocation)m).withMarkers(((J.MethodInvocation)m).getMarkers().addIfAbsent((Marker)new JavaSearchResult(FindDeprecatedMethods.this)));
                    }
                }
                return m;
            }
        };
    }

    public FindDeprecatedMethods(@Nullable String methodPattern) {
        this.methodPattern = methodPattern;
    }

    @Nullable
    public String getMethodPattern() {
        return this.methodPattern;
    }

    @NonNull
    public String toString() {
        return "FindDeprecatedMethods(methodPattern=" + this.getMethodPattern() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindDeprecatedMethods)) {
            return false;
        }
        FindDeprecatedMethods other = (FindDeprecatedMethods)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        return !(this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindDeprecatedMethods;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        return result;
    }
}

