/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;

public class ModifierOrder
extends Recipe {
    public String getDisplayName() {
        return "Modifier order";
    }

    public String getDescription() {
        return "Modifiers should be declared in the correct order as recommended by the JLS.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext executionContext) {
                J c = super.visitClassDeclaration(classDecl, executionContext);
                return ((J.ClassDeclaration)c).withModifiers(ModifierOrder.sortModifiers(((J.ClassDeclaration)c).getModifiers()));
            }

            @Override
            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext executionContext) {
                J m = super.visitMethodDeclaration(method, executionContext);
                return ((J.MethodDeclaration)m).withModifiers(ModifierOrder.sortModifiers(((J.MethodDeclaration)m).getModifiers()));
            }

            @Override
            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext executionContext) {
                J v = super.visitVariableDeclarations(multiVariable, executionContext);
                return ((J.VariableDeclarations)v).withModifiers(ModifierOrder.sortModifiers(((J.VariableDeclarations)v).getModifiers()));
            }
        };
    }

    public static List<J.Modifier> sortModifiers(List<J.Modifier> modifiers) {
        List sortedTypes = modifiers.stream().map(J.Modifier::getType).sorted(Comparator.comparingInt(Enum::ordinal)).collect(Collectors.toList());
        return ListUtils.map(modifiers, (i, mod) -> mod.getType() == sortedTypes.get((int)i) ? mod : mod.withType((J.Modifier.Type)((Object)((Object)sortedTypes.get((int)i)))));
    }
}

