/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal.template;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.intellij.lang.annotations.Language;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.PropertyPlaceholderHelper;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.RandomizeIdVisitor;
import org.openrewrite.java.internal.template.AnnotationTemplateGenerator;
import org.openrewrite.java.internal.template.BlockStatementTemplateGenerator;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;

public class JavaTemplateParser {
    private static final PropertyPlaceholderHelper placeholderHelper = new PropertyPlaceholderHelper("#{", "}", null);
    private final Object templateCacheLock = new Object();
    private static final Map<String, List<? extends J>> templateCache = new LinkedHashMap<String, List<? extends J>>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 10000;
        }
    };
    private static final String PACKAGE_STUB = "package #{}; class $Template {}";
    private static final String PARAMETER_STUB = "abstract class $Template { abstract void $template(#{}); }";
    private static final String LAMBDA_PARAMETER_STUB = "class $Template { { Object o = (#{}) -> {}; } }";
    private static final String EXPRESSION_STUB = "class $Template { { Object o = #{} } }";
    private static final String EXTENDS_STUB = "class $Template extends #{} {}";
    private static final String IMPLEMENTS_STUB = "class $Template implements #{} {}";
    private static final String THROWS_STUB = "abstract class $Template { abstract void $template() throws #{}; }";
    private static final String TYPE_PARAMS_STUB = "class $Template<#{}> {}";
    @Language(value="java")
    private static final String SUBSTITUTED_ANNOTATION = "@java.lang.annotation.Documented public @interface SubAnnotation { int value(); }";
    private final Supplier<JavaParser> parser;
    private final Consumer<String> onAfterVariableSubstitution;
    private final Consumer<String> onBeforeParseTemplate;
    private final Set<String> imports;
    private final BlockStatementTemplateGenerator statementTemplateGenerator;
    private final AnnotationTemplateGenerator annotationTemplateGenerator;

    public JavaTemplateParser(Supplier<JavaParser> parser, Consumer<String> onAfterVariableSubstitution, Consumer<String> onBeforeParseTemplate, Set<String> imports) {
        this.parser = parser;
        this.onAfterVariableSubstitution = onAfterVariableSubstitution;
        this.onBeforeParseTemplate = onBeforeParseTemplate;
        this.imports = imports;
        this.statementTemplateGenerator = new BlockStatementTemplateGenerator(imports);
        this.annotationTemplateGenerator = new AnnotationTemplateGenerator(imports);
    }

    public List<Statement> parseParameters(String template) {
        String stub = this.addImports(this.substitute(PARAMETER_STUB, template));
        this.onBeforeParseTemplate.accept(stub);
        return this.cache(stub, () -> {
            J.CompilationUnit cu = this.compileTemplate(stub);
            J.MethodDeclaration m = (J.MethodDeclaration)cu.getClasses().get(0).getBody().getStatements().get(0);
            return m.getParameters();
        });
    }

    public J.Lambda.Parameters parseLambdaParameters(String template) {
        String stub = this.addImports(this.substitute(LAMBDA_PARAMETER_STUB, template));
        this.onBeforeParseTemplate.accept(stub);
        return (J.Lambda.Parameters)this.cache(stub, () -> {
            J.CompilationUnit cu = this.compileTemplate(stub);
            J.Block b = (J.Block)cu.getClasses().get(0).getBody().getStatements().get(0);
            J.VariableDeclarations v = (J.VariableDeclarations)b.getStatements().get(0);
            J.Lambda l = (J.Lambda)v.getVariables().get(0).getInitializer();
            assert (l != null);
            return Collections.singletonList(l.getParameters());
        }).get(0);
    }

    public J parseExpression(String template) {
        String stub = this.addImports(this.substitute(EXPRESSION_STUB, template));
        this.onBeforeParseTemplate.accept(stub);
        return (J)this.cache(stub, () -> {
            J.CompilationUnit cu = this.compileTemplate(stub);
            J.Block b = (J.Block)cu.getClasses().get(0).getBody().getStatements().get(0);
            J.VariableDeclarations v = (J.VariableDeclarations)b.getStatements().get(0);
            return Collections.singletonList(v.getVariables().get(0).getInitializer());
        }).get(0);
    }

    public TypeTree parseExtends(String template) {
        String stub = this.addImports(this.substitute(EXTENDS_STUB, template));
        this.onBeforeParseTemplate.accept(stub);
        return (TypeTree)this.cache(stub, () -> {
            J.CompilationUnit cu = this.compileTemplate(stub);
            TypeTree anExtends = cu.getClasses().get(0).getExtends();
            assert (anExtends != null);
            return Collections.singletonList(anExtends);
        }).get(0);
    }

    public List<TypeTree> parseImplements(String template) {
        String stub = this.addImports(this.substitute(IMPLEMENTS_STUB, template));
        this.onBeforeParseTemplate.accept(stub);
        return this.cache(stub, () -> {
            J.CompilationUnit cu = this.compileTemplate(stub);
            List<TypeTree> anImplements = cu.getClasses().get(0).getImplements();
            assert (anImplements != null);
            return anImplements;
        });
    }

    public List<NameTree> parseThrows(String template) {
        String stub = this.addImports(this.substitute(THROWS_STUB, template));
        this.onBeforeParseTemplate.accept(stub);
        return this.cache(stub, () -> {
            J.CompilationUnit cu = this.compileTemplate(stub);
            J.MethodDeclaration m = (J.MethodDeclaration)cu.getClasses().get(0).getBody().getStatements().get(0);
            List<NameTree> aThrows = m.getThrows();
            assert (aThrows != null);
            return aThrows;
        });
    }

    public List<J.TypeParameter> parseTypeParameters(String template) {
        String stub = this.addImports(this.substitute(TYPE_PARAMS_STUB, template));
        this.onBeforeParseTemplate.accept(stub);
        return this.cache(stub, () -> {
            J.CompilationUnit cu = this.compileTemplate(stub);
            List<J.TypeParameter> tps = cu.getClasses().get(0).getTypeParameters();
            assert (tps != null);
            return tps;
        });
    }

    public List<Statement> parseBlockStatements(Cursor cursor, String template, Space.Location location) {
        String stub = this.statementTemplateGenerator.template(cursor, template, location);
        this.onBeforeParseTemplate.accept(stub);
        return this.cache(stub, () -> {
            J.CompilationUnit cu = this.compileTemplate(stub);
            return this.statementTemplateGenerator.listTemplatedStatements(cu);
        });
    }

    public J.MethodInvocation parseMethodArguments(Cursor cursor, String template, Space.Location location) {
        J.MethodInvocation method = (J.MethodInvocation)cursor.getValue();
        String methodWithReplacementArgs = method.withArguments(Collections.emptyList()).printTrimmed().replaceAll("\\)$", template + ");");
        String stub = this.statementTemplateGenerator.template(cursor, methodWithReplacementArgs, location);
        this.onBeforeParseTemplate.accept(stub);
        List invocations = this.cache(stub, () -> {
            J.CompilationUnit cu = this.compileTemplate(stub);
            J.MethodInvocation replaced = (J.MethodInvocation)this.statementTemplateGenerator.listTemplatedStatements(cu).get(0);
            return Collections.singletonList(replaced);
        });
        return (J.MethodInvocation)invocations.get(0);
    }

    public List<J.Annotation> parseAnnotations(Cursor cursor, String template) {
        String stub = this.annotationTemplateGenerator.template(cursor, template);
        this.onBeforeParseTemplate.accept(stub);
        return this.cache(stub, () -> {
            J.CompilationUnit cu = this.compileTemplate(stub);
            return this.annotationTemplateGenerator.listAnnotations(cu);
        });
    }

    public Expression parsePackage(String template) {
        String stub = this.substitute(PACKAGE_STUB, template);
        this.onBeforeParseTemplate.accept(stub);
        return (Expression)this.cache(stub, () -> {
            J.CompilationUnit cu = this.compileTemplate(stub);
            Expression expression = cu.getPackageDeclaration().getExpression();
            return Collections.singletonList(expression);
        }).get(0);
    }

    private String substitute(String stub, String template) {
        String beforeParse = placeholderHelper.replacePlaceholders(stub, k -> template);
        this.onAfterVariableSubstitution.accept(beforeParse);
        return beforeParse;
    }

    private String addImports(String stub) {
        if (!this.imports.isEmpty()) {
            StringBuilder withImports = new StringBuilder();
            for (String anImport : this.imports) {
                withImports.append(anImport);
            }
            withImports.append(stub);
            return withImports.toString();
        }
        return stub;
    }

    private J.CompilationUnit compileTemplate(@Language(value="java") String stub) {
        return stub.contains("@SubAnnotation") ? this.parser.get().reset().parse(stub, SUBSTITUTED_ANNOTATION).get(0) : this.parser.get().reset().parse(stub).get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <J2 extends J> List<J2> cache(String stub, Supplier<List<? extends J>> ifAbsent) {
        List<? extends J> js;
        Object object = this.templateCacheLock;
        synchronized (object) {
            js = templateCache.get(stub);
            if (js == null) {
                js = ifAbsent.get();
                templateCache.put(stub, js);
            }
        }
        return ListUtils.map(js, j -> (J)new RandomizeIdVisitor().visit((Tree)j, 0));
    }
}

