/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public class NoEqualityInForCondition
extends Recipe {
    public String getDisplayName() {
        return "Use comparison rather than equality checks in for conditions";
    }

    public String getDescription() {
        return "Testing for loop termination using an equality operator (`==` and `!=`) is dangerous, because it could set up an infinite loop. Using a relational operator instead makes it harder to accidentally write an infinite loop.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-888");
    }

    protected JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            @Override
            public J visitForControl(J.ForLoop.Control control, ExecutionContext ctx) {
                if (control.getCondition() instanceof J.Binary) {
                    J.Binary condition = (J.Binary)control.getCondition();
                    if (condition.getRight() instanceof J.Literal && condition.getRight().getType() == JavaType.Primitive.Null) {
                        return super.visitForControl(control, ctx);
                    }
                    if (control.getUpdate().size() == 1 && control.getUpdate().get(0) instanceof J.Unary) {
                        J.Unary update = (J.Unary)control.getUpdate().get(0);
                        if (condition.getOperator() == J.Binary.Type.NotEqual) {
                            switch (update.getOperator()) {
                                case PreIncrement: 
                                case PostIncrement: {
                                    return control.withCondition(condition.withOperator(J.Binary.Type.LessThan));
                                }
                                case PreDecrement: 
                                case PostDecrement: {
                                    return control.withCondition(condition.withOperator(J.Binary.Type.GreaterThan));
                                }
                            }
                        }
                    }
                }
                return super.visitForControl(control, ctx);
            }
        };
    }
}

