/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;

@Incubating(since="7.10.0")
public class IndexOfReplaceableByContains
extends Recipe {
    private static final MethodMatcher STRING_INDEX_MATCHER = new MethodMatcher("java.lang.String indexOf(String)");
    private static final MethodMatcher LIST_INDEX_MATCHER = new MethodMatcher("java.util.List indexOf(Object)");

    public String getDisplayName() {
        return "`indexOf()` replaceable by `contains()`";
    }

    public String getDescription() {
        return "Checking if a value is included in a `String` or `List` using `indexOf(value)>-1` or `indexOf(value)>=0` can be replaced with `contains(value)`.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new IndexOfReplaceableByContainsVisitor();
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext executionContext) {
                this.doAfterVisit(new UsesMethod(STRING_INDEX_MATCHER));
                this.doAfterVisit(new UsesMethod(LIST_INDEX_MATCHER));
                return cu;
            }
        };
    }

    private static class IndexOfReplaceableByContainsVisitor
    extends JavaVisitor<ExecutionContext> {
        private final JavaTemplate stringContains = JavaTemplate.builder(() -> ((IndexOfReplaceableByContainsVisitor)this).getCursor(), "#{any(java.lang.String)}.contains(#{any(java.lang.String)})").build();
        private final JavaTemplate listContains = JavaTemplate.builder(() -> ((IndexOfReplaceableByContainsVisitor)this).getCursor(), "#{any(java.util.List)}.contains(#{any(java.lang.Object)})").build();

        private IndexOfReplaceableByContainsVisitor() {
        }

        @Override
        public J visitBinary(J.Binary binary, ExecutionContext ctx) {
            J j = super.visitBinary(binary, ctx);
            J.Binary asBinary = (J.Binary)j;
            if (asBinary.getLeft() instanceof J.MethodInvocation) {
                J.MethodInvocation mi = (J.MethodInvocation)asBinary.getLeft();
                if ((STRING_INDEX_MATCHER.matches(mi) || LIST_INDEX_MATCHER.matches(mi)) && asBinary.getRight() instanceof J.Literal) {
                    boolean isGreaterThanOrEqualToZero;
                    String valueSource = ((J.Literal)asBinary.getRight()).getValueSource();
                    boolean isGreaterThanNegativeOne = asBinary.getOperator() == J.Binary.Type.GreaterThan && "-1".equals(valueSource);
                    boolean bl = isGreaterThanOrEqualToZero = asBinary.getOperator() == J.Binary.Type.GreaterThanOrEqual && "0".equals(valueSource);
                    if (isGreaterThanNegativeOne || isGreaterThanOrEqualToZero) {
                        j = mi.withTemplate(STRING_INDEX_MATCHER.matches(mi) ? this.stringContains : this.listContains, mi.getCoordinates().replace(), mi.getSelect(), mi.getArguments().get(0)).withPrefix(asBinary.getPrefix());
                    }
                }
            }
            return j;
        }
    }
}

