/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.LinkedHashSet;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public final class ChangeMethodTargetToStatic
extends Recipe {
    @Option(displayName="Method pattern", description="A method pattern, expressed as a pointcut expression, that is used to find matching method invocations. The original method call may or may not be a static method invocation.", example="com.google.common.collect.ImmutableSet of(..)")
    private final String methodPattern;
    @Option(displayName="Fully-qualified target type name", description="A fully-qualified class name of the type upon which the static method is defined.", example="java.util.Set")
    private final String fullyQualifiedTargetTypeName;
    @Option(displayName="Return type after change", description="Sometimes changing the target type also changes the return type. In the Guava example, changing from `ImmutableSet#of(..)` to `Set#of(..)` widens the return type from Guava's `ImmutableSet` to just `java.util.Set`.", example="java.util.Set", required=false)
    @Nullable
    private final String returnType;

    public String getDisplayName() {
        return "Change method target to static";
    }

    public String getDescription() {
        return "Change method invocations to static method calls.";
    }

    protected JavaVisitor<ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesMethod<ExecutionContext>(this.methodPattern);
    }

    public JavaVisitor<ExecutionContext> getVisitor() {
        return new ChangeMethodTargetToStaticVisitor(new MethodMatcher(this.methodPattern));
    }

    public ChangeMethodTargetToStatic(String methodPattern, String fullyQualifiedTargetTypeName, @Nullable String returnType) {
        this.methodPattern = methodPattern;
        this.fullyQualifiedTargetTypeName = fullyQualifiedTargetTypeName;
        this.returnType = returnType;
    }

    public String getMethodPattern() {
        return this.methodPattern;
    }

    public String getFullyQualifiedTargetTypeName() {
        return this.fullyQualifiedTargetTypeName;
    }

    @Nullable
    public String getReturnType() {
        return this.returnType;
    }

    @NonNull
    public String toString() {
        return "ChangeMethodTargetToStatic(methodPattern=" + this.getMethodPattern() + ", fullyQualifiedTargetTypeName=" + this.getFullyQualifiedTargetTypeName() + ", returnType=" + this.getReturnType() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeMethodTargetToStatic)) {
            return false;
        }
        ChangeMethodTargetToStatic other = (ChangeMethodTargetToStatic)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        if (this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern)) {
            return false;
        }
        String this$fullyQualifiedTargetTypeName = this.getFullyQualifiedTargetTypeName();
        String other$fullyQualifiedTargetTypeName = other.getFullyQualifiedTargetTypeName();
        if (this$fullyQualifiedTargetTypeName == null ? other$fullyQualifiedTargetTypeName != null : !this$fullyQualifiedTargetTypeName.equals(other$fullyQualifiedTargetTypeName)) {
            return false;
        }
        String this$returnType = this.getReturnType();
        String other$returnType = other.getReturnType();
        return !(this$returnType == null ? other$returnType != null : !this$returnType.equals(other$returnType));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeMethodTargetToStatic;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        String $fullyQualifiedTargetTypeName = this.getFullyQualifiedTargetTypeName();
        result = result * 59 + ($fullyQualifiedTargetTypeName == null ? 43 : $fullyQualifiedTargetTypeName.hashCode());
        String $returnType = this.getReturnType();
        result = result * 59 + ($returnType == null ? 43 : $returnType.hashCode());
        return result;
    }

    private class ChangeMethodTargetToStaticVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final MethodMatcher methodMatcher;
        private final JavaType.FullyQualified classType;

        public ChangeMethodTargetToStaticVisitor(MethodMatcher methodMatcher) {
            this.classType = JavaType.Class.build(ChangeMethodTargetToStatic.this.fullyQualifiedTargetTypeName);
            this.methodMatcher = methodMatcher;
        }

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            boolean isSameReceiverType;
            J m = super.visitMethodInvocation(method, ctx);
            boolean isStatic = method.getType() != null && method.getType().hasFlags(Flag.Static);
            boolean bl = isSameReceiverType = method.getSelect() != null && TypeUtils.isOfClassType(method.getSelect().getType(), ChangeMethodTargetToStatic.this.fullyQualifiedTargetTypeName);
            if (!(isStatic && isSameReceiverType || !this.methodMatcher.matches(method))) {
                if (((J.MethodInvocation)m).getSelect() == null) {
                    this.maybeAddImport(ChangeMethodTargetToStatic.this.fullyQualifiedTargetTypeName, ((J.MethodInvocation)m).getSimpleName());
                } else {
                    this.maybeAddImport(ChangeMethodTargetToStatic.this.fullyQualifiedTargetTypeName);
                    m = method.withSelect(J.Identifier.build(Tree.randomId(), method.getSelect() == null ? Space.EMPTY : method.getSelect().getPrefix(), Markers.EMPTY, this.classType.getClassName(), this.classType));
                }
                JavaType.Method transformedType = null;
                if (method.getType() != null) {
                    this.maybeRemoveImport(method.getType().getDeclaringType());
                    transformedType = method.getType().withDeclaringType(this.classType);
                    if (!method.getType().hasFlags(Flag.Static)) {
                        LinkedHashSet<Flag> flags = new LinkedHashSet<Flag>(method.getType().getFlags());
                        flags.add(Flag.Static);
                        transformedType = transformedType.withFlags(flags);
                    }
                    if (ChangeMethodTargetToStatic.this.returnType != null) {
                        JavaType.Class returnTypeType = JavaType.Class.build(ChangeMethodTargetToStatic.this.returnType);
                        transformedType = transformedType.withResolvedSignature(transformedType.getResolvedSignature().withReturnType(returnTypeType));
                        transformedType = transformedType.withGenericSignature(transformedType.getGenericSignature().withReturnType(returnTypeType));
                    }
                }
                m = ((J.MethodInvocation)m).withType(transformedType);
            }
            return m;
        }
    }
}

