/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.UnwrapParentheses;
import org.openrewrite.java.style.UnnecessaryParenthesesStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

@Incubating(since="7.0.0")
public class UnnecessaryParenthesesVisitor<P>
extends JavaVisitor<P> {
    private final UnnecessaryParenthesesStyle style;
    private static final String UNNECESSARY_PARENTHESES_MARKER = "unnecessaryParenthesesUnwrapTarget";

    public UnnecessaryParenthesesVisitor(UnnecessaryParenthesesStyle style) {
        this.style = style;
    }

    @Override
    public <T extends J> J visitParentheses(J.Parentheses<T> parens, P p) {
        J par = super.visitParentheses(parens, p);
        Cursor c = (Cursor)this.getCursor().pollNearestMessage(UNNECESSARY_PARENTHESES_MARKER);
        if (c != null && (c.getValue() instanceof J.Literal || c.getValue() instanceof J.Identifier)) {
            par = (J)new UnwrapParentheses((J.Parentheses)par).visit(par, p, this.getCursor());
        }
        return par;
    }

    @Override
    public J visitIdentifier(J.Identifier ident, P p) {
        J.Identifier i = (J.Identifier)this.visitAndCast(ident, p, (x$0, x$1) -> super.visitIdentifier((J.Identifier)x$0, x$1));
        if (this.style.isIdent()) {
            if (this.getCursor().dropParentUntil(J.class::isInstance).getValue() instanceof J.Parentheses) {
                this.getCursor().putMessageOnFirstEnclosing(J.Parentheses.class, UNNECESSARY_PARENTHESES_MARKER, (Object)this.getCursor());
            }
        }
        return i;
    }

    @Override
    public J visitLiteral(J.Literal literal, P p) {
        J.Literal l;
        block5: {
            block4: {
                l = (J.Literal)this.visitAndCast(literal, p, (x$0, x$1) -> super.visitLiteral((J.Literal)x$0, x$1));
                JavaType.Primitive type = l.getType();
                if (this.style.isNumInt() && type == JavaType.Primitive.Int || this.style.isNumDouble() && type == JavaType.Primitive.Double || this.style.isNumLong() && type == JavaType.Primitive.Long || this.style.isNumFloat() && type == JavaType.Primitive.Float || this.style.isStringLiteral() && type == JavaType.Primitive.String || this.style.isLiteralNull() && type == JavaType.Primitive.Null || this.style.isLiteralFalse() && type == JavaType.Primitive.Boolean && l.getValue() == Boolean.valueOf(false)) break block4;
                if (!this.style.isLiteralTrue() || type != JavaType.Primitive.Boolean || l.getValue() != Boolean.valueOf(true)) break block5;
            }
            if (this.getCursor().dropParentUntil(J.class::isInstance).getValue() instanceof J.Parentheses) {
                this.getCursor().putMessageOnFirstEnclosing(J.Parentheses.class, UNNECESSARY_PARENTHESES_MARKER, (Object)this.getCursor());
            }
        }
        return l;
    }

    @Override
    public J visitAssignmentOperation(J.AssignmentOperation assignOp, P p) {
        J.AssignmentOperation a = (J.AssignmentOperation)this.visitAndCast(assignOp, p, (x$0, x$1) -> super.visitAssignmentOperation((J.AssignmentOperation)x$0, x$1));
        J.AssignmentOperation.Type op = a.getOperator();
        if (a.getAssignment() instanceof J.Parentheses && (this.style.isBandAssign() && op == J.AssignmentOperation.Type.BitAnd || this.style.isBorAssign() && op == J.AssignmentOperation.Type.BitOr || this.style.isBsrAssign() && op == J.AssignmentOperation.Type.UnsignedRightShift || this.style.isBxorAssign() && op == J.AssignmentOperation.Type.BitXor || this.style.isSrAssign() && op == J.AssignmentOperation.Type.RightShift || this.style.isSlAssign() && op == J.AssignmentOperation.Type.LeftShift || this.style.isMinusAssign() && op == J.AssignmentOperation.Type.Subtraction || this.style.isDivAssign() && op == J.AssignmentOperation.Type.Division || this.style.isPlusAssign() && op == J.AssignmentOperation.Type.Addition || this.style.isStarAssign() && op == J.AssignmentOperation.Type.Multiplication || this.style.isModAssign() && op == J.AssignmentOperation.Type.Modulo)) {
            a = (J.AssignmentOperation)new UnwrapParentheses((J.Parentheses)a.getAssignment()).visit(a, p, this.getCursor());
        }
        return a;
    }

    @Override
    public J visitAssignment(J.Assignment assignment, P p) {
        J.Assignment a = (J.Assignment)this.visitAndCast(assignment, p, (x$0, x$1) -> super.visitAssignment((J.Assignment)x$0, x$1));
        if (this.style.isAssign() && a.getAssignment() instanceof J.Parentheses) {
            a = (J.Assignment)new UnwrapParentheses((J.Parentheses)a.getAssignment()).visit(a, p, this.getCursor());
        }
        return a;
    }

    @Override
    public J visitVariable(J.VariableDeclarations.NamedVariable variable, P p) {
        J.VariableDeclarations.NamedVariable v = (J.VariableDeclarations.NamedVariable)this.visitAndCast(variable, p, (x$0, x$1) -> super.visitVariable((J.VariableDeclarations.NamedVariable)x$0, x$1));
        if (this.style.isAssign() && v.getInitializer() != null && v.getInitializer() instanceof J.Parentheses) {
            v = (J.VariableDeclarations.NamedVariable)new UnwrapParentheses((J.Parentheses)v.getInitializer()).visit(v, p, this.getCursor());
        }
        return v;
    }

    @Override
    public J visitLambda(J.Lambda lambda, P p) {
        J.Lambda l = (J.Lambda)this.visitAndCast(lambda, p, (x$0, x$1) -> super.visitLambda((J.Lambda)x$0, x$1));
        if (l.getParameters().getParameters().size() == 1 && l.getParameters().isParenthesized() && l.getParameters().getParameters().get(0) instanceof J.VariableDeclarations && ((J.VariableDeclarations)l.getParameters().getParameters().get(0)).getTypeExpression() == null) {
            l = l.withParameters(l.getParameters().withParenthesized(false));
        }
        return l;
    }
}

