/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.cleanup.HideUtilityClassConstructorStyle;
import org.openrewrite.java.cleanup.HideUtilityClassConstructorVisitor;
import org.openrewrite.java.tree.J;

@Incubating(since="7.0.0")
public class HideUtilityClassConstructor
extends Recipe {
    public String getDisplayName() {
        return "Hide utility class constructor";
    }

    public String getDescription() {
        return "";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new HideUtilityClassConstructorFromCompilationUnitStyle();
    }

    private static class HideUtilityClassConstructorFromCompilationUnitStyle
    extends JavaIsoVisitor<ExecutionContext> {
        private HideUtilityClassConstructorFromCompilationUnitStyle() {
        }

        @Override
        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext executionContext) {
            HideUtilityClassConstructorStyle style = (HideUtilityClassConstructorStyle)cu.getStyle(HideUtilityClassConstructorStyle.class);
            if (style == null) {
                style = HideUtilityClassConstructorStyle.hideUtilityClassConstructorStyle();
            }
            this.doAfterVisit(new HideUtilityClassConstructorVisitor(style));
            return super.visitCompilationUnit(cu, executionContext);
        }
    }
}

