/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeTree;

public class MinimumViableSpacingVisitor<P>
extends JavaIsoVisitor<P> {
    @Override
    public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, P p) {
        Space before;
        J.ClassDeclaration.Padding padding;
        JContainer<J.TypeParameter> typeParameters;
        J c = super.visitClassDeclaration(classDecl, (Object)p);
        boolean first = true;
        if (!((J.ClassDeclaration)c).getAnnotations().isEmpty()) {
            first = false;
        }
        if (!((J.ClassDeclaration)c).getModifiers().isEmpty()) {
            if (!first && Space.firstPrefix(((J.ClassDeclaration)c).getModifiers()).getWhitespace().isEmpty()) {
                c = ((J.ClassDeclaration)c).withModifiers(Space.formatFirstPrefix(((J.ClassDeclaration)c).getModifiers(), ((J.ClassDeclaration)c).getModifiers().iterator().next().getPrefix().withWhitespace(" ")));
            }
            first = false;
        }
        if (!((typeParameters = (padding = ((J.ClassDeclaration)c).getPadding()).getTypeParameters()) == null || typeParameters.getElements().isEmpty() || first || typeParameters.getBefore().getWhitespace().isEmpty())) {
            c = padding.withTypeParameters(typeParameters.withBefore(typeParameters.getBefore().withWhitespace(" ")));
        }
        if (((J.ClassDeclaration)(c = ((J.ClassDeclaration)c).withName(((J.ClassDeclaration)c).getName().withPrefix(((J.ClassDeclaration)c).getName().getPrefix().withWhitespace(" "))))).getPadding().getExtends() != null && (before = ((J.ClassDeclaration)c).getPadding().getExtends().getBefore()).getWhitespace().isEmpty()) {
            c = ((J.ClassDeclaration)c).getPadding().withExtends(((J.ClassDeclaration)c).getPadding().getExtends().withBefore(before.withWhitespace(" ")));
        }
        if (((J.ClassDeclaration)c).getPadding().getImplements() != null && (before = ((J.ClassDeclaration)c).getPadding().getImplements().getBefore()).getWhitespace().isEmpty()) {
            c = ((J.ClassDeclaration)c).getPadding().withImplements(((J.ClassDeclaration)c).getPadding().getImplements().withBefore(before.withWhitespace(" ")));
        }
        return c;
    }

    @Override
    public J.Block visitBlock(J.Block block, P p) {
        J b = super.visitBlock(block, (Object)p);
        Object parent = this.getCursor().getParent().getValue();
        if (!((J.Block)b).isStatic() && (parent instanceof J.MethodDeclaration || parent instanceof J.ClassDeclaration) && ((J.Block)b).getPrefix().getWhitespace().isEmpty()) {
            b = ((J.Block)b).withPrefix(((J.Block)b).getPrefix().withWhitespace(" "));
        }
        return b;
    }

    @Override
    public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, P p) {
        Space before;
        J.MethodDeclaration.Padding padding;
        JContainer<J.TypeParameter> typeParameters;
        J m = super.visitMethodDeclaration(method, (Object)p);
        boolean first = true;
        if (!((J.MethodDeclaration)m).getAnnotations().isEmpty()) {
            first = false;
        }
        if (!((J.MethodDeclaration)m).getModifiers().isEmpty()) {
            if (!first && Space.firstPrefix(((J.MethodDeclaration)m).getModifiers()).getWhitespace().isEmpty()) {
                m = ((J.MethodDeclaration)m).withModifiers(Space.formatFirstPrefix(((J.MethodDeclaration)m).getModifiers(), ((J.MethodDeclaration)m).getModifiers().iterator().next().getPrefix().withWhitespace(" ")));
            }
            first = false;
        }
        if ((typeParameters = (padding = ((J.MethodDeclaration)m).getPadding()).getTypeParameters()) != null && !typeParameters.getElements().isEmpty()) {
            if (!first && typeParameters.getBefore().getWhitespace().isEmpty()) {
                m = padding.withTypeParameters(typeParameters.withBefore(typeParameters.getBefore().withWhitespace(" ")));
            }
            first = false;
        }
        if (((J.MethodDeclaration)m).getReturnTypeExpression() != null && ((J.MethodDeclaration)m).getReturnTypeExpression().getPrefix().getWhitespace().isEmpty()) {
            if (!first) {
                m = ((J.MethodDeclaration)m).withReturnTypeExpression((TypeTree)((J.MethodDeclaration)m).getReturnTypeExpression().withPrefix(((J.MethodDeclaration)m).getReturnTypeExpression().getPrefix().withWhitespace(" ")));
            }
            first = false;
        }
        if (!first) {
            m = ((J.MethodDeclaration)m).withName(((J.MethodDeclaration)m).getName().withPrefix(((J.MethodDeclaration)m).getName().getPrefix().withWhitespace(" ")));
        }
        if (((J.MethodDeclaration)m).getPadding().getThrows() != null && (before = ((J.MethodDeclaration)m).getPadding().getThrows().getBefore()).getWhitespace().isEmpty()) {
            m = ((J.MethodDeclaration)m).getPadding().withThrows(((J.MethodDeclaration)m).getPadding().getThrows().withBefore(before.withWhitespace(" ")));
        }
        return m;
    }

    @Override
    public J.Return visitReturn(J.Return retrn, P p) {
        J r = super.visitReturn(retrn, (Object)p);
        if (((J.Return)r).getExpression() != null && ((J.Return)r).getExpression().getPrefix().getWhitespace().isEmpty()) {
            r = ((J.Return)r).withExpression((Expression)((J.Return)r).getExpression().withPrefix(((J.Return)r).getExpression().getPrefix().withWhitespace(" ")));
        }
        return r;
    }

    @Override
    public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, P p) {
        J v = super.visitVariableDeclarations(multiVariable, (Object)p);
        if (Space.firstPrefix(((J.VariableDeclarations)v).getVariables()).getWhitespace().isEmpty()) {
            v = ((J.VariableDeclarations)v).withVariables(Space.formatFirstPrefix(((J.VariableDeclarations)v).getVariables(), ((J.VariableDeclarations)v).getVariables().iterator().next().getPrefix().withWhitespace(" ")));
        }
        if (!((J.VariableDeclarations)v).getModifiers().isEmpty()) {
            v = ((J.VariableDeclarations)v).withModifiers(ListUtils.map(((J.VariableDeclarations)v).getModifiers(), (index, modifier) -> {
                if (index != 0 && modifier.getPrefix().getWhitespace().isEmpty()) {
                    modifier = modifier.withPrefix(modifier.getPrefix().withWhitespace(" "));
                }
                return modifier;
            }));
        }
        if (!((J.VariableDeclarations)v).getModifiers().isEmpty() && ((J.VariableDeclarations)v).getTypeExpression() != null && ((J.VariableDeclarations)v).getTypeExpression().getPrefix().isEmpty()) {
            v = ((J.VariableDeclarations)v).withTypeExpression((TypeTree)((J.VariableDeclarations)v).getTypeExpression().withPrefix(((J.VariableDeclarations)v).getTypeExpression().getPrefix().withWhitespace(" ")));
        }
        return v;
    }
}

