/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.internal.FormatFirstClassPrefix;
import org.openrewrite.java.style.ImportLayoutStyle;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;

public class RemoveUnusedImports
extends Recipe {
    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new RemoveUnusedImportsVisitor();
    }

    private static class RemoveUnusedImportsVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        RemoveUnusedImportsVisitor() {
            this.setCursoringOn();
        }

        @Override
        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
            ImportLayoutStyle layoutStyle = Optional.ofNullable((ImportLayoutStyle)cu.getStyle(ImportLayoutStyle.class)).orElse(IntelliJ.importLayout());
            HashMap methodsByTypeName = new HashMap();
            new StaticMethodsByType().visit(cu, methodsByTypeName);
            HashMap typesByPackage = new HashMap();
            new TypesByPackage().visit(cu, typesByPackage);
            boolean changed = false;
            ArrayList<JRightPadded<J.Import>> importsWithUsage = new ArrayList<JRightPadded<J.Import>>();
            for (JRightPadded<J.Import> anImport : cu.getPadding().getImports()) {
                J.Import elem = anImport.getElement();
                J.FieldAccess qualid = elem.getQualid();
                J.Identifier name = qualid.getName();
                if (anImport.getElement().isStatic()) {
                    Set methods = (Set)methodsByTypeName.get(anImport.getElement().getTypeName());
                    if (methods == null) {
                        changed = true;
                        continue;
                    }
                    if ("*".equals(qualid.getSimpleName())) {
                        if (methods.size() < layoutStyle.getNameCountToUseStarImport()) {
                            methods.stream().sorted().forEach(method -> importsWithUsage.add(anImport.withElement(elem.withQualid(qualid.withName(name.withName((String)method))))));
                            changed = true;
                            continue;
                        }
                        importsWithUsage.add(anImport);
                        continue;
                    }
                    importsWithUsage.add(anImport);
                    continue;
                }
                Set types = (Set)typesByPackage.get(anImport.getElement().getPackageName());
                if (types == null) {
                    changed = true;
                    continue;
                }
                if ("*".equals(anImport.getElement().getQualid().getSimpleName())) {
                    if (types.size() < layoutStyle.getClassCountToUseStarImport()) {
                        types.stream().map(JavaType.FullyQualified::getClassName).sorted().forEach(typeClassName -> importsWithUsage.add(anImport.withElement(elem.withQualid(qualid.withName(name.withName((String)typeClassName))).withPrefix(Space.format("\n")))));
                        changed = true;
                        continue;
                    }
                    importsWithUsage.add(anImport);
                    continue;
                }
                importsWithUsage.add(anImport);
            }
            J.CompilationUnit compilationUnit = cu = changed ? cu.getPadding().withImports(importsWithUsage) : cu;
            if (changed) {
                this.doAfterVisit(new FormatFirstClassPrefix());
                if (cu.getPackageDeclaration() == null) {
                    cu = cu.withImports(ListUtils.mapFirst(cu.getImports(), i -> this.autoFormat(i, ctx)));
                }
            }
            return cu;
        }

        private static class StaticMethodsByType
        extends JavaIsoVisitor<Map<String, Set<String>>> {
            private StaticMethodsByType() {
            }

            @Override
            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, Map<String, Set<String>> ctx) {
                JavaType.Method type;
                J m = super.visitMethodInvocation(method, ctx);
                if (method.getSelect() == null && (type = method.getType()) != null && type.hasFlags(Flag.Static)) {
                    ctx.computeIfAbsent(type.getDeclaringType().getFullyQualifiedName(), t -> new HashSet()).add(type.getName());
                }
                return m;
            }
        }

        private static class TypesByPackage
        extends JavaIsoVisitor<Map<String, Set<JavaType.Class>>> {
            TypesByPackage() {
                this.setCursoringOn();
            }

            @Override
            public <N extends NameTree> N visitTypeName(N name, Map<String, Set<JavaType.Class>> ctx) {
                JavaType.Class clazz;
                if (this.getCursor().firstEnclosing(J.Import.class) == null && (clazz = TypeUtils.asClass(name.getType())) != null) {
                    ctx.computeIfAbsent(clazz.getPackageName(), t -> new HashSet()).add(clazz);
                }
                return super.visitTypeName(name, ctx);
            }
        }
    }
}

