/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.Tree;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.format.AutoFormatVisitor;
import org.openrewrite.java.internal.template.ExtractTrees;
import org.openrewrite.java.internal.template.InsertAtCoordinates;
import org.openrewrite.java.internal.template.JavaTemplatePrinter;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaCoordinates;

@Incubating(since="7.0.0")
public class JavaTemplate {
    private final Supplier<Cursor> parentScopeGetter;
    private final JavaParser parser;
    private final String code;
    private final int parameterCount;
    private final Set<String> imports;
    private final String parameterMarker;
    private final Consumer<String> onAfterVariableSubstitution;
    private final Consumer<String> onBeforeParseTemplate;

    private JavaTemplate(Supplier<Cursor> parentScopeGetter, JavaParser parser, String code, Set<String> imports, String parameterMarker, Consumer<String> onAfterVariableSubstitution, Consumer<String> onBeforeParseTemplate) {
        this.parentScopeGetter = parentScopeGetter;
        this.parser = parser;
        this.code = code;
        this.imports = imports;
        this.parameterMarker = parameterMarker;
        this.onAfterVariableSubstitution = onAfterVariableSubstitution;
        this.onBeforeParseTemplate = onBeforeParseTemplate;
        this.parameterCount = StringUtils.countOccurrences((String)code, (String)parameterMarker);
    }

    public static Builder builder(Supplier<Cursor> parentScope, String code) {
        return new Builder(parentScope, code);
    }

    public <J2 extends J> J2 withTemplate(Tree changing, JavaCoordinates coordinates, Object ... parameters) {
        Cursor parentScope = this.parentScopeGetter.get();
        if (parameters.length != this.parameterCount) {
            throw new IllegalArgumentException("This template requires " + this.parameterCount + " parameters.");
        }
        String substitutedTemplate = this.substituteParameters(parameters);
        this.onAfterVariableSubstitution.accept(substitutedTemplate);
        J.CompilationUnit cu = (J.CompilationUnit)parentScope.firstEnclosingOrThrow(J.CompilationUnit.class);
        Cursor insertionScope = JavaTemplatePrinter.findCoordinateCursor(parentScope, changing, coordinates);
        String generatedSource = new JavaTemplatePrinter(substitutedTemplate, changing, coordinates, this.imports).print(cu, insertionScope);
        this.onBeforeParseTemplate.accept(generatedSource);
        this.parser.reset();
        J.CompilationUnit synthetic = this.parser.parse(generatedSource).iterator().next();
        List<J> generatedElements = ExtractTrees.extract(synthetic);
        for (int i = 0; i < generatedElements.size(); ++i) {
            J snippet = generatedElements.get(i);
            generatedElements.set(i, (J)new AutoFormatVisitor().visit((Tree)snippet, (Object)0, parentScope));
        }
        return (J2)((J)new InsertAtCoordinates(coordinates).visit(changing, generatedElements, parentScope));
    }

    private String substituteParameters(Object ... parameters) {
        String codeInstance = this.code;
        for (Object parameter : parameters) {
            codeInstance = StringUtils.replaceFirst((String)codeInstance, (String)this.parameterMarker, (String)this.substituteParameter(parameter));
        }
        return codeInstance;
    }

    private String substituteParameter(Object parameter) {
        if (parameter instanceof Tree) {
            return ((Tree)parameter).printTrimmed();
        }
        if (parameter instanceof JRightPadded) {
            return this.substituteParameter(((JRightPadded)parameter).getElement());
        }
        if (parameter instanceof JLeftPadded) {
            return this.substituteParameter(((JLeftPadded)parameter).getElement());
        }
        return parameter.toString();
    }

    public static class Builder {
        private final Supplier<Cursor> parentScope;
        private final String code;
        private final Set<String> imports = new HashSet<String>();
        private JavaParser javaParser = ((JavaParser.Builder)JavaParser.fromJavaVersion().logCompilationWarningsAndErrors(false)).build();
        private String parameterMarker = "#{}";
        private Consumer<String> onAfterVariableSubstitution = s -> {};
        private Consumer<String> onBeforeParseTemplate = s -> {};

        Builder(Supplier<Cursor> parentScope, String code) {
            this.parentScope = parentScope;
            this.code = code.trim();
        }

        public Builder imports(String ... fullyQualifiedTypeNames) {
            for (String typeName : fullyQualifiedTypeNames) {
                if (typeName.startsWith("import ") || typeName.startsWith("static ")) {
                    throw new IllegalArgumentException("Imports are expressed as fully-qualified names and should not include an \"import \" or \"static \" prefix");
                }
                if (typeName.endsWith(";") || typeName.endsWith("\n")) {
                    throw new IllegalArgumentException("Imports are expressed as fully-qualified names and should not include a suffixed terminator");
                }
                this.imports.add("import " + typeName + ";\n");
            }
            return this;
        }

        public Builder staticImports(String ... fullyQualifiedMemberTypeNames) {
            for (String typeName : fullyQualifiedMemberTypeNames) {
                if (typeName.startsWith("import ") || typeName.startsWith("static ")) {
                    throw new IllegalArgumentException("Imports are expressed as fully-qualified names and should not include an \"import \" or \"static \" prefix");
                }
                if (typeName.endsWith(";") || typeName.endsWith("\n")) {
                    throw new IllegalArgumentException("Imports are expressed as fully-qualified names and should not include a suffixed terminator");
                }
                this.imports.add("static import " + typeName + ";\n");
            }
            return this;
        }

        public Builder javaParser(JavaParser javaParser) {
            this.javaParser = javaParser;
            return this;
        }

        public Builder parameterMarker(String parameterMarker) {
            this.parameterMarker = parameterMarker;
            return this;
        }

        public Builder doAfterVariableSubstitution(Consumer<String> afterVariableSubstitution) {
            this.onAfterVariableSubstitution = afterVariableSubstitution;
            return this;
        }

        public Builder doBeforeParseTemplate(Consumer<String> beforeParseTemplate) {
            this.onBeforeParseTemplate = beforeParseTemplate;
            return this;
        }

        public JavaTemplate build() {
            return new JavaTemplate(this.parentScope, this.javaParser, this.code, this.imports, this.parameterMarker, this.onAfterVariableSubstitution, this.onBeforeParseTemplate);
        }
    }
}

