/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markable;
import org.openrewrite.marker.Markers;

public class JContainer<T>
implements Markable {
    private static final JContainer<?> EMPTY = new JContainer(Space.EMPTY, Collections.emptyList(), Markers.EMPTY);
    private final Space before;
    private final List<JRightPadded<T>> elem;
    private final Markers markers;

    private JContainer(Space before, List<JRightPadded<T>> elem, Markers markers) {
        this.before = before;
        this.elem = elem;
        this.markers = markers;
    }

    @JsonCreator
    public static <T> JContainer<T> build(@JsonProperty(value="before") Space before, @JsonProperty(value="elem") List<JRightPadded<T>> elem, @JsonProperty(value="markers") Markers markers) {
        if (before.isEmpty() && elem.isEmpty()) {
            return JContainer.empty();
        }
        return new JContainer<T>(before, elem, markers);
    }

    public static <T> JContainer<T> empty() {
        return EMPTY;
    }

    public JContainer<T> withBefore(Space before) {
        return JContainer.build(before, this.elem, this.markers);
    }

    public JContainer<T> withElem(List<JRightPadded<T>> elem) {
        return JContainer.build(this.getBefore(), elem, this.markers);
    }

    public JContainer<T> withMarkers(Markers markers) {
        return JContainer.build(this.getBefore(), this.elem, markers);
    }

    public List<JRightPadded<T>> getElem() {
        return this.elem;
    }

    public Space getBefore() {
        return this.before;
    }

    public Markers getMarkers() {
        return this.markers;
    }

    public JContainer<T> map(Function<T, T> map) {
        return this.withElem(ListUtils.map(this.elem, t -> t.map(map)));
    }

    @JsonIgnore
    public Space getLastSpace() {
        return this.elem.isEmpty() ? Space.EMPTY : this.elem.get(this.elem.size() - 1).getAfter();
    }

    public static enum Location {
        ANNOTATION_ARGUMENT(JRightPadded.Location.ANNOTATION_ARGUMENT),
        CASE(JRightPadded.Location.CASE),
        IMPLEMENTS(JRightPadded.Location.IMPLEMENTS),
        METHOD_DECL_ARGUMENT(JRightPadded.Location.METHOD_DECL_ARGUMENT),
        METHOD_INVOCATION_ARGUMENT(JRightPadded.Location.METHOD_INVOCATION_ARGUMENT),
        NEW_ARRAY_INITIALIZER(JRightPadded.Location.NEW_ARRAY_INITIALIZER),
        NEW_CLASS_ARGS(JRightPadded.Location.NEW_CLASS_ARGS),
        THROWS(JRightPadded.Location.THROWS),
        TRY_RESOURCES(JRightPadded.Location.TRY_RESOURCES),
        TYPE_BOUND(JRightPadded.Location.TYPE_BOUND),
        TYPE_PARAMETER(JRightPadded.Location.TYPE_PARAMETER);

        private final JRightPadded.Location elemLocation;

        private Location(JRightPadded.Location elemLocation) {
            this.elemLocation = elemLocation;
        }

        public JRightPadded.Location getElemLocation() {
            return this.elemLocation;
        }
    }
}

