/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.beans.ConstructorProperties;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.SearchResult;

public final class FindMethod
extends Recipe {
    private final String methodPattern;

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new FindMethodVisitor(this.methodPattern);
    }

    public static Set<J.MethodInvocation> find(J j, String methodPattern) {
        return ((J)new FindMethodVisitor(methodPattern).visit(j, ExecutionContext.builder().build())).findMarkedWith(SearchResult.class);
    }

    @ConstructorProperties(value={"methodPattern"})
    public FindMethod(String methodPattern) {
        this.methodPattern = methodPattern;
    }

    public String getMethodPattern() {
        return this.methodPattern;
    }

    public String toString() {
        return "FindMethod(methodPattern=" + this.getMethodPattern() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindMethod)) {
            return false;
        }
        FindMethod other = (FindMethod)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        return !(this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FindMethod;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        return result;
    }

    private static class FindMethodVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final MethodMatcher matcher;

        public FindMethodVisitor(String signature) {
            this.matcher = new MethodMatcher(signature);
        }

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J m = super.visitMethodInvocation(method, ctx);
            if (this.matcher.matches(method)) {
                return (J.MethodInvocation)m.mark(new Marker[]{new SearchResult()});
            }
            return super.visitMethodInvocation((J.MethodInvocation)m, ctx);
        }
    }
}

