/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import java.util.List;
import java.util.Optional;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.style.TabsAndIndentsStyle;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;

class TabsAndIndentsVisitor<P>
extends JavaIsoVisitor<P> {
    private final TabsAndIndentsStyle style;

    public TabsAndIndentsVisitor(TabsAndIndentsStyle style) {
        this.style = style;
        this.setCursoringOn();
    }

    @Nullable
    public J visit(@Nullable Tree tree, P p, Cursor parent) {
        this.setCursor(parent);
        for (Cursor c = parent; c != null; c = c.getParent()) {
            int indent;
            Object v = c.getValue();
            Space space = null;
            if (v instanceof J) {
                space = ((J)v).getPrefix();
            } else if (v instanceof JRightPadded) {
                space = ((JRightPadded)v).getAfter();
            } else if (v instanceof JLeftPadded) {
                space = ((JLeftPadded)v).getBefore();
            } else if (v instanceof JContainer) {
                space = ((JContainer)v).getBefore();
            }
            if (space == null || !space.getWhitespace().contains("\n") || (indent = this.findIndent(space)) == 0) continue;
            c.putMessage("lastIndent", (Object)indent);
        }
        this.visitEach((J)parent.getValue(), p);
        return (J)this.visit(tree, p);
    }

    @Nullable
    public J visitEach(J tree, P p) {
        if (tree instanceof J.CompilationUnit || tree instanceof J.Package || tree instanceof J.Import || tree instanceof J.Label || tree instanceof J.DoWhileLoop || tree instanceof J.ArrayDimension || tree instanceof J.ClassDecl) {
            this.getCursor().putMessage("indentType", (Object)IndentType.ALIGN);
        } else if (tree instanceof J.Block || tree instanceof J.If || tree instanceof J.If.Else || tree instanceof J.ForLoop || tree instanceof J.ForEachLoop || tree instanceof J.WhileLoop || tree instanceof J.Case || tree instanceof J.EnumValueSet) {
            this.getCursor().putMessage("indentType", (Object)IndentType.INDENT);
        } else {
            this.getCursor().putMessage("indentType", (Object)IndentType.CONTINUATION_INDENT);
        }
        return (J)super.visitEach((Tree)tree, p);
    }

    @Override
    public J visitForControl(J.ForLoop.Control control, P p) {
        return control;
    }

    @Override
    public J visitForEachControl(J.ForEachLoop.Control control, P p) {
        return control;
    }

    @Override
    public Space visitSpace(Space space, P p) {
        boolean alignToAnnotation;
        Cursor parent = this.getCursor().getParent();
        if (parent != null && parent.getValue() instanceof J.Annotation) {
            parent.getParentOrThrow().putMessage("afterAnnotation", (Object)true);
        }
        if (!space.getWhitespace().contains("\n") || parent == null) {
            return space;
        }
        int indent = Optional.ofNullable((Integer)this.getCursor().peekNearestMessage("lastIndent")).orElse(0);
        IndentType indentType = Optional.ofNullable((IndentType)((Object)this.getCursor().getParentOrThrow().peekNearestMessage("indentType"))).orElse(IndentType.ALIGN);
        boolean alignBlockToParent = this.getCursor().getValue() instanceof J.Block;
        boolean bl = alignToAnnotation = this.getCursor().pollNearestMessage("afterAnnotation") != null && !(this.getCursor().getParentOrThrow().getValue() instanceof J.Annotation);
        if (alignBlockToParent || alignToAnnotation) {
            indentType = IndentType.ALIGN;
        }
        switch (indentType) {
            case ALIGN: {
                break;
            }
            case INDENT: {
                indent += this.style.getIndentSize();
                break;
            }
            case CONTINUATION_INDENT: {
                indent += this.style.getContinuationIndent();
            }
        }
        Space s = this.indentTo(space, indent);
        if (!(this.getCursor().getValue() instanceof JLeftPadded)) {
            this.getCursor().putMessage("lastIndent", (Object)indent);
        }
        return s;
    }

    @Override
    public <J2 extends J> JRightPadded<J2> visitRightPadded(JRightPadded<J2> right, JRightPadded.Location loc, P p) {
        Space after;
        J j;
        this.setCursor(new Cursor(this.getCursor(), right));
        int indent = Optional.ofNullable((Integer)this.getCursor().peekNearestMessage("lastIndent")).orElse(0);
        if (right.getAfter().getWhitespace().contains("\n") || ((J)right.getElem()).getPrefix().getWhitespace().contains("\n")) {
            switch (loc) {
                case FOR_CONDITION: 
                case FOR_UPDATE: {
                    J.ForLoop.Control control = (J.ForLoop.Control)this.getCursor().getParentOrThrow().getValue();
                    Space initPrefix = control.getInit().getElem().getPrefix();
                    if (!initPrefix.getWhitespace().contains("\n")) {
                        int initIndent = this.forInitColumn();
                        this.getCursor().getParentOrThrow().putMessage("lastIndent", (Object)(initIndent - this.style.getContinuationIndent()));
                        j = (J)this.visitAndCast((Tree)right.getElem(), p);
                        this.getCursor().getParentOrThrow().putMessage("lastIndent", (Object)indent);
                        after = this.indentTo(right.getAfter(), initIndent);
                        break;
                    }
                    j = (J)this.visitAndCast((Tree)right.getElem(), p);
                    after = this.visitSpace(right.getAfter(), p);
                    break;
                }
                case METHOD_DECL_ARGUMENT: {
                    JContainer container = (JContainer)this.getCursor().getParentOrThrow().getValue();
                    Expression firstArg = (Expression)container.getElem().iterator().next().getElem();
                    if (firstArg.getPrefix().getWhitespace().contains("\n")) {
                        j = (J)this.visitAndCast((Tree)right.getElem(), p);
                        after = this.indentTo(right.getAfter(), indent);
                        break;
                    }
                    int firstArgIndent = this.findIndent(firstArg.getPrefix());
                    this.getCursor().getParentOrThrow().putMessage("lastIndent", (Object)firstArgIndent);
                    j = (J)this.visitAndCast((Tree)right.getElem(), p);
                    this.getCursor().getParentOrThrow().putMessage("lastIndent", (Object)indent);
                    after = this.indentTo(right.getAfter(), firstArgIndent);
                    break;
                }
                case ARRAY_INDEX: 
                case METHOD_INVOCATION_ARGUMENT: 
                case NEW_CLASS_ARGS: 
                case PARENTHESES: 
                case TYPE_PARAMETER: {
                    j = (J)this.visitAndCast((Tree)right.getElem(), p);
                    after = this.indentTo(right.getAfter(), indent);
                    break;
                }
                case METHOD_SELECT: {
                    Cursor cursor = this.getCursor();
                    while (true) {
                        if (cursor.getValue() instanceof JRightPadded) {
                            cursor = cursor.getParentOrThrow();
                        }
                        if (!(cursor.getValue() instanceof J.MethodInvocation)) break;
                        Integer methodIndent = (Integer)cursor.peekNearestMessage("lastIndent");
                        if (methodIndent != null) {
                            indent = methodIndent;
                        }
                        cursor = cursor.getParentOrThrow();
                    }
                    this.getCursor().getParentOrThrow().putMessage("lastIndent", (Object)indent);
                    j = (J)this.visitAndCast((Tree)right.getElem(), p);
                    after = this.visitSpace(right.getAfter(), p);
                    this.getCursor().getParentOrThrow().putMessage("lastIndent", (Object)(indent + this.style.getContinuationIndent()));
                    break;
                }
                default: {
                    j = (J)this.visitAndCast((Tree)right.getElem(), p);
                    after = this.visitSpace(right.getAfter(), p);
                    break;
                }
            }
        } else {
            switch (loc) {
                case METHOD_INVOCATION_ARGUMENT: 
                case NEW_CLASS_ARGS: {
                    this.getCursor().putMessage("lastIndent", (Object)(indent + this.style.getContinuationIndent()));
                    j = (J)this.visitAndCast((Tree)right.getElem(), p);
                    after = this.visitSpace(right.getAfter(), p);
                    break;
                }
                default: {
                    j = (J)this.visitAndCast((Tree)right.getElem(), p);
                    after = right.getAfter();
                }
            }
        }
        this.setCursor(this.getCursor().getParent());
        return after == right.getAfter() && j == right.getElem() ? right : new JRightPadded<J2>((J)j, after, right.getMarkers());
    }

    @Override
    public <J2 extends J> JContainer<J2> visitContainer(JContainer<J2> container, JContainer.Location loc, P p) {
        List js;
        Space before;
        this.setCursor(new Cursor(this.getCursor(), container));
        int indent = Optional.ofNullable((Integer)this.getCursor().peekNearestMessage("lastIndent")).orElse(0);
        if (container.getBefore().getWhitespace().contains("\n")) {
            switch (loc) {
                case TYPE_PARAMETER: 
                case IMPLEMENTS: 
                case THROWS: 
                case NEW_CLASS_ARGS: {
                    before = this.indentTo(container.getBefore(), indent + this.style.getContinuationIndent());
                    this.getCursor().putMessage("indentType", (Object)IndentType.ALIGN);
                    this.getCursor().putMessage("lastIndent", (Object)(indent + this.style.getContinuationIndent()));
                    js = ListUtils.map(container.getElem(), t -> this.visitRightPadded((JRightPadded)t, loc.getElemLocation(), p));
                    break;
                }
                default: {
                    before = this.visitSpace(container.getBefore(), p);
                    js = ListUtils.map(container.getElem(), t -> this.visitRightPadded((JRightPadded)t, loc.getElemLocation(), p));
                    break;
                }
            }
        } else {
            switch (loc) {
                case TYPE_PARAMETER: 
                case IMPLEMENTS: 
                case THROWS: 
                case NEW_CLASS_ARGS: 
                case METHOD_INVOCATION_ARGUMENT: {
                    this.getCursor().putMessage("indentType", (Object)IndentType.CONTINUATION_INDENT);
                    before = this.visitSpace(container.getBefore(), p);
                    js = ListUtils.map(container.getElem(), t -> this.visitRightPadded((JRightPadded)t, loc.getElemLocation(), p));
                    break;
                }
                default: {
                    before = this.visitSpace(container.getBefore(), p);
                    js = ListUtils.map(container.getElem(), t -> this.visitRightPadded((JRightPadded)t, loc.getElemLocation(), p));
                }
            }
        }
        this.setCursor(this.getCursor().getParent());
        return js == container.getElem() && before == container.getBefore() ? container : JContainer.build(before, js, container.getMarkers());
    }

    private Space indentTo(Space space, int column) {
        if (!space.getWhitespace().contains("\n")) {
            return space;
        }
        int indent = this.findIndent(space);
        if (!space.getComments().isEmpty()) {
            indent = this.findIndent(Space.format(space.getComments().get(space.getComments().size() - 1).getSuffix()));
        }
        if (indent != column) {
            int shift = column - indent;
            space = space.withComments(ListUtils.map(space.getComments(), c -> this.indentComment((Comment)c, shift)));
            space = space.withWhitespace(this.indent(space.getWhitespace(), shift));
        }
        return space;
    }

    private Comment indentComment(Comment comment, int shift) {
        StringBuilder newSuffix = new StringBuilder(comment.getSuffix());
        this.shift(newSuffix, shift);
        String newText = comment.getText();
        if (comment.getStyle() != Comment.Style.LINE) {
            StringBuilder newTextBuilder = new StringBuilder();
            for (char c : comment.getText().toCharArray()) {
                newTextBuilder.append(c);
                if (c != '\n') continue;
                this.shift(newTextBuilder, shift);
            }
            newText = newTextBuilder.toString();
        }
        return comment.withText(newText).withSuffix(newSuffix.toString());
    }

    private String indent(String whitespace, int shift) {
        StringBuilder newWhitespace = new StringBuilder(whitespace);
        this.shift(newWhitespace, shift);
        return newWhitespace.toString();
    }

    private void shift(StringBuilder text, int shift) {
        int tabIndent = this.style.getTabSize();
        if (!this.style.isUseTabCharacter()) {
            tabIndent = Integer.MAX_VALUE;
        }
        if (shift > 0) {
            int i;
            for (i = 0; i < shift / tabIndent; ++i) {
                text.append('\t');
            }
            for (i = 0; i < shift % tabIndent; ++i) {
                text.append(' ');
            }
        } else if (this.style.isUseTabCharacter()) {
            text.delete(text.length() + shift / tabIndent, text.length());
        } else {
            text.delete(text.length() + shift, text.length());
        }
    }

    private int findIndent(Space space) {
        String indent = space.getIndent();
        int size = 0;
        for (char c : indent.toCharArray()) {
            size += c == '\t' ? this.style.getTabSize() : 1;
            if (c != '\n' && c != '\r') continue;
            size = 0;
        }
        return size;
    }

    private int forInitColumn() {
        Cursor forCursor = this.getCursor().dropParentUntil(J.ForLoop.class::isInstance);
        J.ForLoop forLoop = (J.ForLoop)forCursor.getValue();
        Object parent = forCursor.getParentOrThrow().getValue();
        J.ForLoop alignTo = parent instanceof J.Label ? ((J.Label)parent).withStatement(forLoop.withBody(null)) : forLoop.withBody(null);
        int column = 0;
        boolean afterInitStart = false;
        for (char c : alignTo.print().toCharArray()) {
            if (c == '(') {
                afterInitStart = true;
            } else if (afterInitStart && !Character.isWhitespace(c)) {
                return column - 1;
            }
            ++column;
        }
        throw new IllegalStateException("For loops must have a control section");
    }

    private static enum IndentType {
        ALIGN,
        INDENT,
        CONTINUATION_INDENT;

    }
}

