/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.style.SpacesStyle;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;

public class SpacesVisitor<P>
extends JavaIsoVisitor<P> {
    private final SpacesStyle style;

    public SpacesVisitor(SpacesStyle style) {
        this.style = style;
        this.setCursoringOn();
    }

    <T extends J> T spaceBefore(T j, boolean spaceBefore) {
        if (spaceBefore && StringUtils.isNullOrEmpty((String)j.getPrefix().getWhitespace())) {
            return (T)j.withPrefix(j.getPrefix().withWhitespace(" "));
        }
        if (!spaceBefore && j.getPrefix().getWhitespace().equals(" ")) {
            return (T)j.withPrefix(j.getPrefix().withWhitespace(""));
        }
        return j;
    }

    <T> JContainer<T> spaceBefore(JContainer<T> container, boolean spaceBefore) {
        if (spaceBefore && StringUtils.isNullOrEmpty((String)container.getBefore().getWhitespace())) {
            return container.withBefore(container.getBefore().withWhitespace(" "));
        }
        if (!spaceBefore && container.getBefore().getWhitespace().equals(" ")) {
            return container.withBefore(container.getBefore().withWhitespace(""));
        }
        return container;
    }

    <T extends J> JLeftPadded<T> spaceBefore(JLeftPadded<T> container, boolean spaceBefore) {
        if (spaceBefore && StringUtils.isNullOrEmpty((String)container.getBefore().getWhitespace())) {
            return container.withBefore(container.getBefore().withWhitespace(" "));
        }
        if (!spaceBefore && container.getBefore().getWhitespace().equals(" ")) {
            return container.withBefore(container.getBefore().withWhitespace(""));
        }
        return container;
    }

    <T extends J> JLeftPadded<T> spaceBeforeLeftPaddedElement(JLeftPadded<T> container, boolean spaceBefore) {
        return container.withElem(this.spaceBefore((J)container.getElem(), spaceBefore));
    }

    <T extends J> JRightPadded<T> spaceBeforeRightPaddedElement(JRightPadded<T> container, boolean spaceBefore) {
        return container.withElem(this.spaceBefore((J)container.getElem(), spaceBefore));
    }

    @Override
    public J.ClassDecl visitClassDecl(J.ClassDecl classDecl, P p) {
        J classDecl1 = super.visitClassDecl(classDecl, (Object)p);
        classDecl1 = ((J.ClassDecl)classDecl1).withBody(this.spaceBefore(((J.ClassDecl)classDecl1).getBody(), this.style.getBeforeLeftBrace().isClassLeftBrace()));
        boolean withinCodeBraces = this.style.getWithin().isCodeBraces();
        if (withinCodeBraces && StringUtils.isNullOrEmpty((String)((J.ClassDecl)classDecl1).getBody().getEnd().getWhitespace())) {
            classDecl1 = ((J.ClassDecl)classDecl1).withBody(((J.ClassDecl)classDecl1).getBody().withEnd(((J.ClassDecl)classDecl1).getBody().getEnd().withWhitespace(" ")));
        } else if (!withinCodeBraces && ((J.ClassDecl)classDecl1).getBody().getEnd().getWhitespace().equals(" ")) {
            classDecl1 = ((J.ClassDecl)classDecl1).withBody(((J.ClassDecl)classDecl1).getBody().withEnd(((J.ClassDecl)classDecl1).getBody().getEnd().withWhitespace("")));
        }
        return classDecl1;
    }

    @Override
    public J.MethodDecl visitMethod(J.MethodDecl method, P p) {
        J methodDecl = super.visitMethod(method, (Object)p);
        if (((J.MethodDecl)(methodDecl = ((J.MethodDecl)methodDecl).withParams(this.spaceBefore(((J.MethodDecl)methodDecl).getParams(), this.style.getBeforeParentheses().isMethodDeclaration())))).getBody() != null) {
            methodDecl = ((J.MethodDecl)methodDecl).withBody(this.spaceBefore(((J.MethodDecl)methodDecl).getBody(), this.style.getBeforeLeftBrace().isMethodLeftBrace()));
        }
        return methodDecl;
    }

    @Override
    public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, P p) {
        J methodInvocation = super.visitMethodInvocation(method, (Object)p);
        return ((J.MethodInvocation)methodInvocation).withArgs(this.spaceBefore(((J.MethodInvocation)methodInvocation).getArgs(), this.style.getBeforeParentheses().isMethodCall()));
    }

    @Override
    public J.If visitIf(J.If iff, P p) {
        J anIf = super.visitIf(iff, (Object)p);
        anIf = ((J.If)anIf).withIfCondition(this.spaceBefore(((J.If)anIf).getIfCondition(), this.style.getBeforeParentheses().isIfParentheses()));
        anIf = ((J.If)anIf).withThenPart(this.spaceBeforeRightPaddedElement(((J.If)anIf).getThenPart(), this.style.getBeforeLeftBrace().isIfLeftBrace()));
        return anIf;
    }

    @Override
    public J.If.Else visitElse(J.If.Else elze, P p) {
        J anElse = super.visitElse(elze, (Object)p);
        anElse = ((J.If.Else)anElse).withBody(this.spaceBeforeRightPaddedElement(((J.If.Else)anElse).getBody(), this.style.getBeforeLeftBrace().isElseLeftBrace()));
        anElse = (J.If.Else)this.spaceBefore(anElse, this.style.getBeforeKeywords().isElseKeyword());
        return anElse;
    }

    @Override
    public J.ForLoop visitForLoop(J.ForLoop forLoop, P p) {
        J fl = super.visitForLoop(forLoop, (Object)p);
        fl = ((J.ForLoop)fl).withControl(this.spaceBefore(((J.ForLoop)fl).getControl(), this.style.getBeforeParentheses().isForParentheses()));
        fl = ((J.ForLoop)fl).withBody(this.spaceBeforeRightPaddedElement(((J.ForLoop)fl).getBody(), this.style.getBeforeLeftBrace().isForLeftBrace()));
        return fl;
    }

    @Override
    public J.ForEachLoop visitForEachLoop(J.ForEachLoop forLoop, P p) {
        J forEachLoop = super.visitForEachLoop(forLoop, (Object)p);
        forEachLoop = ((J.ForEachLoop)forEachLoop).withControl(this.spaceBefore(((J.ForEachLoop)forEachLoop).getControl(), this.style.getBeforeParentheses().isForParentheses()));
        forEachLoop = ((J.ForEachLoop)forEachLoop).withBody(this.spaceBeforeRightPaddedElement(((J.ForEachLoop)forEachLoop).getBody(), this.style.getBeforeLeftBrace().isForLeftBrace()));
        return forEachLoop;
    }

    @Override
    public J.WhileLoop visitWhileLoop(J.WhileLoop whileLoop, P p) {
        J wl = super.visitWhileLoop(whileLoop, (Object)p);
        wl = ((J.WhileLoop)wl).withCondition(this.spaceBefore(((J.WhileLoop)wl).getCondition(), this.style.getBeforeParentheses().isWhileParentheses()));
        wl = ((J.WhileLoop)wl).withBody(this.spaceBeforeRightPaddedElement(((J.WhileLoop)wl).getBody(), this.style.getBeforeLeftBrace().isWhileLeftBrace()));
        return wl;
    }

    @Override
    public J.DoWhileLoop visitDoWhileLoop(J.DoWhileLoop doWhileLoop, P p) {
        J dwl = super.visitDoWhileLoop(doWhileLoop, (Object)p);
        dwl = ((J.DoWhileLoop)dwl).withWhileCondition(this.spaceBefore(((J.DoWhileLoop)dwl).getWhileCondition(), this.style.getBeforeKeywords().isWhileKeyword()));
        dwl = ((J.DoWhileLoop)dwl).withWhileCondition(this.spaceBeforeLeftPaddedElement(((J.DoWhileLoop)dwl).getWhileCondition(), this.style.getBeforeParentheses().isWhileParentheses()));
        dwl = ((J.DoWhileLoop)dwl).withBody(this.spaceBeforeRightPaddedElement(((J.DoWhileLoop)dwl).getBody(), this.style.getBeforeLeftBrace().isDoLeftBrace()));
        return dwl;
    }

    @Override
    public J.Switch visitSwitch(J.Switch _switch, P p) {
        J aSwitch = super.visitSwitch(_switch, (Object)p);
        aSwitch = ((J.Switch)aSwitch).withSelector(this.spaceBefore(((J.Switch)aSwitch).getSelector(), this.style.getBeforeParentheses().isSwitchParentheses()));
        aSwitch = ((J.Switch)aSwitch).withCases(this.spaceBefore(((J.Switch)aSwitch).getCases(), this.style.getBeforeLeftBrace().isSwitchLeftBrace()));
        return aSwitch;
    }

    @Override
    public J.Try visitTry(J.Try _try, P p) {
        J aTry = super.visitTry(_try, (Object)p);
        if (((J.Try)aTry).getResources() != null) {
            aTry = ((J.Try)aTry).withResources(this.spaceBefore(((J.Try)aTry).getResources(), this.style.getBeforeParentheses().isTryParentheses()));
        }
        if (((J.Try)(aTry = ((J.Try)aTry).withBody(this.spaceBefore(((J.Try)aTry).getBody(), this.style.getBeforeLeftBrace().isTryLeftBrace())))).getFinally() != null) {
            JLeftPadded<J.Block> finally1 = this.spaceBefore(((J.Try)aTry).getFinally(), this.style.getBeforeKeywords().isFinallyKeyword());
            finally1 = this.spaceBeforeLeftPaddedElement(finally1, this.style.getBeforeLeftBrace().isFinallyLeftBrace());
            aTry = ((J.Try)aTry).withFinally(finally1);
        }
        return aTry;
    }

    @Override
    public J.Try.Catch visitCatch(J.Try.Catch _catch, P p) {
        J aCatch = super.visitCatch(_catch, (Object)p);
        aCatch = (J.Try.Catch)this.spaceBefore(aCatch, this.style.getBeforeKeywords().isCatchKeyword());
        aCatch = ((J.Try.Catch)aCatch).withParam(this.spaceBefore(((J.Try.Catch)aCatch).getParam(), this.style.getBeforeParentheses().isCatchParentheses()));
        aCatch = ((J.Try.Catch)aCatch).withBody(this.spaceBefore(((J.Try.Catch)aCatch).getBody(), this.style.getBeforeLeftBrace().isCatchLeftBrace()));
        return aCatch;
    }

    @Override
    public J.Synchronized visitSynchronized(J.Synchronized _sync, P p) {
        J aSynchronized = super.visitSynchronized(_sync, (Object)p);
        aSynchronized = ((J.Synchronized)aSynchronized).withLock(this.spaceBefore(((J.Synchronized)aSynchronized).getLock(), this.style.getBeforeParentheses().isSynchronizedParentheses()));
        aSynchronized = ((J.Synchronized)aSynchronized).withBody(this.spaceBefore(((J.Synchronized)aSynchronized).getBody(), this.style.getBeforeLeftBrace().isSynchronizedLeftBrace()));
        return aSynchronized;
    }

    @Override
    public J.Annotation visitAnnotation(J.Annotation annotation, P p) {
        J anno = super.visitAnnotation(annotation, (Object)p);
        if (((J.Annotation)anno).getArgs() != null) {
            anno = ((J.Annotation)anno).withArgs(this.spaceBefore(((J.Annotation)anno).getArgs(), this.style.getBeforeParentheses().isAnnotationParameters()));
        }
        return anno;
    }

    @Override
    public J.Assign visitAssign(J.Assign assign, P p) {
        J assign1 = super.visitAssign(assign, (Object)p);
        assign1 = ((J.Assign)assign1).withAssignment(this.spaceBefore(((J.Assign)assign1).getAssignment(), this.style.getAroundOperators().isAssignment()));
        assign1 = ((J.Assign)assign1).withAssignment(((J.Assign)assign1).getAssignment().withElem(this.spaceBefore(((J.Assign)assign1).getAssignment().getElem(), this.style.getAroundOperators().isAssignment())));
        return assign1;
    }

    @Override
    public J.AssignOp visitAssignOp(J.AssignOp assignOp, P p) {
        J assignOp1 = super.visitAssignOp(assignOp, (Object)p);
        String operatorBeforeWhitespace = ((J.AssignOp)assignOp1).getOperator().getBefore().getWhitespace();
        if (this.style.getAroundOperators().isAssignment() && StringUtils.isNullOrEmpty((String)operatorBeforeWhitespace)) {
            assignOp1 = ((J.AssignOp)assignOp1).withOperator(((J.AssignOp)assignOp1).getOperator().withBefore(((J.AssignOp)assignOp1).getOperator().getBefore().withWhitespace(" ")));
        } else if (!this.style.getAroundOperators().isAssignment() && operatorBeforeWhitespace.equals(" ")) {
            assignOp1 = ((J.AssignOp)assignOp1).withOperator(((J.AssignOp)assignOp1).getOperator().withBefore(((J.AssignOp)assignOp1).getOperator().getBefore().withWhitespace("")));
        }
        assignOp1 = ((J.AssignOp)assignOp1).withAssignment(this.spaceBefore(((J.AssignOp)assignOp1).getAssignment(), this.style.getAroundOperators().isAssignment()));
        return assignOp1;
    }

    @Override
    public J.VariableDecls.NamedVar visitVariable(J.VariableDecls.NamedVar variable, P p) {
        J namedVar = super.visitVariable(variable, (Object)p);
        if (((J.VariableDecls.NamedVar)namedVar).getInitializer() != null) {
            namedVar = ((J.VariableDecls.NamedVar)namedVar).withInitializer(this.spaceBefore(((J.VariableDecls.NamedVar)namedVar).getInitializer(), this.style.getAroundOperators().isAssignment()));
        }
        if (((J.VariableDecls.NamedVar)namedVar).getInitializer() != null && ((J.VariableDecls.NamedVar)namedVar).getInitializer().getElem() != null) {
            namedVar = ((J.VariableDecls.NamedVar)namedVar).withInitializer(((J.VariableDecls.NamedVar)namedVar).getInitializer().withElem(this.spaceBefore(((J.VariableDecls.NamedVar)namedVar).getInitializer().getElem(), this.style.getAroundOperators().isAssignment())));
        }
        return namedVar;
    }

    @Override
    public J.Binary visitBinary(J.Binary binary, P p) {
        J binary1 = super.visitBinary(binary, (Object)p);
        J.Binary.Type operator = ((J.Binary)binary1).getOperator().getElem();
        switch (operator) {
            case And: 
            case Or: {
                binary1 = this.applyBinarySpaceAround((J.Binary)binary1, this.style.getAroundOperators().isLogical());
                break;
            }
            case Equal: 
            case NotEqual: {
                binary1 = this.applyBinarySpaceAround((J.Binary)binary1, this.style.getAroundOperators().isEquality());
                break;
            }
            case LessThan: 
            case LessThanOrEqual: 
            case GreaterThan: 
            case GreaterThanOrEqual: {
                binary1 = this.applyBinarySpaceAround((J.Binary)binary1, this.style.getAroundOperators().isRelational());
            }
            case BitAnd: 
            case BitOr: 
            case BitXor: {
                binary1 = this.applyBinarySpaceAround((J.Binary)binary1, this.style.getAroundOperators().isBitwise());
            }
            case Addition: 
            case Subtraction: {
                binary1 = this.applyBinarySpaceAround((J.Binary)binary1, this.style.getAroundOperators().isAdditive());
            }
            case Multiplication: 
            case Division: 
            case Modulo: {
                binary1 = this.applyBinarySpaceAround((J.Binary)binary1, this.style.getAroundOperators().isMultiplicative());
            }
            case LeftShift: 
            case RightShift: 
            case UnsignedRightShift: {
                binary1 = this.applyBinarySpaceAround((J.Binary)binary1, this.style.getAroundOperators().isShift());
            }
        }
        return binary1;
    }

    private J.Binary applyBinarySpaceAround(J.Binary binary, boolean useSpaceAround) {
        if (useSpaceAround) {
            if (StringUtils.isNullOrEmpty((String)binary.getOperator().getBefore().getWhitespace())) {
                binary = binary.withOperator(binary.getOperator().withBefore(binary.getOperator().getBefore().withWhitespace(" ")));
            }
            if (StringUtils.isNullOrEmpty((String)binary.getRight().getPrefix().getWhitespace())) {
                binary = binary.withRight((Expression)binary.getRight().withPrefix(binary.getRight().getPrefix().withWhitespace(" ")));
            }
        } else {
            if (binary.getOperator().getBefore().getWhitespace().equals(" ")) {
                binary = binary.withOperator(binary.getOperator().withBefore(binary.getOperator().getBefore().withWhitespace("")));
            }
            if (binary.getRight().getPrefix().getWhitespace().equals(" ")) {
                binary = binary.withRight((Expression)binary.getRight().withPrefix(binary.getRight().getPrefix().withWhitespace("")));
            }
        }
        return binary;
    }

    @Override
    public J.Unary visitUnary(J.Unary unary, P p) {
        J unary1 = super.visitUnary(unary, (Object)p);
        switch (((J.Unary)unary1).getOperator().getElem()) {
            case PostIncrement: 
            case PostDecrement: {
                unary1 = this.applyUnaryOperatorBeforeSpace((J.Unary)unary1, this.style.getAroundOperators().isUnary());
                break;
            }
            case PreIncrement: 
            case PreDecrement: 
            case Negative: 
            case Positive: 
            case Not: 
            case Complement: {
                unary1 = this.applyUnaryOperatorBeforeSpace((J.Unary)unary1, this.style.getAroundOperators().isUnary());
                unary1 = this.applyUnaryOperatorExprSpace((J.Unary)unary1, this.style.getAroundOperators().isUnary());
            }
        }
        return unary1;
    }

    private J.Unary applyUnaryOperatorExprSpace(J.Unary unary, boolean useAroundUnaryOperatorSpace) {
        if (useAroundUnaryOperatorSpace && StringUtils.isNullOrEmpty((String)unary.getExpr().getPrefix().getWhitespace())) {
            unary = unary.withExpr((Expression)unary.getExpr().withPrefix(unary.getExpr().getPrefix().withWhitespace(" ")));
        } else if (!useAroundUnaryOperatorSpace && unary.getExpr().getPrefix().getWhitespace().equals(" ")) {
            unary = unary.withExpr((Expression)unary.getExpr().withPrefix(unary.getExpr().getPrefix().withWhitespace("")));
        }
        return unary;
    }

    private J.Unary applyUnaryOperatorBeforeSpace(J.Unary unary, boolean useAroundUnaryOperatorSpace) {
        if (useAroundUnaryOperatorSpace && StringUtils.isNullOrEmpty((String)unary.getOperator().getBefore().getWhitespace())) {
            unary = unary.withOperator(unary.getOperator().withBefore(unary.getOperator().getBefore().withWhitespace(" ")));
        } else if (!useAroundUnaryOperatorSpace && unary.getOperator().getBefore().getWhitespace().equals(" ")) {
            unary = unary.withOperator(unary.getOperator().withBefore(unary.getOperator().getBefore().withWhitespace("")));
        }
        return unary;
    }

    @Override
    public J.Lambda visitLambda(J.Lambda lambda, P p) {
        J l = super.visitLambda(lambda, (Object)p);
        boolean useSpaceAroundLambdaArrow = this.style.getAroundOperators().isLambdaArrow();
        if (useSpaceAroundLambdaArrow && StringUtils.isNullOrEmpty((String)((J.Lambda)l).getArrow().getWhitespace())) {
            l = ((J.Lambda)l).withArrow(((J.Lambda)l).getArrow().withWhitespace(" "));
        } else if (!useSpaceAroundLambdaArrow && ((J.Lambda)l).getArrow().getWhitespace().equals(" ")) {
            l = ((J.Lambda)l).withArrow(((J.Lambda)l).getArrow().withWhitespace(""));
        }
        l = ((J.Lambda)l).withBody(this.spaceBefore(((J.Lambda)l).getBody(), this.style.getAroundOperators().isLambdaArrow()));
        return l;
    }

    @Override
    public J.MemberReference visitMemberReference(J.MemberReference memberRef, P p) {
        J memberReference = super.visitMemberReference(memberRef, (Object)p);
        memberReference = ((J.MemberReference)memberReference).withReference(this.spaceBefore(((J.MemberReference)memberReference).getReference(), this.style.getAroundOperators().isMethodReferenceDoubleColon()));
        memberReference = ((J.MemberReference)memberReference).withReference(((J.MemberReference)memberReference).getReference().withElem(this.spaceBefore(((J.MemberReference)memberReference).getReference().getElem(), this.style.getAroundOperators().isMethodReferenceDoubleColon())));
        return memberReference;
    }

    @Override
    public J.NewArray visitNewArray(J.NewArray newArray, P p) {
        JContainer<Expression> initializer;
        J newArray1 = super.visitNewArray(newArray, (Object)p);
        if (this.getCursor().getParent() != null && this.getCursor().getParent().getValue() instanceof J.Annotation) {
            if (((J.NewArray)newArray1).getInitializer() != null) {
                newArray1 = ((J.NewArray)newArray1).withInitializer(this.spaceBefore(((J.NewArray)newArray1).getInitializer(), this.style.getBeforeLeftBrace().isAnnotationArrayInitializerLeftBrace()));
            }
        } else if (((J.NewArray)newArray1).getInitializer() != null) {
            initializer = this.spaceBefore(((J.NewArray)newArray1).getInitializer(), this.style.getBeforeLeftBrace().isArrayInitializerLeftBrace());
            newArray1 = ((J.NewArray)newArray1).withInitializer(initializer);
        }
        if (((J.NewArray)newArray1).getInitializer() != null) {
            initializer = ((J.NewArray)newArray1).getInitializer();
            if (!initializer.getElem().isEmpty()) {
                boolean useSpaceWithinEmptyArrayInitializerBraces;
                boolean useSpaceWithinArrayInitializerBraces = this.style.getWithin().isArrayInitializerBraces();
                if (useSpaceWithinArrayInitializerBraces) {
                    if (!(initializer.getElem().iterator().next().getElem() instanceof J.Empty)) {
                        if (StringUtils.isNullOrEmpty((String)initializer.getElem().iterator().next().getElem().getPrefix().getWhitespace())) {
                            initializer = initializer.withElem(ListUtils.mapFirst(initializer.getElem(), e -> e.withElem((Expression)((Expression)e.getElem()).withPrefix(((Expression)e.getElem()).getPrefix().withWhitespace(" ")))));
                        }
                        if (StringUtils.isNullOrEmpty((String)initializer.getElem().get(initializer.getElem().size() - 1).getAfter().getWhitespace())) {
                            initializer = initializer.withElem(ListUtils.mapLast(initializer.getElem(), e -> e.withAfter(e.getAfter().withWhitespace(" "))));
                        }
                    }
                } else if (!(initializer.getElem().iterator().next().getElem() instanceof J.Empty)) {
                    if (initializer.getElem().iterator().next().getElem().getPrefix().getWhitespace().equals(" ")) {
                        initializer = initializer.withElem(ListUtils.mapFirst(initializer.getElem(), e -> e.withElem((Expression)((Expression)e.getElem()).withPrefix(((Expression)e.getElem()).getPrefix().withWhitespace("")))));
                    }
                    if (initializer.getElem().get(initializer.getElem().size() - 1).getAfter().getWhitespace().equals(" ")) {
                        initializer = initializer.withElem(ListUtils.mapLast(initializer.getElem(), e -> e.withAfter(e.getAfter().withWhitespace(""))));
                    }
                }
                if (useSpaceWithinEmptyArrayInitializerBraces = this.style.getWithin().isEmptyArrayInitializerBraces()) {
                    if (initializer.getElem().iterator().next().getElem() instanceof J.Empty && StringUtils.isNullOrEmpty((String)initializer.getElem().iterator().next().getElem().getPrefix().getWhitespace())) {
                        initializer = initializer.withElem(ListUtils.mapFirst(initializer.getElem(), e -> e.withElem((Expression)((Expression)e.getElem()).withPrefix(((Expression)e.getElem()).getPrefix().withWhitespace(" ")))));
                    }
                } else if (initializer.getElem().iterator().next().getElem() instanceof J.Empty && initializer.getElem().iterator().next().getElem().getPrefix().getWhitespace().equals(" ")) {
                    initializer = initializer.withElem(ListUtils.mapFirst(initializer.getElem(), e -> e.withElem((Expression)((Expression)e.getElem()).withPrefix(((Expression)e.getElem()).getPrefix().withWhitespace("")))));
                }
            }
            newArray1 = ((J.NewArray)newArray1).withInitializer(initializer);
        }
        return newArray1;
    }

    @Override
    public J.ArrayAccess visitArrayAccess(J.ArrayAccess arrayAccess, P p) {
        J arrayAccess1 = super.visitArrayAccess(arrayAccess, (Object)p);
        boolean useSpaceWithinBrackets = this.style.getWithin().isBrackets();
        if (useSpaceWithinBrackets) {
            if (StringUtils.isNullOrEmpty((String)((J.ArrayAccess)arrayAccess1).getDimension().getIndex().getElem().getPrefix().getWhitespace())) {
                arrayAccess1 = ((J.ArrayAccess)arrayAccess1).withDimension(((J.ArrayAccess)arrayAccess1).getDimension().withIndex(((J.ArrayAccess)arrayAccess1).getDimension().getIndex().withElem((Expression)((J.ArrayAccess)arrayAccess1).getDimension().getIndex().getElem().withPrefix(((J.ArrayAccess)arrayAccess1).getDimension().getIndex().getElem().getPrefix().withWhitespace(" ")))));
            }
            if (StringUtils.isNullOrEmpty((String)((J.ArrayAccess)arrayAccess1).getDimension().getIndex().getAfter().getWhitespace())) {
                arrayAccess1 = ((J.ArrayAccess)arrayAccess1).withDimension(((J.ArrayAccess)arrayAccess1).getDimension().withIndex(((J.ArrayAccess)arrayAccess1).getDimension().getIndex().withAfter(((J.ArrayAccess)arrayAccess1).getDimension().getIndex().getAfter().withWhitespace(" "))));
            }
        } else {
            if (((J.ArrayAccess)arrayAccess1).getDimension().getIndex().getElem().getPrefix().getWhitespace().equals(" ")) {
                arrayAccess1 = ((J.ArrayAccess)arrayAccess1).withDimension(((J.ArrayAccess)arrayAccess1).getDimension().withIndex(((J.ArrayAccess)arrayAccess1).getDimension().getIndex().withElem((Expression)((J.ArrayAccess)arrayAccess1).getDimension().getIndex().getElem().withPrefix(((J.ArrayAccess)arrayAccess1).getDimension().getIndex().getElem().getPrefix().withWhitespace("")))));
            }
            if (((J.ArrayAccess)arrayAccess1).getDimension().getIndex().getAfter().getWhitespace().equals(" ")) {
                arrayAccess1 = ((J.ArrayAccess)arrayAccess1).withDimension(((J.ArrayAccess)arrayAccess1).getDimension().withIndex(((J.ArrayAccess)arrayAccess1).getDimension().getIndex().withAfter(((J.ArrayAccess)arrayAccess1).getDimension().getIndex().getAfter().withWhitespace(""))));
            }
        }
        return arrayAccess1;
    }

    @Override
    public <T extends J> J.Parentheses<T> visitParentheses(J.Parentheses<T> parens, P p) {
        J.Parentheses par = super.visitParentheses((J.Parentheses)parens, (Object)p);
        if (this.style.getWithin().isGroupingParentheses()) {
            if (StringUtils.isNullOrEmpty((String)((J)par.getTree().getElem()).getPrefix().getWhitespace())) {
                par = par.withTree(par.getTree().withElem(((J)par.getTree().getElem()).withPrefix(((J)par.getTree().getElem()).getPrefix().withWhitespace(" "))));
            }
            if (StringUtils.isNullOrEmpty((String)par.getTree().getAfter().getWhitespace())) {
                par = par.withTree(par.getTree().withAfter(par.getTree().getAfter().withWhitespace(" ")));
            }
        } else {
            if (((J)par.getTree().getElem()).getPrefix().getWhitespace().equals(" ")) {
                par = par.withTree(par.getTree().withElem(((J)par.getTree().getElem()).withPrefix(((J)par.getTree().getElem()).getPrefix().withWhitespace(""))));
            }
            if (par.getTree().getAfter().getWhitespace().equals(" ")) {
                par = par.withTree(par.getTree().withAfter(par.getTree().getAfter().withWhitespace("")));
            }
        }
        return par;
    }
}

