/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AddImport;
import org.openrewrite.java.RemoveImport;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.marker.Markers;

public class JavaVisitor<P>
extends TreeVisitor<J, P> {
    public void maybeAddImport(@Nullable JavaType.FullyQualified clazz) {
        if (clazz != null) {
            this.maybeAddImport(clazz.getFullyQualifiedName());
        }
    }

    public void maybeAddImport(String fullyQualifiedName) {
        AddImport op = new AddImport(fullyQualifiedName, null, true);
        if (!this.getAfterVisit().contains((Object)op)) {
            this.doAfterVisit(op);
        }
    }

    public void maybeAddImport(String fullyQualifiedName, String statik) {
        AddImport op = new AddImport(fullyQualifiedName, statik, true);
        if (!this.getAfterVisit().contains((Object)op)) {
            this.doAfterVisit(op);
        }
    }

    public void maybeRemoveImport(@Nullable JavaType.FullyQualified clazz) {
        if (clazz != null) {
            this.maybeRemoveImport(clazz.getFullyQualifiedName());
        }
    }

    public void maybeRemoveImport(String fullyQualifiedName) {
        RemoveImport op = new RemoveImport(fullyQualifiedName);
        if (!this.getAfterVisit().contains((Object)op)) {
            this.doAfterVisit(op);
        }
    }

    public J visitExpression(Expression expression, P p) {
        return expression;
    }

    public J visitStatement(Statement statement, P p) {
        return statement;
    }

    public Space visitSpace(Space space, P p) {
        return space;
    }

    public <N extends NameTree> N visitTypeName(N nameTree, P p) {
        return nameTree;
    }

    @Nullable
    private <N extends NameTree> JLeftPadded<N> visitTypeName(@Nullable JLeftPadded<N> nameTree, P p) {
        return nameTree == null ? null : nameTree.withElem(this.visitTypeName((NameTree)nameTree.getElem(), p));
    }

    @Nullable
    private <N extends NameTree> JRightPadded<N> visitTypeName(@Nullable JRightPadded<N> nameTree, P p) {
        return nameTree == null ? null : nameTree.withElem(this.visitTypeName((NameTree)nameTree.getElem(), p));
    }

    @Nullable
    private <J2 extends J> JContainer<J2> visitTypeNames(@Nullable JContainer<J2> nameTrees, P p) {
        if (nameTrees == null) {
            return null;
        }
        List js = ListUtils.map(nameTrees.getElem(), t -> t.getElem() instanceof NameTree ? this.visitTypeName((JRightPadded)t, p) : t);
        return js == nameTrees.getElem() ? nameTrees : JContainer.build(nameTrees.getBefore(), js, Markers.EMPTY);
    }

    public J visitAnnotatedType(J.AnnotatedType annotatedType, P p) {
        J.AnnotatedType a = (J.AnnotatedType)this.visitAndCast(annotatedType, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        a = a.withPrefix(this.visitSpace(a.getPrefix(), p));
        a = (J.AnnotatedType)this.visitAndCast(a, p, this::visitExpression);
        a = a.withAnnotations(ListUtils.map(a.getAnnotations(), e -> (J.Annotation)this.visitAndCast((Tree)e, p)));
        a = a.withTypeExpr((TypeTree)this.visitAndCast(a.getTypeExpr(), p));
        return a.withTypeExpr(this.visitTypeName(a.getTypeExpr(), p));
    }

    public J visitAnnotation(J.Annotation annotation, P p) {
        J.Annotation a = (J.Annotation)this.visitAndCast(annotation, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        a = a.withPrefix(this.visitSpace(a.getPrefix(), p));
        if ((a = (J.Annotation)this.visitAndCast(a, p, this::visitExpression)).getArgs() != null) {
            a = a.withArgs(this.visitContainer(a.getArgs(), JContainer.Location.ANNOTATION_ARGUMENT, p));
        }
        a = a.withAnnotationType((NameTree)this.visitAndCast(a.getAnnotationType(), p));
        return a.withAnnotationType(this.visitTypeName(a.getAnnotationType(), p));
    }

    public J visitArrayAccess(J.ArrayAccess arrayAccess, P p) {
        J.ArrayAccess a = (J.ArrayAccess)this.visitAndCast(arrayAccess, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        a = a.withPrefix(this.visitSpace(a.getPrefix(), p));
        a = (J.ArrayAccess)this.visitAndCast(a, p, this::visitExpression);
        a = a.withIndexed((Expression)this.visitAndCast(a.getIndexed(), p));
        a = a.withDimension((J.ArrayDimension)this.visitAndCast(a.getDimension(), p));
        return a;
    }

    public J visitArrayDimension(J.ArrayDimension arrayDimension, P p) {
        J.ArrayDimension a = (J.ArrayDimension)this.visitAndCast(arrayDimension, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        a = a.withPrefix(this.visitSpace(a.getPrefix(), p));
        a = a.withIndex(this.visitRightPadded(a.getIndex(), JRightPadded.Location.ARRAY_INDEX, p));
        return a;
    }

    public J visitArrayType(J.ArrayType arrayType, P p) {
        J.ArrayType a = (J.ArrayType)this.visitAndCast(arrayType, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        a = a.withPrefix(this.visitSpace(a.getPrefix(), p));
        a = (J.ArrayType)this.visitAndCast(a, p, this::visitExpression);
        a.withElementType((TypeTree)this.visitAndCast(a.getElementType(), p));
        return a.withElementType(this.visitTypeName(a.getElementType(), p));
    }

    public J visitAssert(J.Assert azzert, P p) {
        J.Assert a = (J.Assert)this.visitAndCast(azzert, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        a = a.withPrefix(this.visitSpace(a.getPrefix(), p));
        a = (J.Assert)this.visitAndCast(a, p, this::visitStatement);
        return a.withCondition((Expression)this.visitAndCast(a.getCondition(), p));
    }

    public J visitAssign(J.Assign assign, P p) {
        J.Assign a = (J.Assign)this.visitAndCast(assign, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        a = a.withPrefix(this.visitSpace(a.getPrefix(), p));
        a = (J.Assign)this.visitAndCast(a, p, this::visitStatement);
        a = (J.Assign)this.visitAndCast(a, p, this::visitExpression);
        a = a.withVariable((Expression)this.visitAndCast(a.getVariable(), p));
        return a.withAssignment(this.visitLeftPadded(a.getAssignment(), JLeftPadded.Location.ASSIGNMENT, p));
    }

    public J visitAssignOp(J.AssignOp assignOp, P p) {
        J.AssignOp a = (J.AssignOp)this.visitAndCast(assignOp, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        a = a.withPrefix(this.visitSpace(a.getPrefix(), p));
        a = (J.AssignOp)this.visitAndCast(a, p, this::visitStatement);
        a = (J.AssignOp)this.visitAndCast(a, p, this::visitExpression);
        a = a.withVariable((Expression)this.visitAndCast(a.getVariable(), p));
        return a.withAssignment((Expression)this.visitAndCast(a.getAssignment(), p));
    }

    public J visitBinary(J.Binary binary, P p) {
        J.Binary b = (J.Binary)this.visitAndCast(binary, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        b = b.withPrefix(this.visitSpace(b.getPrefix(), p));
        b = (J.Binary)this.visitAndCast(b, p, this::visitExpression);
        b = b.withLeft((Expression)this.visitAndCast(b.getLeft(), p));
        b = b.withOperator(this.visitLeftPadded(b.getOperator(), JLeftPadded.Location.BINARY_OPERATOR, p));
        return b.withRight((Expression)this.visitAndCast(b.getRight(), p));
    }

    public J visitBlock(J.Block block, P p) {
        J.Block b;
        b = b.withStatik((b = (J.Block)this.visitAndCast(block, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1))).getStatic() == null ? null : this.visitSpace(b.getStatic(), p));
        b = b.withPrefix(this.visitSpace(b.getPrefix(), p));
        b = (J.Block)this.visitAndCast(b, p, this::visitStatement);
        b = b.withStatements(ListUtils.map(b.getStatements(), t -> this.visitRightPadded((JRightPadded)t, JRightPadded.Location.BLOCK_STATEMENT, p)));
        return b.withEnd(this.visitSpace(b.getEnd(), p));
    }

    public J visitBreak(J.Break breakStatement, P p) {
        J.Break b = (J.Break)this.visitAndCast(breakStatement, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        b = b.withPrefix(this.visitSpace(b.getPrefix(), p));
        b = (J.Break)this.visitAndCast(b, p, this::visitStatement);
        return b.withLabel((J.Ident)this.visitAndCast(b.getLabel(), p));
    }

    public J visitCase(J.Case caze, P p) {
        J.Case c = (J.Case)this.visitAndCast(caze, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        c = c.withPrefix(this.visitSpace(c.getPrefix(), p));
        c = (J.Case)this.visitAndCast(c, p, this::visitStatement);
        c = c.withPattern((Expression)this.visitAndCast(c.getPattern(), p));
        return c.withStatements(this.visitContainer(c.getStatements(), JContainer.Location.CASE, p));
    }

    public J visitCatch(J.Try.Catch catzh, P p) {
        J.Try.Catch c = (J.Try.Catch)this.visitAndCast(catzh, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        c = c.withPrefix(this.visitSpace(c.getPrefix(), p));
        c = c.withParam((J.ControlParentheses)this.visitAndCast(c.getParam(), p));
        return c.withBody((J.Block)this.visitAndCast(c.getBody(), p));
    }

    public J visitClassDecl(J.ClassDecl classDecl, P p) {
        J.ClassDecl c = (J.ClassDecl)this.visitAndCast(classDecl, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        c = c.withPrefix(this.visitSpace(c.getPrefix(), p));
        c = (J.ClassDecl)this.visitAndCast(c, p, this::visitStatement);
        c = c.withAnnotations(ListUtils.map(c.getAnnotations(), a -> (J.Annotation)this.visitAndCast((Tree)a, p)));
        c = c.withModifiers(ListUtils.map(c.getModifiers(), m -> (J.Modifier)this.visitAndCast((Tree)m, p)));
        if ((c = c.withModifiers(ListUtils.map(c.getModifiers(), mod -> mod.withPrefix(this.visitSpace(mod.getPrefix(), p))))).getTypeParameters() != null) {
            c = c.withTypeParameters(this.visitContainer(c.getTypeParameters(), JContainer.Location.TYPE_PARAMETER, p));
        }
        c = c.withKind(this.visitLeftPadded(c.getKind(), JLeftPadded.Location.CLASS_KIND, p));
        if ((c = c.withName((J.Ident)this.visitAndCast(c.getName(), p))).getExtends() != null) {
            c = c.withExtends(this.visitLeftPadded(c.getExtends(), JLeftPadded.Location.EXTENDS, p));
        }
        if ((c = c.withExtends(this.visitTypeName(c.getExtends(), p))).getImplements() != null) {
            c = c.withImplements(this.visitContainer(c.getImplements(), JContainer.Location.IMPLEMENTS, p));
        }
        c = c.withImplements(this.visitTypeNames(c.getImplements(), p));
        return c.withBody((J.Block)this.visitAndCast(c.getBody(), p));
    }

    public J visitCompilationUnit(J.CompilationUnit cu, P p) {
        J.CompilationUnit c = (J.CompilationUnit)this.visitAndCast(cu, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        if ((c = c.withPrefix(this.visitSpace(c.getPrefix(), p))).getPackageDecl() != null) {
            c = c.withPackageDecl(this.visitRightPadded(c.getPackageDecl(), JRightPadded.Location.PACKAGE, p));
        }
        c = c.withImports(ListUtils.map(c.getImports(), t -> this.visitRightPadded((JRightPadded)t, JRightPadded.Location.IMPORT, p)));
        c = c.withClasses(ListUtils.map(c.getClasses(), e -> (J.ClassDecl)this.visitAndCast((Tree)e, p)));
        return c.withEof(this.visitSpace(c.getEof(), p));
    }

    public J visitContinue(J.Continue continueStatement, P p) {
        J.Continue c = (J.Continue)this.visitAndCast(continueStatement, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        c = c.withPrefix(this.visitSpace(c.getPrefix(), p));
        c = (J.Continue)this.visitAndCast(c, p, this::visitStatement);
        return c.withLabel((J.Ident)this.visitAndCast(c.getLabel(), p));
    }

    public <T extends J> J visitControlParentheses(J.ControlParentheses<T> controlParens, P p) {
        J cpa = (J.ControlParentheses)this.visitAndCast(controlParens, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        cpa = ((J.ControlParentheses)cpa).withPrefix(this.visitSpace(((J.ControlParentheses)cpa).getPrefix(), p));
        cpa = (J.ControlParentheses)this.visitAndCast(cpa, p, this::visitExpression);
        return ((J.ControlParentheses)cpa).withTree(this.visitRightPadded(((J.ControlParentheses)cpa).getTree(), JRightPadded.Location.PARENTHESES, p));
    }

    public J visitDoWhileLoop(J.DoWhileLoop doWhileLoop, P p) {
        J.DoWhileLoop d = (J.DoWhileLoop)this.visitAndCast(doWhileLoop, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        d = d.withPrefix(this.visitSpace(d.getPrefix(), p));
        d = (J.DoWhileLoop)this.visitAndCast(d, p, this::visitStatement);
        d = d.withWhileCondition(this.visitLeftPadded(d.getWhileCondition(), JLeftPadded.Location.WHILE_CONDITION, p));
        return d.withBody(this.visitRightPadded(d.getBody(), JRightPadded.Location.WHILE_BODY, p));
    }

    public J visitEmpty(J.Empty empty, P p) {
        J.Empty e = (J.Empty)this.visitAndCast(empty, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        e = e.withPrefix(this.visitSpace(e.getPrefix(), p));
        e = (J.Empty)this.visitAndCast(e, p, this::visitStatement);
        e = (J.Empty)this.visitAndCast(e, p, this::visitExpression);
        return e;
    }

    public J visitEnumValue(J.EnumValue enoom, P p) {
        J.EnumValue e = (J.EnumValue)this.visitAndCast(enoom, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        e = e.withPrefix(this.visitSpace(e.getPrefix(), p));
        e = e.withName((J.Ident)this.visitAndCast(e.getName(), p));
        return e.withInitializer((J.NewClass)this.visitAndCast(e.getInitializer(), p));
    }

    public J visitEnumValueSet(J.EnumValueSet enums, P p) {
        J.EnumValueSet e = (J.EnumValueSet)this.visitAndCast(enums, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        e = e.withPrefix(this.visitSpace(e.getPrefix(), p));
        e = (J.EnumValueSet)this.visitAndCast(e, p, this::visitStatement);
        return e.withEnums(ListUtils.map(e.getEnums(), t -> this.visitRightPadded((JRightPadded)t, JRightPadded.Location.ENUM_VALUE, p)));
    }

    public J visitFieldAccess(J.FieldAccess fieldAccess, P p) {
        J.FieldAccess f = (J.FieldAccess)this.visitAndCast(fieldAccess, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        f = f.withPrefix(this.visitSpace(f.getPrefix(), p));
        f = this.visitTypeName(f, p);
        f = (J.FieldAccess)this.visitAndCast(f, p, this::visitExpression);
        f = f.withTarget((Expression)this.visitAndCast(f.getTarget(), p));
        return f.withName(this.visitLeftPadded(f.getName(), JLeftPadded.Location.FIELD_ACCESS_NAME, p));
    }

    public J visitForEachLoop(J.ForEachLoop forLoop, P p) {
        J.ForEachLoop f = (J.ForEachLoop)this.visitAndCast(forLoop, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        f = f.withPrefix(this.visitSpace(f.getPrefix(), p));
        f = (J.ForEachLoop)this.visitAndCast(f, p, this::visitStatement);
        f = f.withControl((J.ForEachLoop.Control)this.visitAndCast(f.getControl(), p));
        return f.withBody(this.visitRightPadded(f.getBody(), JRightPadded.Location.FOR_BODY, p));
    }

    public J visitForEachControl(J.ForEachLoop.Control control, P p) {
        J.ForEachLoop.Control c = (J.ForEachLoop.Control)this.visitAndCast(control, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        c = c.withPrefix(this.visitSpace(c.getPrefix(), p));
        c = c.withVariable(this.visitRightPadded(c.getVariable(), JRightPadded.Location.FOREACH_VARIABLE, p));
        return c.withIterable(this.visitRightPadded(c.getIterable(), JRightPadded.Location.FOREACH_ITERABLE, p));
    }

    public J visitForLoop(J.ForLoop forLoop, P p) {
        J.ForLoop f = (J.ForLoop)this.visitAndCast(forLoop, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        f = f.withPrefix(this.visitSpace(f.getPrefix(), p));
        f = (J.ForLoop)this.visitAndCast(f, p, this::visitStatement);
        f = f.withControl((J.ForLoop.Control)this.visitAndCast(f.getControl(), p));
        return f.withBody(this.visitRightPadded(f.getBody(), JRightPadded.Location.FOR_BODY, p));
    }

    public J visitForControl(J.ForLoop.Control control, P p) {
        J.ForLoop.Control c = (J.ForLoop.Control)this.visitAndCast(control, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        c = c.withPrefix(this.visitSpace(c.getPrefix(), p));
        c = c.withInit(this.visitRightPadded(c.getInit(), JRightPadded.Location.FOR_INIT, p));
        c = c.withCondition(this.visitRightPadded(c.getCondition(), JRightPadded.Location.FOR_CONDITION, p));
        return c.withUpdate(ListUtils.map(c.getUpdate(), t -> this.visitRightPadded((JRightPadded)t, JRightPadded.Location.FOR_UPDATE, p)));
    }

    public J visitIdentifier(J.Ident ident, P p) {
        J.Ident i = (J.Ident)this.visitAndCast(ident, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        i = i.withPrefix(this.visitSpace(i.getPrefix(), p));
        return (J)this.visitAndCast(i, p, this::visitExpression);
    }

    public J visitElse(J.If.Else elze, P p) {
        J.If.Else e = (J.If.Else)this.visitAndCast(elze, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        e = e.withPrefix(this.visitSpace(e.getPrefix(), p));
        return e.withBody(this.visitRightPadded(e.getBody(), JRightPadded.Location.IF_ELSE, p));
    }

    public J visitIf(J.If iff, P p) {
        J.If i = (J.If)this.visitAndCast(iff, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        i = i.withPrefix(this.visitSpace(i.getPrefix(), p));
        i = (J.If)this.visitAndCast(i, p, this::visitStatement);
        i = i.withIfCondition((J.ControlParentheses)this.visitAndCast(i.getIfCondition(), p));
        i = i.withThenPart(this.visitRightPadded(i.getThenPart(), JRightPadded.Location.IF_THEN, p));
        i = i.withElsePart((J.If.Else)this.visitAndCast(i.getElsePart(), p));
        return i;
    }

    public J visitImport(J.Import impoort, P p) {
        J.Import i = (J.Import)this.visitAndCast(impoort, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        i = i.withStatik((i = i.withPrefix(this.visitSpace(i.getPrefix(), p))).getStatic() == null ? null : this.visitSpace(i.getStatic(), p));
        return i.withQualid((J.FieldAccess)this.visitAndCast(i.getQualid(), p));
    }

    public J visitInstanceOf(J.InstanceOf instanceOf, P p) {
        J.InstanceOf i = (J.InstanceOf)this.visitAndCast(instanceOf, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        i = i.withPrefix(this.visitSpace(i.getPrefix(), p));
        i = (J.InstanceOf)this.visitAndCast(i, p, this::visitExpression);
        i = i.withExpr(this.visitRightPadded(i.getExpr(), JRightPadded.Location.INSTANCEOF, p));
        return i.withClazz((J)this.visitAndCast(i.getClazz(), p));
    }

    public J visitLabel(J.Label label, P p) {
        J.Label l = (J.Label)this.visitAndCast(label, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        l = l.withPrefix(this.visitSpace(l.getPrefix(), p));
        l = (J.Label)this.visitAndCast(l, p, this::visitStatement);
        return l.withStatement((Statement)this.visitAndCast(l.getStatement(), p));
    }

    public J visitLambda(J.Lambda lambda, P p) {
        J.Lambda l = (J.Lambda)this.visitAndCast(lambda, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        l = l.withPrefix(this.visitSpace(l.getPrefix(), p));
        l = (J.Lambda)this.visitAndCast(l, p, this::visitExpression);
        l = l.withParameters((J.Lambda.Parameters)this.visitAndCast(l.getParameters(), p));
        l = l.withArrow(this.visitSpace(l.getArrow(), p));
        return l.withBody((J)this.visitAndCast(l.getBody(), p));
    }

    public J visitLiteral(J.Literal literal, P p) {
        J.Literal l = (J.Literal)this.visitAndCast(literal, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        l = l.withPrefix(this.visitSpace(l.getPrefix(), p));
        return (J)this.visitAndCast(l, p, this::visitExpression);
    }

    public J visitMemberReference(J.MemberReference memberRef, P p) {
        J.MemberReference m = (J.MemberReference)this.visitAndCast(memberRef, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        m = m.withPrefix(this.visitSpace(m.getPrefix(), p));
        if ((m = m.withContaining((Expression)this.visitAndCast(m.getContaining(), p))).getTypeParameters() != null) {
            m = m.withTypeParameters(this.visitContainer(m.getTypeParameters(), JContainer.Location.TYPE_PARAMETER, p));
        }
        return m.withReference(this.visitLeftPadded(m.getReference(), JLeftPadded.Location.MEMBER_REFERENCE, p));
    }

    public J visitMethod(J.MethodDecl method, P p) {
        J.MethodDecl m = (J.MethodDecl)this.visitAndCast(method, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        m = m.withPrefix(this.visitSpace(m.getPrefix(), p));
        m = (J.MethodDecl)this.visitAndCast(m, p, this::visitStatement);
        m = m.withAnnotations(ListUtils.map(m.getAnnotations(), a -> (J.Annotation)this.visitAndCast((Tree)a, p)));
        m = m.withModifiers(ListUtils.map(m.getModifiers(), e -> (J.Modifier)this.visitAndCast((Tree)e, p)));
        if ((m = m.withModifiers(ListUtils.map(m.getModifiers(), mod -> mod.withPrefix(this.visitSpace(mod.getPrefix(), p))))).getTypeParameters() != null) {
            m = m.withTypeParameters(this.visitContainer(m.getTypeParameters(), JContainer.Location.TYPE_PARAMETER, p));
        }
        m = m.withReturnTypeExpr((m = m.withReturnTypeExpr((TypeTree)this.visitAndCast(m.getReturnTypeExpr(), p))).getReturnTypeExpr() == null ? null : this.visitTypeName(m.getReturnTypeExpr(), p));
        m = m.withName((J.Ident)this.visitAndCast(m.getName(), p));
        if ((m = m.withParams(this.visitContainer(m.getParams(), JContainer.Location.METHOD_DECL_ARGUMENT, p))).getThrows() != null) {
            m = m.withThrows(this.visitContainer(m.getThrows(), JContainer.Location.THROWS, p));
        }
        m = m.withThrows(this.visitTypeNames(m.getThrows(), p));
        return m.withBody((J.Block)this.visitAndCast(m.getBody(), p));
    }

    public J visitMethodInvocation(J.MethodInvocation method, P p) {
        J.MethodInvocation m = (J.MethodInvocation)this.visitAndCast(method, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        m = m.withPrefix(this.visitSpace(m.getPrefix(), p));
        m = (J.MethodInvocation)this.visitAndCast(m, p, this::visitStatement);
        if ((m = (J.MethodInvocation)this.visitAndCast(m, p, this::visitExpression)).getSelect() != null && m.getSelect().getElem() instanceof NameTree && method.getType() != null && method.getType().hasFlags(Flag.Static)) {
            m = m.withSelect(this.visitTypeName(m.getSelect(), p));
        }
        if (m.getSelect() != null) {
            m = m.withSelect(this.visitRightPadded(m.getSelect(), JRightPadded.Location.METHOD_SELECT, p));
        }
        if (m.getTypeParameters() != null) {
            m = m.withTypeParameters(this.visitContainer(m.getTypeParameters(), JContainer.Location.TYPE_PARAMETER, p));
        }
        m = m.withTypeParameters(this.visitTypeNames(m.getTypeParameters(), p));
        m = m.withName((J.Ident)this.visitAndCast(m.getName(), p));
        return m.withArgs(this.visitContainer(m.getArgs(), JContainer.Location.METHOD_INVOCATION_ARGUMENT, p));
    }

    public J visitMultiCatch(J.MultiCatch multiCatch, P p) {
        J.MultiCatch m = (J.MultiCatch)this.visitAndCast(multiCatch, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        m = m.withPrefix(this.visitSpace(m.getPrefix(), p));
        return m.withAlternatives(ListUtils.map(m.getAlternatives(), t -> this.visitTypeName(this.visitRightPadded((JRightPadded)t, JRightPadded.Location.CATCH_ALTERNATIVE, p), p)));
    }

    public J visitMultiVariable(J.VariableDecls multiVariable, P p) {
        J.VariableDecls m = (J.VariableDecls)this.visitAndCast(multiVariable, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        m = m.withPrefix(this.visitSpace(m.getPrefix(), p));
        m = (J.VariableDecls)this.visitAndCast(m, p, this::visitStatement);
        m = m.withAnnotations(ListUtils.map(m.getAnnotations(), a -> (J.Annotation)this.visitAndCast((Tree)a, p)));
        m = m.withModifiers(Objects.requireNonNull(ListUtils.map(m.getModifiers(), e -> (J.Modifier)this.visitAndCast((Tree)e, p))));
        m = m.withModifiers(ListUtils.map(m.getModifiers(), mod -> mod.withPrefix(this.visitSpace(mod.getPrefix(), p))));
        m = m.withTypeExpr((m = m.withTypeExpr((TypeTree)this.visitAndCast(m.getTypeExpr(), p))).getTypeExpr() == null ? null : this.visitTypeName(m.getTypeExpr(), p));
        m = m.withVarargs(m.getVarargs() == null ? null : this.visitSpace(m.getVarargs(), p));
        return m.withVars(ListUtils.map(m.getVars(), t -> this.visitRightPadded((JRightPadded)t, JRightPadded.Location.NAMED_VARIABLE, p)));
    }

    public J visitNewArray(J.NewArray newArray, P p) {
        J.NewArray n = (J.NewArray)this.visitAndCast(newArray, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        n = n.withPrefix(this.visitSpace(n.getPrefix(), p));
        n = (J.NewArray)this.visitAndCast(n, p, this::visitExpression);
        n = n.withTypeExpr((n = n.withTypeExpr((TypeTree)this.visitAndCast(n.getTypeExpr(), p))).getTypeExpr() == null ? null : this.visitTypeName(n.getTypeExpr(), p));
        if ((n = n.withDimensions(ListUtils.map(n.getDimensions(), d -> (J.ArrayDimension)this.visitAndCast((Tree)d, p)))).getInitializer() != null) {
            n = n.withInitializer(this.visitContainer(n.getInitializer(), JContainer.Location.NEW_ARRAY_INITIALIZER, p));
        }
        return n;
    }

    public J visitNewClass(J.NewClass newClass, P p) {
        J.NewClass n = (J.NewClass)this.visitAndCast(newClass, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        n = n.withPrefix(this.visitSpace(n.getPrefix(), p));
        n = (J.NewClass)this.visitAndCast(n, p, this::visitStatement);
        n = (J.NewClass)this.visitAndCast(n, p, this::visitExpression);
        n = n.withNew(this.visitSpace(n.getNew(), p));
        if ((n = n.withClazz((n = n.withClazz((TypeTree)this.visitAndCast(n.getClazz(), p))).getClazz() == null ? null : this.visitTypeName(n.getClazz(), p))).getArgs() != null) {
            n = n.withArgs(this.visitContainer(n.getArgs(), JContainer.Location.NEW_CLASS_ARGS, p));
        }
        return n.withBody((J.Block)this.visitAndCast(n.getBody(), p));
    }

    public J visitPackage(J.Package pkg, P p) {
        J.Package pa = (J.Package)this.visitAndCast(pkg, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        pa = pa.withPrefix(this.visitSpace(pa.getPrefix(), p));
        return pa.withExpr((Expression)this.visitAndCast(pa.getExpr(), p));
    }

    public J visitParameterizedType(J.ParameterizedType type, P p) {
        J.ParameterizedType pt = (J.ParameterizedType)this.visitAndCast(type, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        pt = pt.withPrefix(this.visitSpace(pt.getPrefix(), p));
        pt = (J.ParameterizedType)this.visitAndCast(pt, p, this::visitExpression);
        pt = pt.withClazz((NameTree)this.visitAndCast(pt.getClazz(), p));
        if ((pt = pt.withClazz(this.visitTypeName(pt.getClazz(), p))).getTypeParameters() != null) {
            pt = pt.withTypeParameters(this.visitContainer(pt.getTypeParameters(), JContainer.Location.TYPE_PARAMETER, p));
        }
        return pt.withTypeParameters(this.visitTypeNames(pt.getTypeParameters(), p));
    }

    public <T extends J> J visitParentheses(J.Parentheses<T> parens, P p) {
        J pa = (J.Parentheses)this.visitAndCast(parens, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        pa = ((J.Parentheses)pa).withPrefix(this.visitSpace(((J.Parentheses)pa).getPrefix(), p));
        pa = (J.Parentheses)this.visitAndCast(pa, p, this::visitExpression);
        return ((J.Parentheses)pa).withTree(this.visitRightPadded(((J.Parentheses)pa).getTree(), JRightPadded.Location.PARENTHESES, p));
    }

    public J visitPrimitive(J.Primitive primitive, P p) {
        J.Primitive pr = (J.Primitive)this.visitAndCast(primitive, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        pr = pr.withPrefix(this.visitSpace(pr.getPrefix(), p));
        return (J)this.visitAndCast(pr, p, this::visitExpression);
    }

    public J visitReturn(J.Return retrn, P p) {
        J.Return r = (J.Return)this.visitAndCast(retrn, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        r = r.withPrefix(this.visitSpace(r.getPrefix(), p));
        r = (J.Return)this.visitAndCast(r, p, this::visitStatement);
        return r.withExpr((Expression)this.visitAndCast(r.getExpr(), p));
    }

    public J visitSwitch(J.Switch switzh, P p) {
        J.Switch s = (J.Switch)this.visitAndCast(switzh, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        s = s.withPrefix(this.visitSpace(s.getPrefix(), p));
        s = (J.Switch)this.visitAndCast(s, p, this::visitStatement);
        s = s.withSelector((J.ControlParentheses)this.visitAndCast(s.getSelector(), p));
        return s.withCases((J.Block)this.visitAndCast(s.getCases(), p));
    }

    public J visitSynchronized(J.Synchronized synch, P p) {
        J.Synchronized s = (J.Synchronized)this.visitAndCast(synch, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        s = s.withPrefix(this.visitSpace(s.getPrefix(), p));
        s = (J.Synchronized)this.visitAndCast(s, p, this::visitStatement);
        s = s.withLock((J.ControlParentheses)this.visitAndCast(s.getLock(), p));
        return s.withBody((J.Block)this.visitAndCast(s.getBody(), p));
    }

    public J visitTernary(J.Ternary ternary, P p) {
        J.Ternary t = (J.Ternary)this.visitAndCast(ternary, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        t = t.withPrefix(this.visitSpace(t.getPrefix(), p));
        t = (J.Ternary)this.visitAndCast(t, p, this::visitExpression);
        t = t.withCondition((Expression)this.visitAndCast(t.getCondition(), p));
        t = t.withTruePart(this.visitLeftPadded(t.getTruePart(), JLeftPadded.Location.TERNARY_TRUE, p));
        return t.withFalsePart(this.visitLeftPadded(t.getFalsePart(), JLeftPadded.Location.TERNARY_FALSE, p));
    }

    public J visitThrow(J.Throw thrown, P p) {
        J.Throw t = (J.Throw)this.visitAndCast(thrown, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        t = t.withPrefix(this.visitSpace(t.getPrefix(), p));
        t = (J.Throw)this.visitAndCast(t, p, this::visitStatement);
        return t.withException((Expression)this.visitAndCast(t.getException(), p));
    }

    public J visitTry(J.Try tryable, P p) {
        J.Try t = (J.Try)this.visitAndCast(tryable, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        t = t.withPrefix(this.visitSpace(t.getPrefix(), p));
        if ((t = (J.Try)this.visitAndCast(t, p, this::visitStatement)).getResources() != null) {
            t = t.withResources(this.visitContainer(t.getResources(), JContainer.Location.TRY_RESOURCES, p));
        }
        t = t.withBody((J.Block)this.visitAndCast(t.getBody(), p));
        if ((t = t.withCatches(ListUtils.map(t.getCatches(), c -> (J.Try.Catch)this.visitAndCast((Tree)c, p)))).getFinally() != null) {
            t = t.withFinally(this.visitLeftPadded(t.getFinally(), JLeftPadded.Location.TRY_FINALLY, p));
        }
        return t;
    }

    public J visitTypeCast(J.TypeCast typeCast, P p) {
        J.TypeCast t = (J.TypeCast)this.visitAndCast(typeCast, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        t = t.withPrefix(this.visitSpace(t.getPrefix(), p));
        t = (J.TypeCast)this.visitAndCast(t, p, this::visitExpression);
        t = t.withClazz((J.ControlParentheses)this.visitAndCast(t.getClazz(), p));
        t = t.withClazz(t.getClazz().withTree(this.visitTypeName(t.getClazz().getTree(), p)));
        return t.withExpr((Expression)this.visitAndCast(t.getExpr(), p));
    }

    public J visitTypeParameter(J.TypeParameter typeParam, P p) {
        J.TypeParameter t = (J.TypeParameter)this.visitAndCast(typeParam, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        t = t.withPrefix(this.visitSpace(t.getPrefix(), p));
        t = t.withAnnotations(ListUtils.map(t.getAnnotations(), a -> (J.Annotation)this.visitAndCast((Tree)a, p)));
        if ((t = t.withName((Expression)this.visitAndCast(t.getName(), p))).getName() instanceof NameTree) {
            t = t.withName((Expression)((Object)this.visitTypeName((NameTree)((Object)t.getName()), p)));
        }
        if (t.getBounds() != null) {
            t = t.withBounds(this.visitContainer(t.getBounds(), JContainer.Location.TYPE_BOUND, p));
        }
        return t.withBounds(this.visitTypeNames(t.getBounds(), p));
    }

    public J visitUnary(J.Unary unary, P p) {
        J.Unary u = (J.Unary)this.visitAndCast(unary, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        u = u.withPrefix(this.visitSpace(u.getPrefix(), p));
        u = (J.Unary)this.visitAndCast(u, p, this::visitStatement);
        u = (J.Unary)this.visitAndCast(u, p, this::visitExpression);
        u = u.withOperator(this.visitLeftPadded(u.getOperator(), JLeftPadded.Location.UNARY_OPERATOR, p));
        return u.withExpr((Expression)this.visitAndCast(u.getExpr(), p));
    }

    public J visitVariable(J.VariableDecls.NamedVar variable, P p) {
        J.VariableDecls.NamedVar v = (J.VariableDecls.NamedVar)this.visitAndCast(variable, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        v = v.withPrefix(this.visitSpace(v.getPrefix(), p));
        if ((v = v.withName((J.Ident)this.visitAndCast(v.getName(), p))).getInitializer() != null) {
            v = v.withInitializer(this.visitLeftPadded(v.getInitializer(), JLeftPadded.Location.VARIABLE_INITIALIZER, p));
        }
        return v;
    }

    public J visitWhileLoop(J.WhileLoop whileLoop, P p) {
        J.WhileLoop w = (J.WhileLoop)this.visitAndCast(whileLoop, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        w = w.withPrefix(this.visitSpace(w.getPrefix(), p));
        w = (J.WhileLoop)this.visitAndCast(w, p, this::visitStatement);
        w = w.withCondition((J.ControlParentheses)this.visitAndCast(w.getCondition(), p));
        return w.withBody(this.visitRightPadded(w.getBody(), JRightPadded.Location.WHILE_BODY, p));
    }

    public J visitWildcard(J.Wildcard wildcard, P p) {
        J.Wildcard w = (J.Wildcard)this.visitAndCast(wildcard, p, (arg_0, arg_1) -> ((JavaVisitor)this).visitEach(arg_0, arg_1));
        w = w.withPrefix(this.visitSpace(w.getPrefix(), p));
        w = (J.Wildcard)this.visitAndCast(w, p, this::visitExpression);
        if ((w = w.withBoundedType((NameTree)this.visitAndCast(w.getBoundedType(), p))).getBoundedType() != null) {
            w = w.withBoundedType(this.visitTypeName(w.getBoundedType(), p));
        }
        return w;
    }

    public <J2 extends J> JRightPadded<J2> visitRightPadded(JRightPadded<J2> right, JRightPadded.Location type, P p) {
        if (this.cursored) {
            this.setCursor(new Cursor(this.getCursor(), right));
        }
        J j = (J)this.visitAndCast((Tree)right.getElem(), p);
        Space after = this.visitSpace(right.getAfter(), p);
        if (this.cursored) {
            this.setCursor(this.getCursor().getParent());
        }
        return after == right.getAfter() && j == right.getElem() ? right : new JRightPadded<J2>((J)j, after, right.getMarkers());
    }

    public <T> JLeftPadded<T> visitLeftPadded(JLeftPadded<T> left, JLeftPadded.Location loc, P p) {
        if (this.cursored) {
            this.setCursor(new Cursor(this.getCursor(), left));
        }
        Space before = this.visitSpace(left.getBefore(), p);
        Object t = left.getElem();
        if (t instanceof J) {
            t = this.visitAndCast((J)left.getElem(), p);
        }
        if (this.cursored) {
            this.setCursor(this.getCursor().getParent());
        }
        return before == left.getBefore() && t == left.getElem() ? left : new JLeftPadded<T>(before, t, left.getMarkers());
    }

    public <J2 extends J> JContainer<J2> visitContainer(JContainer<J2> container, JContainer.Location loc, P p) {
        if (this.cursored) {
            this.setCursor(new Cursor(this.getCursor(), container));
        }
        Space before = this.visitSpace(container.getBefore(), p);
        List js = ListUtils.map(container.getElem(), t -> this.visitRightPadded((JRightPadded)t, loc.getElemLocation(), p));
        if (this.cursored) {
            this.setCursor(this.getCursor().getParent());
        }
        return js == container.getElem() && before == container.getBefore() ? container : JContainer.build(before, js, container.getMarkers());
    }

    protected boolean isInSameNameScope(Cursor base, Cursor child) {
        Tree baseScope = (Tree)base.dropParentUntil(t -> t instanceof J.Block || t instanceof J.MethodDecl || t instanceof J.Try || t instanceof J.ForLoop || t instanceof J.ForEachLoop).getValue();
        Iterator it = child.getPath();
        while (it.hasNext()) {
            J.ClassDecl childClass;
            Object childScope = it.next();
            if (childScope instanceof J.ClassDecl && (!(childClass = (J.ClassDecl)childScope).getKind().getElem().equals((Object)J.ClassDecl.Kind.Class) || childClass.hasModifier("static"))) {
                return false;
            }
            if (!(childScope instanceof Tree) || !baseScope.isScope((Tree)childScope)) continue;
            return true;
        }
        return false;
    }

    protected boolean isInSameNameScope(Cursor child) {
        return this.isInSameNameScope(this.getCursor(), child);
    }
}

