/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.Collections;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.FindReferencedTypes;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.marker.Markers;

public class DeleteStatement<P>
extends JavaIsoVisitor<P> {
    private final Statement statement;

    public DeleteStatement(Statement statement) {
        this.statement = statement;
    }

    @Override
    public J.If visitIf(J.If iff, P p) {
        J i = super.visitIf(iff, (Object)p);
        if (this.statement.isScope(((J.If)i).getThenPart().getElem())) {
            i = ((J.If)i).withThenPart(this.emptyBlock());
        } else if (((J.If)i).getElsePart() != null && this.statement.isScope(((J.If)i).getElsePart())) {
            i = ((J.If)i).withElsePart(((J.If)i).getElsePart().withBody(this.emptyBlock()));
        }
        return i;
    }

    @Override
    public J.ForLoop visitForLoop(J.ForLoop forLoop, P p) {
        return this.statement.isScope(forLoop.getBody().getElem()) ? forLoop.withBody(this.emptyBlock()) : super.visitForLoop(forLoop, (Object)p);
    }

    @Override
    public J.ForEachLoop visitForEachLoop(J.ForEachLoop forEachLoop, P p) {
        return this.statement.isScope(forEachLoop.getBody().getElem()) ? forEachLoop.withBody(this.emptyBlock()) : super.visitForEachLoop(forEachLoop, (Object)p);
    }

    @Override
    public J.WhileLoop visitWhileLoop(J.WhileLoop whileLoop, P p) {
        return this.statement.isScope(whileLoop.getBody().getElem()) ? whileLoop.withBody(this.emptyBlock()) : super.visitWhileLoop(whileLoop, (Object)p);
    }

    @Override
    public J.DoWhileLoop visitDoWhileLoop(J.DoWhileLoop doWhileLoop, P p) {
        return this.statement.isScope(doWhileLoop.getBody().getElem()) ? doWhileLoop.withBody(this.emptyBlock()) : super.visitDoWhileLoop(doWhileLoop, (Object)p);
    }

    @Override
    public J.Block visitBlock(J.Block block, P p) {
        J b = super.visitBlock(block, (Object)p);
        return ((J.Block)b).withStatements(ListUtils.map(((J.Block)b).getStatements(), s -> this.statement.isScope((Tree)s.getElem()) ? null : s));
    }

    public J visitEach(J tree, P p) {
        if (this.statement.isScope(tree)) {
            for (JavaType.Class referenced : FindReferencedTypes.find(tree)) {
                this.maybeRemoveImport(referenced);
            }
        }
        return (J)super.visitEach((Tree)tree, p);
    }

    private JRightPadded<Statement> emptyBlock() {
        return new JRightPadded<Statement>(new J.Block(Tree.randomId(), Space.EMPTY, Markers.EMPTY, null, Collections.emptyList(), Space.EMPTY), Space.EMPTY, Markers.EMPTY);
    }
}

