/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.beans.ConstructorProperties;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public class ChangeType
extends Recipe {
    private final String originalType;
    private final String replacementType;

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new ChangeTypeVisitor(this.replacementType);
    }

    @ConstructorProperties(value={"originalType", "replacementType"})
    public ChangeType(String originalType, String replacementType) {
        this.originalType = originalType;
        this.replacementType = replacementType;
    }

    public String getOriginalType() {
        return this.originalType;
    }

    public String getReplacementType() {
        return this.replacementType;
    }

    public String toString() {
        return "ChangeType(originalType=" + this.getOriginalType() + ", replacementType=" + this.getReplacementType() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeType)) {
            return false;
        }
        ChangeType other = (ChangeType)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$originalType = this.getOriginalType();
        String other$originalType = other.getOriginalType();
        if (this$originalType == null ? other$originalType != null : !this$originalType.equals(other$originalType)) {
            return false;
        }
        String this$replacementType = this.getReplacementType();
        String other$replacementType = other.getReplacementType();
        return !(this$replacementType == null ? other$replacementType != null : !this$replacementType.equals(other$replacementType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChangeType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $originalType = this.getOriginalType();
        result = result * 59 + ($originalType == null ? 43 : $originalType.hashCode());
        String $replacementType = this.getReplacementType();
        result = result * 59 + ($replacementType == null ? 43 : $replacementType.hashCode());
        return result;
    }

    private class ChangeTypeVisitor
    extends JavaVisitor<ExecutionContext> {
        private JavaType targetType;

        private ChangeTypeVisitor(String targetType) {
            JavaType type = JavaType.Primitive.fromKeyword(targetType);
            if (type == null) {
                type = JavaType.Class.build(targetType);
            }
            this.targetType = type;
        }

        @Override
        public J visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
            if (this.targetType instanceof JavaType.FullyQualified) {
                this.maybeAddImport((JavaType.FullyQualified)this.targetType);
            }
            this.maybeRemoveImport(ChangeType.this.originalType);
            return super.visitCompilationUnit(cu, ctx);
        }

        @Override
        public <N extends NameTree> N visitTypeName(N name, ExecutionContext ctx) {
            JavaType.Class oldTypeAsClass = TypeUtils.asClass(name.getType());
            NameTree n = (NameTree)this.visitAndCast(name, ctx, (x$0, x$1) -> super.visitTypeName(x$0, x$1));
            if (!(name instanceof TypeTree) && oldTypeAsClass != null && oldTypeAsClass.getFullyQualifiedName().equals(ChangeType.this.originalType)) {
                n = (NameTree)n.withType(this.targetType);
            }
            return (N)n;
        }

        @Override
        public J visitAnnotation(J.Annotation annotation, ExecutionContext ctx) {
            J.Annotation a = (J.Annotation)this.visitAndCast(annotation, ctx, (x$0, x$1) -> super.visitAnnotation((J.Annotation)x$0, x$1));
            return a.withAnnotationType(this.transformName(a.getAnnotationType()));
        }

        @Override
        public J visitArrayType(J.ArrayType arrayType, ExecutionContext ctx) {
            J.ArrayType a = (J.ArrayType)this.visitAndCast(arrayType, ctx, (x$0, x$1) -> super.visitArrayType((J.ArrayType)x$0, x$1));
            return a.withElementType(this.transformName(a.getElementType()));
        }

        @Override
        public J visitClassDecl(J.ClassDecl classDecl, ExecutionContext ctx) {
            J.ClassDecl c = (J.ClassDecl)this.visitAndCast(classDecl, ctx, (x$0, x$1) -> super.visitClassDecl((J.ClassDecl)x$0, x$1));
            if (c.getExtends() != null) {
                c = c.withExtends(c.getExtends().map(this::transformName));
            }
            if (c.getImplements() != null) {
                c = c.withImplements(c.getImplements().map(this::transformName));
            }
            return c;
        }

        @Override
        public J visitFieldAccess(J.FieldAccess fieldAccess, ExecutionContext ctx) {
            J.FieldAccess f = (J.FieldAccess)this.visitAndCast(fieldAccess, ctx, (x$0, x$1) -> super.visitFieldAccess((J.FieldAccess)x$0, x$1));
            if (f.isFullyQualifiedClassReference(ChangeType.this.originalType)) {
                if (this.targetType instanceof JavaType.FullyQualified) {
                    return TypeTree.build(((JavaType.FullyQualified)this.targetType).getFullyQualifiedName()).withPrefix(f.getPrefix());
                }
                if (this.targetType instanceof JavaType.Primitive) {
                    return new J.Primitive(f.getId(), f.getPrefix(), Markers.EMPTY, (JavaType.Primitive)this.targetType);
                }
            }
            return f;
        }

        @Override
        public J visitIdentifier(J.Ident ident, ExecutionContext ctx) {
            J.Ident i = (J.Ident)this.visitAndCast(ident, ctx, (x$0, x$1) -> super.visitIdentifier((J.Ident)x$0, x$1));
            JavaType.Class original = JavaType.Class.build(ChangeType.this.originalType);
            if (TypeUtils.isOfClassType(i.getType(), ChangeType.this.originalType) && i.getSimpleName().equals(original.getClassName())) {
                if (this.targetType instanceof JavaType.FullyQualified) {
                    i = i.withName(((JavaType.FullyQualified)this.targetType).getClassName());
                } else if (this.targetType instanceof JavaType.Primitive) {
                    i = i.withName(((JavaType.Primitive)this.targetType).getKeyword());
                }
                i = i.withType(this.targetType);
            }
            return i;
        }

        @Override
        public J visitMethod(J.MethodDecl method, ExecutionContext ctx) {
            J.MethodDecl m = (J.MethodDecl)this.visitAndCast(method, ctx, (x$0, x$1) -> super.visitMethod((J.MethodDecl)x$0, x$1));
            return m.withThrows((m = m.withReturnTypeExpr(this.transformName(m.getReturnTypeExpr()))).getThrows() == null ? null : m.getThrows().map(this::transformName));
        }

        @Override
        public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            JavaType.Class selectType;
            J.MethodInvocation m = (J.MethodInvocation)this.visitAndCast(method, ctx, (x$0, x$1) -> super.visitMethodInvocation((J.MethodInvocation)x$0, x$1));
            if (m.getSelect() instanceof NameTree && m.getType() != null && m.getType().hasFlags(Flag.Static)) {
                m = m.withSelect(m.getSelect().map(this::transformName));
            }
            if (m.getSelect() != null && (selectType = TypeUtils.asClass(m.getSelect().getElem().getType())) != null && selectType.getFullyQualifiedName().equals(ChangeType.this.originalType)) {
                m = m.withSelect(m.getSelect().map(s -> (Expression)s.withType(this.targetType)));
            }
            if (m.getType() != null && m.getType().getDeclaringType().getFullyQualifiedName().equals(ChangeType.this.originalType) && this.targetType instanceof JavaType.FullyQualified) {
                m = m.withDeclaringType((JavaType.FullyQualified)this.targetType);
            }
            return m;
        }

        @Override
        public J visitMultiCatch(J.MultiCatch multiCatch, ExecutionContext ctx) {
            J.MultiCatch m = (J.MultiCatch)this.visitAndCast(multiCatch, ctx, (x$0, x$1) -> super.visitMultiCatch((J.MultiCatch)x$0, x$1));
            return m.withAlternatives(ListUtils.map(m.getAlternatives(), a -> a.map(this::transformName)));
        }

        @Override
        public J visitMultiVariable(J.VariableDecls multiVariable, ExecutionContext ctx) {
            J.VariableDecls m = (J.VariableDecls)this.visitAndCast(multiVariable, ctx, (x$0, x$1) -> super.visitMultiVariable((J.VariableDecls)x$0, x$1));
            if (!(multiVariable.getTypeExpr() instanceof J.MultiCatch)) {
                m = m.withTypeExpr(this.transformName(m.getTypeExpr()));
            }
            return m;
        }

        public J.VariableDecls.NamedVar visitVariable(J.VariableDecls.NamedVar variable, ExecutionContext ctx) {
            J.VariableDecls.NamedVar v = (J.VariableDecls.NamedVar)this.visitAndCast(variable, ctx, (x$0, x$1) -> super.visitVariable((J.VariableDecls.NamedVar)x$0, x$1));
            JavaType.Class varType = TypeUtils.asClass(variable.getType());
            if (varType != null && varType.getFullyQualifiedName().equals(ChangeType.this.originalType)) {
                v = v.withType(this.targetType).withName(v.getName().withType(this.targetType));
            }
            return v;
        }

        @Override
        public J visitNewArray(J.NewArray newArray, ExecutionContext ctx) {
            J.NewArray n = (J.NewArray)this.visitAndCast(newArray, ctx, (x$0, x$1) -> super.visitNewArray((J.NewArray)x$0, x$1));
            return n.withTypeExpr(this.transformName(n.getTypeExpr()));
        }

        @Override
        public J visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
            J.NewClass n = (J.NewClass)this.visitAndCast(newClass, ctx, (x$0, x$1) -> super.visitNewClass((J.NewClass)x$0, x$1));
            return n.withClazz(this.transformName(n.getClazz()));
        }

        @Override
        public J visitTypeCast(J.TypeCast typeCast, ExecutionContext ctx) {
            J.TypeCast t = (J.TypeCast)this.visitAndCast(typeCast, ctx, (x$0, x$1) -> super.visitTypeCast((J.TypeCast)x$0, x$1));
            return t.withClazz(t.getClazz().withTree(t.getClazz().getTree().map(this::transformName)));
        }

        @Override
        public J visitTypeParameter(J.TypeParameter typeParam, ExecutionContext ctx) {
            J.TypeParameter t;
            t = t.withBounds((t = (J.TypeParameter)this.visitAndCast(typeParam, ctx, (x$0, x$1) -> super.visitTypeParameter((J.TypeParameter)x$0, x$1))).getBounds() == null ? null : t.getBounds().map(this::transformName));
            return t.withName(this.transformName(t.getName()));
        }

        @Override
        public J visitWildcard(J.Wildcard wildcard, ExecutionContext ctx) {
            J.Wildcard w = (J.Wildcard)this.visitAndCast(wildcard, ctx, (x$0, x$1) -> super.visitWildcard((J.Wildcard)x$0, x$1));
            return w.withBoundedType(this.transformName(w.getBoundedType()));
        }

        @Nullable
        private <T extends J> T transformName(@Nullable T nameField) {
            if (nameField instanceof NameTree) {
                JavaType.Class nameTreeClass = TypeUtils.asClass(((NameTree)nameField).getType());
                String name = this.targetType instanceof JavaType.FullyQualified ? ((JavaType.FullyQualified)this.targetType).getClassName() : ((JavaType.Primitive)this.targetType).getKeyword();
                if (nameTreeClass != null && nameTreeClass.getFullyQualifiedName().equals(ChangeType.this.originalType)) {
                    return (T)J.Ident.build(Tree.randomId(), nameField.getPrefix(), Markers.EMPTY, name, this.targetType);
                }
            }
            return nameField;
        }
    }
}

