/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.beans.ConstructorProperties;
import java.util.LinkedHashSet;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.OrderImports;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public class ChangeMethodTargetToVariable
extends Recipe {
    private final String methodPattern;
    private final String variableName;
    private final String variableType;

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new ChangeMethodTargetToVariableVisitor(new MethodMatcher(this.methodPattern), JavaType.Class.build(this.variableType));
    }

    @ConstructorProperties(value={"methodPattern", "variableName", "variableType"})
    public ChangeMethodTargetToVariable(String methodPattern, String variableName, String variableType) {
        this.methodPattern = methodPattern;
        this.variableName = variableName;
        this.variableType = variableType;
    }

    public String getMethodPattern() {
        return this.methodPattern;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public String getVariableType() {
        return this.variableType;
    }

    public String toString() {
        return "ChangeMethodTargetToVariable(methodPattern=" + this.getMethodPattern() + ", variableName=" + this.getVariableName() + ", variableType=" + this.getVariableType() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeMethodTargetToVariable)) {
            return false;
        }
        ChangeMethodTargetToVariable other = (ChangeMethodTargetToVariable)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        if (this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern)) {
            return false;
        }
        String this$variableName = this.getVariableName();
        String other$variableName = other.getVariableName();
        if (this$variableName == null ? other$variableName != null : !this$variableName.equals(other$variableName)) {
            return false;
        }
        String this$variableType = this.getVariableType();
        String other$variableType = other.getVariableType();
        return !(this$variableType == null ? other$variableType != null : !this$variableType.equals(other$variableType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChangeMethodTargetToVariable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        String $variableName = this.getVariableName();
        result = result * 59 + ($variableName == null ? 43 : $variableName.hashCode());
        String $variableType = this.getVariableType();
        result = result * 59 + ($variableType == null ? 43 : $variableType.hashCode());
        return result;
    }

    private class ChangeMethodTargetToVariableVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final MethodMatcher methodMatcher;
        private final JavaType.Class variableType;

        private ChangeMethodTargetToVariableVisitor(MethodMatcher methodMatcher, JavaType.Class variableType) {
            this.methodMatcher = methodMatcher;
            this.variableType = variableType;
        }

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J m = super.visitMethodInvocation(method, ctx);
            if (this.methodMatcher.matches((J.MethodInvocation)m)) {
                JavaType.Method methodType = null;
                if (((J.MethodInvocation)m).getType() != null) {
                    LinkedHashSet<Flag> flags = new LinkedHashSet<Flag>(((J.MethodInvocation)m).getType().getFlags());
                    flags.remove((Object)Flag.Static);
                    methodType = ((J.MethodInvocation)m).getType().withDeclaringType(this.variableType).withFlags(flags);
                }
                m = ((J.MethodInvocation)m).withSelect(new JRightPadded<Expression>(J.Ident.build(Tree.randomId(), ((J.MethodInvocation)m).getSelect() == null ? Space.EMPTY : ((J.MethodInvocation)m).getSelect().getElem().getPrefix(), Markers.EMPTY, ChangeMethodTargetToVariable.this.variableName, this.variableType), Space.EMPTY, Markers.EMPTY)).withType(methodType);
                this.doAfterVisit(new OrderImports());
            }
            return m;
        }
    }
}

