/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.concurrent.atomic.AtomicReference;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class ChangeFieldName<P>
extends JavaIsoVisitor<P> {
    private final JavaType.Class classType;
    private final String hasName;
    private final String toName;

    public ChangeFieldName(JavaType.Class classType, String hasName, String toName) {
        this.classType = classType;
        this.hasName = hasName;
        this.toName = toName;
        this.setCursoringOn();
    }

    @Override
    public J.VariableDecls.NamedVar visitVariable(J.VariableDecls.NamedVar variable, P p) {
        J v = super.visitVariable(variable, (Object)p);
        J.ClassDecl enclosingClass = (J.ClassDecl)this.getCursor().firstEnclosingOrThrow(J.ClassDecl.class);
        if (variable.isField(this.getCursor()) && this.matchesClass(enclosingClass.getType()) && variable.getSimpleName().equals(this.hasName)) {
            v = ((J.VariableDecls.NamedVar)v).withName(((J.VariableDecls.NamedVar)v).getName().withName(this.toName));
        }
        return v;
    }

    @Override
    public J.FieldAccess visitFieldAccess(J.FieldAccess fieldAccess, P p) {
        J f = super.visitFieldAccess(fieldAccess, (Object)p);
        if (this.matchesClass(fieldAccess.getTarget().getType()) && fieldAccess.getSimpleName().equals(this.hasName)) {
            f = ((J.FieldAccess)f).withName(((J.FieldAccess)f).getName().withElem(((J.FieldAccess)f).getName().getElem().withName(this.toName)));
        }
        return f;
    }

    @Override
    public J.Ident visitIdentifier(J.Ident ident, P p) {
        J i = super.visitIdentifier(ident, (Object)p);
        if (ident.getSimpleName().equals(this.hasName) && this.isFieldReference(ident)) {
            i = ((J.Ident)i).withName(this.toName);
        }
        return i;
    }

    private boolean matchesClass(@Nullable JavaType test) {
        JavaType.Class testClassType = TypeUtils.asClass(test);
        return testClassType != null && testClassType.getFullyQualifiedName().equals(this.classType.getFullyQualifiedName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isFieldReference(J.Ident ident) {
        AtomicReference nearest = new AtomicReference();
        new FindVariableDefinition(ident, this.getCursor()).visit((Tree)this.getCursor().firstEnclosing(J.CompilationUnit.class), nearest);
        if (nearest.get() == null) return false;
        if (!(((Cursor)nearest.get()).dropParentUntil(J.class::isInstance).dropParentUntil(J.class::isInstance).dropParentUntil(J.class::isInstance).getValue() instanceof J.ClassDecl)) return false;
        return true;
    }

    private static class FindVariableDefinition
    extends JavaIsoVisitor<AtomicReference<Cursor>> {
        private final J.Ident ident;
        private final Cursor referenceScope;

        public FindVariableDefinition(J.Ident ident, Cursor referenceScope) {
            this.ident = ident;
            this.referenceScope = referenceScope;
            this.setCursoringOn();
        }

        @Override
        public J.VariableDecls.NamedVar visitVariable(J.VariableDecls.NamedVar variable, AtomicReference<Cursor> ctx) {
            if (variable.getSimpleName().equalsIgnoreCase(this.ident.getSimpleName()) && this.isInSameNameScope(this.referenceScope)) {
                ctx.accumulateAndGet(this.getCursor(), (r1, r2) -> {
                    if (r1 == null) {
                        return r2;
                    }
                    return r1.getPathAsStream().count() > r2.getPathAsStream().count() ? r1 : r2;
                });
            }
            return super.visitVariable(variable, ctx);
        }
    }
}

