/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;

public class Space {
    public static Space EMPTY = new Space("", Collections.emptyList());
    private final List<Comment> comments;
    private final String whitespace;
    private static final String[] spaces = new String[]{"\u00b7\u2081", "\u00b7\u2082", "\u00b7\u2083", "\u00b7\u2084", "\u00b7\u2085", "\u00b7\u2086", "\u00b7\u2087", "\u00b7\u2088", "\u00b7\u2089", "\u00b7\u208a"};
    private static final String[] tabs = new String[]{"-\u2081", "-\u2082", "-\u2083", "-\u2084", "-\u2085", "-\u2086", "-\u2087", "-\u2088", "-\u2089", "-\u208a"};

    private Space(@JsonProperty(value="whitespace") String whitespace, @JsonProperty(value="comments") List<Comment> comments) {
        this.comments = comments;
        this.whitespace = whitespace;
    }

    @JsonCreator
    public static Space build(@JsonProperty(value="whitespace") String whitespace, @JsonProperty(value="comments") List<Comment> comments) {
        if (whitespace.isEmpty() && comments.isEmpty()) {
            return EMPTY;
        }
        return new Space(whitespace, comments);
    }

    @JsonIgnore
    public String getIndent() {
        int lastNewline = this.whitespace.lastIndexOf(10);
        if (lastNewline >= 0) {
            return this.whitespace.substring(lastNewline + 1);
        }
        if (lastNewline == this.whitespace.length() - 1) {
            return "";
        }
        return this.whitespace;
    }

    public List<Comment> getComments() {
        return this.comments;
    }

    public String getWhitespace() {
        return this.whitespace;
    }

    public Space withComments(List<Comment> comments) {
        if (comments.isEmpty() && this.whitespace.isEmpty()) {
            return EMPTY;
        }
        return Space.build(this.whitespace, comments);
    }

    public Space withWhitespace(String whitespace) {
        if (this.comments.isEmpty() && whitespace.isEmpty()) {
            return EMPTY;
        }
        if (!whitespace.equals(this.whitespace)) {
            return Space.build(whitespace, this.comments);
        }
        return this;
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public static Space firstPrefix(@Nullable List<? extends J> trees) {
        return trees == null || trees.isEmpty() ? EMPTY : trees.iterator().next().getPrefix();
    }

    public static Space format(String formatting) {
        char[] charArray;
        StringBuilder prefix = new StringBuilder();
        StringBuilder comment = new StringBuilder();
        ArrayList<Comment> comments = new ArrayList<Comment>();
        boolean inSingleLineComment = false;
        boolean inMultiLineComment = false;
        boolean inJavadoc = false;
        char last = '\u0000';
        for (char c : charArray = formatting.toCharArray()) {
            switch (c) {
                case '/': {
                    if (!(last != '/' || inSingleLineComment || inMultiLineComment || inJavadoc)) {
                        inSingleLineComment = true;
                        comment = new StringBuilder();
                        break;
                    }
                    if (last == '*' && inMultiLineComment) {
                        inMultiLineComment = false;
                        comment.setLength(comment.length() - 1);
                        comments.add(new Comment(Comment.Style.BLOCK, comment.toString(), prefix.toString()));
                        prefix = new StringBuilder();
                        comment = new StringBuilder();
                        break;
                    }
                    if (last == '*' && inJavadoc) {
                        inJavadoc = false;
                        comment.setLength(comment.length() - 1);
                        comments.add(new Comment(Comment.Style.JAVADOC, comment.toString(), prefix.toString()));
                        prefix = new StringBuilder();
                        comment = new StringBuilder();
                        break;
                    }
                    comment.append(c);
                    break;
                }
                case '\n': 
                case '\r': {
                    if (inSingleLineComment) {
                        inSingleLineComment = false;
                        comments.add(new Comment(Comment.Style.LINE, comment.toString(), prefix.toString()));
                        prefix = new StringBuilder();
                        comment = new StringBuilder();
                        prefix.append(c);
                        break;
                    }
                    if (!inMultiLineComment && !inJavadoc) {
                        prefix.append(c);
                        break;
                    }
                    comment.append(c);
                    break;
                }
                case '*': {
                    if (last == '/' && !inMultiLineComment && !inJavadoc) {
                        inMultiLineComment = true;
                        comment = new StringBuilder();
                        break;
                    }
                    if (last == '*' && inMultiLineComment && comment.toString().isEmpty()) {
                        inMultiLineComment = false;
                        inJavadoc = true;
                        comment = new StringBuilder();
                        break;
                    }
                    comment.append(c);
                    break;
                }
                default: {
                    if (inSingleLineComment || inMultiLineComment || inJavadoc) {
                        comment.append(c);
                        break;
                    }
                    prefix.append(c);
                }
            }
            last = c;
        }
        String whitespace = prefix.toString();
        if (!comments.isEmpty()) {
            for (int i = comments.size() - 1; i >= 0; --i) {
                Comment c = (Comment)comments.get(i);
                String next = c.getSuffix();
                comments.set(i, c.withSuffix(whitespace));
                whitespace = next;
            }
        }
        return Space.build(whitespace, comments);
    }

    public static <J2 extends J> List<JRightPadded<J2>> formatLastSuffix(@Nullable List<JRightPadded<J2>> trees, Space suffix) {
        if (trees == null) {
            return null;
        }
        if (!trees.isEmpty()) {
            ArrayList<JRightPadded<J2>> formattedTrees = new ArrayList<JRightPadded<J2>>(trees);
            formattedTrees.set(formattedTrees.size() - 1, ((JRightPadded)formattedTrees.get(formattedTrees.size() - 1)).withAfter(suffix));
            return formattedTrees;
        }
        return trees;
    }

    public static <J2 extends J> List<J2> formatFirstPrefix(@Nullable List<J2> trees, Space prefix) {
        if (trees == null) {
            return null;
        }
        if (!trees.isEmpty()) {
            ArrayList<J2> formattedTrees = new ArrayList<J2>(trees);
            formattedTrees.set(0, ((J)formattedTrees.get(0)).withPrefix(prefix));
            return formattedTrees;
        }
        return trees;
    }

    public String toString() {
        StringBuilder printedWs = new StringBuilder();
        int lastNewline = 0;
        char[] charArray = this.whitespace.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            if (c == '\n') {
                printedWs.append("\\n");
                lastNewline = i + 1;
                continue;
            }
            if (c == '\r') {
                printedWs.append("\\r");
                lastNewline = i + 1;
                continue;
            }
            if (c == ' ') {
                printedWs.append(spaces[(i - lastNewline) % 10]);
                continue;
            }
            if (c != '\t') continue;
            printedWs.append(tabs[(i - lastNewline) % 10]);
        }
        return "Space(comments=<" + (this.comments.size() == 1 ? "1 comment" : this.comments.size() + " comments") + ">, whitespace='" + printedWs + "')";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Space)) {
            return false;
        }
        Space other = (Space)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Comment> this$comments = this.getComments();
        List<Comment> other$comments = other.getComments();
        if (this$comments == null ? other$comments != null : !((Object)this$comments).equals(other$comments)) {
            return false;
        }
        String this$whitespace = this.getWhitespace();
        String other$whitespace = other.getWhitespace();
        return !(this$whitespace == null ? other$whitespace != null : !this$whitespace.equals(other$whitespace));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Space;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Comment> $comments = this.getComments();
        result = result * 59 + ($comments == null ? 43 : ((Object)$comments).hashCode());
        String $whitespace = this.getWhitespace();
        result = result * 59 + ($whitespace == null ? 43 : $whitespace.hashCode());
        return result;
    }
}

