/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Validated;
import org.openrewrite.java.JavaProcessor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.SearchResult;

public final class FindType
extends Recipe {
    private String clazz;

    public FindType() {
        this.processor = () -> new FindTypeProcessor(this.clazz);
    }

    public void setClass(String clazz) {
        this.clazz = clazz;
    }

    public Validated validate() {
        return Validated.required((String)"class", (Object)this.clazz);
    }

    public static Set<NameTree> find(J j, String clazz) {
        return ((J)new FindTypeProcessor(clazz).visit(j, ExecutionContext.builder().build())).findMarkedWith(SearchResult.class);
    }

    private static class FindTypeProcessor
    extends JavaProcessor<ExecutionContext> {
        private final String clazz;

        public FindTypeProcessor(String clazz) {
            this.clazz = clazz;
            this.setCursoringOn();
        }

        @Override
        public <N extends NameTree> N visitTypeName(N name, ExecutionContext ctx) {
            N n = super.visitTypeName(name, ctx);
            JavaType.Class asClass = TypeUtils.asClass(n.getType());
            if (asClass != null && asClass.getFullyQualifiedName().equals(this.clazz) && this.getCursor().firstEnclosing(J.Import.class) == null) {
                return (N)((NameTree)n.withMarkers(n.getMarkers().add((Marker)new SearchResult())));
            }
            return n;
        }
    }
}

