/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import java.util.List;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoProcessor;
import org.openrewrite.java.style.TabsAndIndentsStyle;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;

class TabsAndIndentsProcessor<P>
extends JavaIsoProcessor<P> {
    private final TabsAndIndentsStyle style;
    @Nullable
    private final List<? extends J> limitToTrees;

    public TabsAndIndentsProcessor(TabsAndIndentsStyle style, @Nullable List<? extends J> limitToTrees) {
        this.style = style;
        this.limitToTrees = limitToTrees;
        this.setCursoringOn();
    }

    private boolean shouldNotFormat() {
        return this.limitToTrees != null && this.limitToTrees.stream().noneMatch(t -> this.getCursor().isScopeInPath((Tree)t));
    }

    @Override
    public Statement visitStatement(Statement statement, P p) {
        Statement s = statement;
        if (this.shouldNotFormat()) {
            return super.visitStatement(s, (Object)p);
        }
        Cursor parentCursor = this.getCursor().getParentOrThrow();
        J parent = (J)parentCursor.getTree();
        if (!(s instanceof J.Block)) {
            parent = (J)parentCursor.getTree();
            Cursor cursor = parentCursor;
            while (parent instanceof J.Block || parent instanceof J.Label || parent instanceof J.Try.Catch || parent instanceof J.If && cursor.getParentOrThrow().getTree() instanceof J.If.Else || parent instanceof J.If.Else) {
                cursor = cursor.getParentOrThrow();
                parent = (J)cursor.getTree();
            }
        }
        s = this.indent(s, parent);
        this.rebaseCursor(s);
        return super.visitStatement(s, (Object)p);
    }

    @Override
    public J.ArrayDimension visitArrayDimension(J.ArrayDimension arrayDimension, P p) {
        J arrDim = super.visitArrayDimension(arrayDimension, (Object)p);
        if (this.shouldNotFormat()) {
            return arrDim;
        }
        J.ArrayDimension a = (J.ArrayDimension)this.continuationIndent(arrDim, (Tree)this.enclosingStatement());
        a = a.withIndex(this.continuationIndent((J)((Object)a.getIndex()), (Tree)this.enclosingStatement()));
        a = a.withIndex(a.getIndex().withAfter(this.continuationIndent(a.getIndex().getAfter(), (Tree)this.enclosingStatement())));
        return a;
    }

    @Override
    public J.Assign visitAssign(J.Assign assign, P p) {
        J a = super.visitAssign(assign, (Object)p);
        if (this.shouldNotFormat()) {
            return a;
        }
        a = ((J.Assign)a).withAssignment(this.continuationIndent((J)((Object)((J.Assign)a).getAssignment()), (Tree)this.enclosingStatement()));
        return a;
    }

    @Override
    public J.AssignOp visitAssignOp(J.AssignOp assignOp, P p) {
        J a = super.visitAssignOp(assignOp, (Object)p);
        if (this.shouldNotFormat()) {
            return a;
        }
        a = ((J.AssignOp)a).withAssignment(this.continuationIndent(((J.AssignOp)a).getAssignment(), (Tree)this.enclosingStatement()));
        return a;
    }

    @Override
    public J.Binary visitBinary(J.Binary binary, P p) {
        J b = super.visitBinary(binary, (Object)p);
        if (this.shouldNotFormat()) {
            return b;
        }
        b = ((J.Binary)b).withOperator(this.continuationIndent((J)((Object)((J.Binary)b).getOperator()), (Tree)this.enclosingStatement()));
        return b;
    }

    @Override
    public J.Block visitBlock(J.Block block, P p) {
        J j = super.visitBlock(block, (Object)p);
        if (this.shouldNotFormat()) {
            return j;
        }
        Cursor cursor = this.getCursor().getParentOrThrow();
        Tree parent = cursor.getTree();
        while (parent instanceof J.Try.Catch || parent instanceof J.If && cursor.getParentOrThrow().getTree() instanceof J.If.Else || parent instanceof J.If.Else) {
            cursor = cursor.getParentOrThrow();
            parent = cursor.getTree();
        }
        return ((J.Block)j).withEnd(this.alignToParentStatement(((J.Block)j).getEnd(), cursor));
    }

    @Override
    public J.DoWhileLoop visitDoWhileLoop(J.DoWhileLoop doWhileLoop, P p) {
        J d = super.visitDoWhileLoop(doWhileLoop, (Object)p);
        if (this.shouldNotFormat()) {
            return d;
        }
        return ((J.DoWhileLoop)d).withWhileCondition(((J.DoWhileLoop)d).getWhileCondition().withBefore(this.alignToParentStatement(((J.DoWhileLoop)d).getWhileCondition().getBefore(), this.getCursor())));
    }

    @Override
    public Expression visitExpression(Expression expression, P p) {
        J e = super.visitExpression(expression, (Object)p);
        if (this.shouldNotFormat()) {
            return e;
        }
        if (expression instanceof J.Annotation) {
            e = (Expression)e.withPrefix(this.alignTo(e.getPrefix(), this.indent(((J)this.getCursor().getParentOrThrow().getTree()).getPrefix())));
        } else if (!(this.getCursor().getParentOrThrow().getTree() instanceof J.Block) && !(this.getCursor().getParentOrThrow().getTree() instanceof J.Case)) {
            e = (Expression)this.continuationIndent(e, (Tree)this.enclosingStatement());
        }
        return e;
    }

    @Override
    public J.ForLoop visitForLoop(J.ForLoop forLoop, P p) {
        J.ForLoop f = (J.ForLoop)this.visitStatement((Statement)forLoop, (Object)p);
        if (this.shouldNotFormat()) {
            return f;
        }
        f = f.withBody(this.call(f.getBody(), p));
        J.ForLoop.Control control = forLoop.getControl();
        JRightPadded<Statement> init = control.getInit();
        JRightPadded<Expression> condition = control.getCondition();
        List<JRightPadded<Statement>> update = control.getUpdate();
        if (init.getElem().getPrefix().getWhitespace().contains("\n")) {
            f = f.withControl(control.withInit(this.continuationIndent((J)((Object)init), (Tree)f)).withCondition(this.continuationIndent((J)((Object)condition), (Tree)f)).withUpdate(this.continuationIndent((J)((Object)update), (Tree)f)));
        } else {
            f = f.withControl(f.getControl().withCondition(condition.withElem(this.alignTo(condition.getElem(), this.forInitColumn()))));
            int column = this.forInitColumn();
            f = f.withControl(f.getControl().withUpdate(ListUtils.map(update, (i, j) -> j.withElem(this.alignTo((Statement)j.getElem(), i == 0 ? column : column + this.style.getContinuationIndent())))));
        }
        return f;
    }

    private int forInitColumn() {
        J.ForLoop forLoop = (J.ForLoop)this.getCursor().getTree();
        J parent = (J)this.getCursor().getParentOrThrow().getTree();
        J.ForLoop alignTo = parent instanceof J.Label ? ((J.Label)parent).withStatement(forLoop.withBody(null)) : forLoop.withBody(null);
        int column = 0;
        boolean afterInitStart = false;
        for (char c : alignTo.print().toCharArray()) {
            if (c == '(') {
                afterInitStart = true;
            } else if (afterInitStart && !Character.isWhitespace(c)) {
                return column - 1;
            }
            ++column;
        }
        throw new IllegalStateException("For loops must have a control section");
    }

    @Override
    public J.MemberReference visitMemberReference(J.MemberReference memberRef, P p) {
        J m = super.visitMemberReference(memberRef, (Object)p);
        if (this.shouldNotFormat()) {
            return m;
        }
        m = ((J.MemberReference)m).withReference(this.continuationIndent((J)((Object)((J.MemberReference)m).getReference()), (Tree)this.enclosingStatement()));
        return m;
    }

    @Override
    public J.MethodDecl visitMethod(J.MethodDecl method, P p) {
        J m = super.visitMethod(method, (Object)p);
        if (this.shouldNotFormat()) {
            return m;
        }
        List<JRightPadded<Statement>> params = ((J.MethodDecl)m).getParams().getElem();
        if (!params.isEmpty()) {
            if (params.get(0).getElem().getPrefix().getWhitespace().contains("\n")) {
                J parent = m;
                m = ((J.MethodDecl)m).withParams(((J.MethodDecl)m).getParams().withElem(ListUtils.map(((J.MethodDecl)m).getParams().getElem(), arg_0 -> this.lambda$visitMethod$2((J.MethodDecl)parent, arg_0))));
            } else if (params.stream().anyMatch(param -> ((Statement)param.getElem()).getPrefix().getWhitespace().contains("\n"))) {
                int nl;
                String print = ((J.MethodDecl)m).withBody(null).print();
                int nameStart = print.lastIndexOf(((J.MethodDecl)m).getSimpleName() + "(");
                int lastNl = -1;
                while ((nl = print.indexOf(10, ++lastNl)) >= 0 && nl <= nameStart) {
                    lastNl = nl;
                }
                int column = nameStart - lastNl + ((J.MethodDecl)m).getSimpleName().length() + 1;
                m = ((J.MethodDecl)m).withParams(((J.MethodDecl)m).getParams().withElem(ListUtils.map(((J.MethodDecl)m).getParams().getElem(), (i, param) -> i == 0 ? param : param.withElem(this.alignTo((Statement)param.getElem(), column)))));
            }
        }
        m = ((J.MethodDecl)m).withBody((J.Block)this.call(((J.MethodDecl)m).getBody(), p));
        return m;
    }

    @Override
    public J.Ternary visitTernary(J.Ternary ternary, P p) {
        J t = super.visitTernary(ternary, (Object)p);
        if (this.shouldNotFormat()) {
            return t;
        }
        t = ((J.Ternary)t).withTruePart(this.continuationIndent((J)((Object)((J.Ternary)t).getTruePart()), (Tree)this.enclosingStatement()));
        t = ((J.Ternary)t).withFalsePart(this.continuationIndent((J)((Object)((J.Ternary)t).getFalsePart()), (Tree)this.enclosingStatement()));
        return t;
    }

    @Override
    public J.Unary visitUnary(J.Unary unary, P p) {
        J u = super.visitUnary(unary, (Object)p);
        if (this.shouldNotFormat()) {
            return u;
        }
        u = ((J.Unary)u).withOperator(this.continuationIndent((J)((Object)((J.Unary)u).getOperator()), (Tree)this.enclosingStatement()));
        return u;
    }

    private <J2 extends J> List<JRightPadded<J2>> continuationIndent(List<JRightPadded<J2>> js, Tree parent) {
        return ListUtils.map(js, (i, j) -> {
            if (i == 0) {
                return this.continuationIndent((J)((Object)j), parent);
            }
            return j.withElem(((J)j.getElem()).withPrefix(this.indent(((J)j.getElem()).getPrefix(), parent, this.style.getContinuationIndent() * 2)));
        });
    }

    private <J2 extends J> JRightPadded<J2> continuationIndent(JRightPadded<J2> j, @Nullable Tree parent) {
        return j.withElem(((J)j.getElem()).withPrefix(this.indent(((J)j.getElem()).getPrefix(), parent, this.style.getContinuationIndent())));
    }

    private <T> JLeftPadded<T> continuationIndent(JLeftPadded<T> t, @Nullable Tree parent) {
        return t.withBefore(this.continuationIndent(t.getBefore(), parent));
    }

    private <J2 extends J> J2 continuationIndent(J2 j, @Nullable Tree parent) {
        return j.withPrefix(this.indent(j.getPrefix(), parent, this.style.getContinuationIndent()));
    }

    private <J2 extends J> J2 indent(J2 j, Tree parent) {
        if (parent instanceof J.CompilationUnit) {
            return j;
        }
        return j.withPrefix(this.indent(j.getPrefix(), parent, this.style.getIndentSize()));
    }

    @Nullable
    private Statement enclosingStatement() {
        Cursor cursor;
        for (cursor = this.getCursor(); !(cursor == null || cursor.getTree() instanceof Statement && ((J)cursor.getTree()).getPrefix().getWhitespace().contains("\n")); cursor = cursor.getParent()) {
        }
        return cursor == null ? null : (Statement)cursor.getTree();
    }

    private Space continuationIndent(Space space, @Nullable Tree parent) {
        return this.indent(space, parent, this.style.getContinuationIndent());
    }

    private Space indent(Space space, @Nullable Tree parent, int indentSize) {
        if (parent == null || !space.getWhitespace().contains("\n")) {
            return space;
        }
        int parentIndent = this.indent(((J)parent).getPrefix());
        int indent = this.indent(space);
        if (indent != parentIndent + indentSize) {
            int shift = indentSize + parentIndent - indent;
            space = space.withComments(ListUtils.map(space.getComments(), c -> this.indentComment((Comment)c, shift)));
            space = space.withWhitespace(this.indent(space.getWhitespace(), shift));
        }
        return space;
    }

    private Space alignToParentStatement(Space space, Cursor parent) {
        J alignTo = parent.getParentOrThrow().getTree() instanceof J.Label ? (J)parent.getParentOrThrow().getTree() : (J)parent.getTree();
        return this.alignTo(space, this.indent(alignTo.getPrefix()));
    }

    private <J2 extends J> J2 alignTo(J2 j, int column) {
        return j.withPrefix(this.alignTo(j.getPrefix(), column));
    }

    private Space alignTo(Space space, int column) {
        if (!space.getWhitespace().contains("\n")) {
            return space;
        }
        int indent = this.indent(space);
        if (indent != column) {
            int shift = column - indent;
            space = space.withComments(ListUtils.map(space.getComments(), c -> this.indentComment((Comment)c, shift)));
            space = space.withWhitespace(this.indent(space.getWhitespace(), shift));
        }
        return space;
    }

    private Comment indentComment(Comment comment, int shift) {
        StringBuilder newSuffix = new StringBuilder(comment.getSuffix());
        this.shift(newSuffix, shift);
        String newText = comment.getText();
        if (comment.getStyle() != Comment.Style.LINE) {
            StringBuilder newTextBuilder = new StringBuilder();
            for (char c : comment.getText().toCharArray()) {
                newTextBuilder.append(c);
                if (c != '\n') continue;
                this.shift(newTextBuilder, shift);
            }
            newText = newTextBuilder.toString();
        }
        return comment.withText(newText).withSuffix(newSuffix.toString());
    }

    private String indent(String whitespace, int shift) {
        StringBuilder newWhitespace = new StringBuilder(whitespace);
        this.shift(newWhitespace, shift);
        return newWhitespace.toString();
    }

    private void shift(StringBuilder text, int shift) {
        int tabIndent = this.style.getTabSize();
        if (!this.style.isUseTabCharacter()) {
            tabIndent = Integer.MAX_VALUE;
        }
        if (shift > 0) {
            int i;
            for (i = 0; i < shift / tabIndent; ++i) {
                text.append('\t');
            }
            for (i = 0; i < shift % tabIndent; ++i) {
                text.append(' ');
            }
        } else if (this.style.isUseTabCharacter()) {
            text.delete(text.length() + shift / tabIndent, text.length());
        } else {
            text.delete(text.length() + shift, text.length());
        }
    }

    private int indent(Space space) {
        String indent = space.getIndent();
        int size = 0;
        for (char c : indent.toCharArray()) {
            size += c == '\t' ? this.style.getTabSize() : 1;
            if (c != '\n' && c != '\r') continue;
            size = 0;
        }
        return size;
    }

    private /* synthetic */ JRightPadded lambda$visitMethod$2(J.MethodDecl parent, JRightPadded j) {
        return this.continuationIndent((J)((Object)j), (Tree)parent);
    }
}

