/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.java.JavaIsoProcessor;
import org.openrewrite.java.format.BlankLinesProcessor;
import org.openrewrite.java.style.BlankLinesStyle;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.tree.J;

public class BlankLines
extends Recipe {
    public BlankLines() {
        this.processor = () -> new BlankLinesFromCompilationUnitStyle();
    }

    private static class BlankLinesFromCompilationUnitStyle
    extends JavaIsoProcessor<ExecutionContext> {
        private BlankLinesFromCompilationUnitStyle() {
        }

        @Override
        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
            BlankLinesStyle style = (BlankLinesStyle)cu.getStyle(BlankLinesStyle.class);
            if (style == null) {
                style = IntelliJ.blankLines();
            }
            this.doAfterVisit(new BlankLinesProcessor(style, null));
            return cu;
        }
    }
}

