/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import java.util.List;
import java.util.Optional;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaProcessor;
import org.openrewrite.java.format.BlankLinesProcessor;
import org.openrewrite.java.format.SpacesProcessor;
import org.openrewrite.java.format.TabsAndIndentsProcessor;
import org.openrewrite.java.format.WrappingAndBracesProcessor;
import org.openrewrite.java.style.BlankLinesStyle;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.style.SpacesStyle;
import org.openrewrite.java.style.TabsAndIndentsStyle;
import org.openrewrite.java.style.WrappingAndBracesStyle;
import org.openrewrite.java.tree.J;

public class AutoFormatProcessor<P>
extends JavaProcessor<P> {
    @Nullable
    private final List<? extends J> limitToTrees;

    public AutoFormatProcessor(@Nullable List<? extends J> limitToTrees) {
        this.limitToTrees = limitToTrees;
    }

    public J visit(@Nullable Tree tree, P p, Cursor cursor) {
        J.CompilationUnit cu = (J.CompilationUnit)cursor.firstEnclosing(J.CompilationUnit.class);
        assert (cu != null);
        J t = (J)new BlankLinesProcessor(Optional.ofNullable((BlankLinesStyle)cu.getStyle(BlankLinesStyle.class)).orElse(IntelliJ.blankLines()), this.limitToTrees).visit(tree, p, cursor);
        t = (J)new SpacesProcessor(Optional.ofNullable((SpacesStyle)cu.getStyle(SpacesStyle.class)).orElse(IntelliJ.spaces()), this.limitToTrees).visit(t, p, cursor);
        t = (J)new WrappingAndBracesProcessor(Optional.ofNullable((WrappingAndBracesStyle)cu.getStyle(WrappingAndBracesStyle.class)).orElse(IntelliJ.wrappingAndBraces()), this.limitToTrees).visit(t, p, cursor);
        t = (J)new TabsAndIndentsProcessor(Optional.ofNullable((TabsAndIndentsStyle)cu.getStyle(TabsAndIndentsStyle.class)).orElse(IntelliJ.tabsAndIndents()), this.limitToTrees).visit(t, p, cursor);
        return t;
    }

    @Override
    public J visitCompilationUnit(J.CompilationUnit cu, P p) {
        J t = (J)new BlankLinesProcessor(Optional.ofNullable((BlankLinesStyle)cu.getStyle(BlankLinesStyle.class)).orElse(IntelliJ.blankLines()), this.limitToTrees).visit(cu, p);
        t = (J)new SpacesProcessor(Optional.ofNullable((SpacesStyle)cu.getStyle(SpacesStyle.class)).orElse(IntelliJ.spaces()), this.limitToTrees).visit(t, p);
        t = (J)new WrappingAndBracesProcessor(Optional.ofNullable((WrappingAndBracesStyle)cu.getStyle(WrappingAndBracesStyle.class)).orElse(IntelliJ.wrappingAndBraces()), this.limitToTrees).visit(t, p);
        t = (J)new TabsAndIndentsProcessor(Optional.ofNullable((TabsAndIndentsStyle)cu.getStyle(TabsAndIndentsStyle.class)).orElse(IntelliJ.tabsAndIndents()), this.limitToTrees).visit(t, p);
        return t;
    }
}

