/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Validated;
import org.openrewrite.java.AddImport;
import org.openrewrite.java.JavaIsoProcessor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public class UseStaticImport
extends Recipe {
    private MethodMatcher methodMatcher;

    public UseStaticImport() {
        this.processor = () -> new UseStaticImportProcessor(this.methodMatcher);
    }

    public void setMethod(String method) {
        this.methodMatcher = new MethodMatcher(method);
    }

    public Validated validate() {
        return Validated.required((String)"method", (Object)this.methodMatcher);
    }

    private static class UseStaticImportProcessor
    extends JavaIsoProcessor<ExecutionContext> {
        private final MethodMatcher methodMatcher;

        private UseStaticImportProcessor(MethodMatcher methodMatcher) {
            this.methodMatcher = methodMatcher;
        }

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J m = super.visitMethodInvocation(method, ctx);
            if (this.methodMatcher.matches((J.MethodInvocation)m) && ((J.MethodInvocation)m).getSelect() != null) {
                if (((J.MethodInvocation)m).getType() != null) {
                    JavaType.FullyQualified receiverType = ((J.MethodInvocation)m).getType().getDeclaringType();
                    this.maybeRemoveImport(receiverType);
                    AddImport addStatic = new AddImport(receiverType.getFullyQualifiedName(), ((J.MethodInvocation)m).getSimpleName(), false);
                    if (!this.getAfterVisit().contains(addStatic)) {
                        this.doAfterVisit(addStatic);
                    }
                }
                m = ((J.MethodInvocation)m).withSelect(null).withName(((J.MethodInvocation)m).getName().withPrefix(((J.MethodInvocation)m).getSelect().getElem().getPrefix()));
            }
            return m;
        }
    }
}

