/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import org.openrewrite.Cursor;
import org.openrewrite.Validated;
import org.openrewrite.ValidationException;
import org.openrewrite.java.JavaIsoProcessor;
import org.openrewrite.java.tree.J;

public class RenameVariable<P>
extends JavaIsoProcessor<P> {
    private final Cursor scope;
    private final String toName;
    private String scopeVariableName;

    public RenameVariable(Cursor scope, String toName) {
        this.scope = scope;
        Validated validated = Validated.test((String)"scope", (String)"Must be a cursor to a J.VariableDecls.NamedVar", (Object)scope, s -> s.getTree() instanceof J.VariableDecls.NamedVar);
        if (validated.isInvalid()) {
            throw new ValidationException(validated);
        }
        this.toName = toName;
        this.setCursoringOn();
    }

    @Override
    public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, P p) {
        this.scopeVariableName = ((J.VariableDecls.NamedVar)this.scope.getTree()).getSimpleName();
        return super.visitCompilationUnit(cu, (Object)p);
    }

    @Override
    public J.Ident visitIdentifier(J.Ident ident, P p) {
        if (ident.getSimpleName().equals(this.scopeVariableName) && this.isInSameNameScope(this.scope, this.getCursor()) && !(this.getCursor().getParentOrThrow().getTree() instanceof J.FieldAccess)) {
            return ident.withName(this.toName);
        }
        return super.visitIdentifier(ident, (Object)p);
    }
}

