/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.List;
import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.java.JavaIsoProcessor;
import org.openrewrite.java.RemoveUnusedImports;
import org.openrewrite.java.style.ImportLayoutStyle;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;

public class OrderImports
extends Recipe {
    private boolean removeUnused = true;

    public OrderImports() {
        this.processor = () -> new OrderImportsProcessor(this.removeUnused);
    }

    public void setRemoveUnused(boolean removeUnused) {
        this.removeUnused = removeUnused;
    }

    private static class OrderImportsProcessor
    extends JavaIsoProcessor<ExecutionContext> {
        private final boolean removeUnused;

        private OrderImportsProcessor(boolean removeUnused) {
            this.removeUnused = removeUnused;
        }

        @Override
        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
            ImportLayoutStyle layoutStyle = Optional.ofNullable((ImportLayoutStyle)cu.getStyle(ImportLayoutStyle.class)).orElse(IntelliJ.importLayout());
            List<JRightPadded<J.Import>> orderedImports = layoutStyle.orderImports(cu.getImports());
            if (orderedImports.size() != cu.getImports().size()) {
                cu = cu.withImports(orderedImports);
            }
            for (int i = 0; i < orderedImports.size(); ++i) {
                if (orderedImports.get(i) == cu.getImports().get(i)) continue;
                cu = cu.withImports(orderedImports);
            }
            if (this.removeUnused) {
                this.doAfterVisit(new RemoveUnusedImports());
            }
            return cu;
        }
    }
}

