/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.Validated;
import org.openrewrite.java.JavaIsoProcessor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public class DeleteMethodArgument
extends Recipe {
    private MethodMatcher methodMatcher;
    private Integer index;

    public DeleteMethodArgument() {
        this.processor = () -> new DeleteMethodArgumentProcessor(this.methodMatcher, this.index);
    }

    public void setMethod(String method) {
        this.methodMatcher = new MethodMatcher(method);
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public Validated validate() {
        return Validated.required((String)"method", (Object)this.methodMatcher).and(Validated.required((String)"index", (Object)this.index));
    }

    private static class DeleteMethodArgumentProcessor
    extends JavaIsoProcessor<ExecutionContext> {
        private final MethodMatcher methodMatcher;
        private final Integer index;

        public DeleteMethodArgumentProcessor(MethodMatcher methodMatcher, Integer index) {
            this.methodMatcher = methodMatcher;
            this.index = index;
        }

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J m = super.visitMethodInvocation(method, ctx);
            List<JRightPadded<Expression>> originalArgs = ((J.MethodInvocation)m).getArgs().getElem();
            if (this.methodMatcher.matches((J.MethodInvocation)m) && originalArgs.stream().filter(a -> !(a.getElem() instanceof J.Empty)).count() >= (long)(this.index + 1)) {
                List<JRightPadded<Object>> args = new ArrayList(((J.MethodInvocation)m).getArgs().getElem());
                args.remove(this.index);
                if (args.isEmpty()) {
                    args = Collections.singletonList(new JRightPadded<J.Empty>(new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY), Space.EMPTY));
                }
                m = ((J.MethodInvocation)m).withArgs(((J.MethodInvocation)m).getArgs().withElem(args));
            }
            return m;
        }
    }
}

