/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Validated;
import org.openrewrite.java.JavaIsoProcessor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.TypeTree;

public class ChangeMethodName
extends Recipe {
    private String method;
    private String name;

    public ChangeMethodName() {
        this.processor = () -> new ChangeMethodNameProcessor(new MethodMatcher(this.method), this.name);
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Validated validate() {
        return Validated.required((String)"method", (Object)this.method).and(Validated.required((String)"name", (Object)this.name));
    }

    private static class ChangeMethodNameProcessor
    extends JavaIsoProcessor<ExecutionContext> {
        private final MethodMatcher methodMatcher;
        private final String name;

        private ChangeMethodNameProcessor(MethodMatcher methodMatcher, String name) {
            this.methodMatcher = methodMatcher;
            this.name = name;
            this.setCursoringOn();
        }

        @Override
        public J.MethodDecl visitMethod(J.MethodDecl method, ExecutionContext ctx) {
            J m = super.visitMethod(method, ctx);
            J.ClassDecl classDecl = (J.ClassDecl)this.getCursor().firstEnclosing(J.ClassDecl.class);
            assert (classDecl != null);
            if (this.methodMatcher.matches(method, classDecl)) {
                m = ((J.MethodDecl)m).withName(((J.MethodDecl)m).getName().withName(this.name));
            }
            return m;
        }

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J m = super.visitMethodInvocation(method, ctx);
            if (this.methodMatcher.matches(method) && !method.getSimpleName().equals(this.name)) {
                m = ((J.MethodInvocation)m).withName(((J.MethodInvocation)m).getName().withName(this.name));
            }
            return m;
        }

        @Override
        public J.FieldAccess visitFieldAccess(J.FieldAccess fieldAccess, ExecutionContext ctx) {
            Expression target;
            J f = super.visitFieldAccess(fieldAccess, ctx);
            if (((J.FieldAccess)f).isFullyQualifiedClassReference(this.methodMatcher) && (target = ((J.FieldAccess)f).getTarget()) instanceof J.FieldAccess) {
                String className = target.printTrimmed();
                String fullyQualified = className + "." + this.name;
                return (J.FieldAccess)TypeTree.build(fullyQualified).withPrefix(((J.FieldAccess)f).getPrefix());
            }
            return f;
        }
    }
}

