/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoProcessor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public class ChangeFieldType<P>
extends JavaIsoProcessor<P> {
    private final JavaType.Class type;
    private final String targetType;

    public ChangeFieldType(JavaType.Class type, String targetType) {
        this.type = type;
        this.targetType = targetType;
    }

    @Override
    public J.VariableDecls visitMultiVariable(J.VariableDecls multiVariable, P p) {
        JavaType.Class typeAsClass = multiVariable.getTypeAsClass();
        J mv = super.visitMultiVariable(multiVariable, (Object)p);
        if (typeAsClass != null && typeAsClass.equals(this.type)) {
            JavaType.Class type = JavaType.Class.build(this.targetType);
            this.maybeAddImport(this.targetType);
            this.maybeRemoveImport(typeAsClass);
            mv = ((J.VariableDecls)mv).withTypeExpr(((J.VariableDecls)mv).getTypeExpr() == null ? null : J.Ident.build(((J.VariableDecls)mv).getTypeExpr().getId(), ((J.VariableDecls)mv).getTypeExpr().getPrefix(), Markers.EMPTY, type.getClassName(), type));
            mv = ((J.VariableDecls)mv).withVars(ListUtils.map(((J.VariableDecls)mv).getVars(), var -> {
                JavaType.Class varType = TypeUtils.asClass(((J.VariableDecls.NamedVar)var.getElem()).getType());
                if (varType != null && !varType.equals(type)) {
                    return var.map(v -> v.withType(type).withName(v.getName().withType(type)));
                }
                return var;
            }));
        }
        return mv;
    }
}

